/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.form.support;

import com.alibaba.citrus.service.form.Field;
import com.alibaba.citrus.service.form.Form;
import com.alibaba.citrus.service.form.FormService;
import com.alibaba.citrus.service.form.Group;
import com.alibaba.citrus.service.pull.ToolFactory;
import com.alibaba.citrus.service.requestcontext.parser.ParserRequestContext;
import com.alibaba.citrus.service.requestcontext.util.RequestContextUtil;
import com.alibaba.citrus.springext.support.parser.AbstractSingleBeanDefinitionParser;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringEscapeUtil;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import org.apache.ecs.xhtml.input;
import org.springframework.beans.factory.annotation.Autowired;

public class FormTool
implements ToolFactory {
    private FormService formService;
    private HttpServletRequest request;

    @Autowired
    public void setFormService(FormService formService) {
        this.formService = formService;
    }

    @Autowired
    public void setRequest(HttpServletRequest request) {
        this.request = SpringExtUtil.assertProxy(request);
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public Object createTool() throws Exception {
        return this;
    }

    public GroupHelper get(String groupName) {
        return new GroupHelper(groupName);
    }

    public Iterator<GroupInstanceHelper> getGroups() {
        return new GroupInstanceHelperIterator(this.getForm().getGroups().iterator());
    }

    public Iterator<GroupInstanceHelper> getGroups(String groupName) {
        return new GroupInstanceHelperIterator(this.getForm().getGroups(groupName).iterator());
    }

    public boolean isValid() {
        return this.getForm().isValid();
    }

    private Form getForm() {
        return this.formService.getForm();
    }

    public String toString() {
        return this.formService == null ? "FormTool[no FormService]" : this.formService.toString();
    }

    public static class DefinitionParser
    extends AbstractSingleBeanDefinitionParser<FormTool> {
    }

    private static abstract class FilterIterator<E, F>
    implements Iterator<E> {
        protected final Iterator<F> i;

        public FilterIterator(Iterator<F> i) {
            this.i = Assert.assertNotNull(i);
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public void remove() {
            this.i.remove();
        }
    }

    private class FieldHelperIterator
    extends FilterIterator<FieldHelper, Field> {
        private FieldHelperIterator(Iterator<Field> i) {
            super(i);
        }

        @Override
        public FieldHelper next() {
            return new FieldHelper((Field)this.i.next());
        }
    }

    public class FieldHelper {
        private final Field field;
        private String htmlFieldSuffix;

        public FieldHelper(Field field) {
            this.field = field;
        }

        public String getDisplayName() {
            return this.field.getFieldConfig().getDisplayName();
        }

        public String getKey() {
            return this.field.getKey();
        }

        public String getHtmlKey() {
            if (this.htmlFieldSuffix == null) {
                this.htmlFieldSuffix = RequestContextUtil.findRequestContext(FormTool.this.request, ParserRequestContext.class).getHtmlFieldSuffix();
            }
            return this.field.getKey() + this.htmlFieldSuffix;
        }

        public String getAbsentKey() {
            return this.field.getAbsentKey();
        }

        public String getAttachmentKey() {
            return this.field.getAttachmentKey();
        }

        public String getValue() {
            return this.field.getStringValue();
        }

        public String getEscapedValue() {
            return StringEscapeUtil.escapeHtml(this.field.getStringValue());
        }

        public String[] getValues() {
            return this.field.getStringValues();
        }

        public String[] getEscapedValues() {
            String[] values = this.field.getStringValues();
            String[] escapedValues = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                escapedValues[i] = StringEscapeUtil.escapeHtml(values[i]);
            }
            return escapedValues;
        }

        public input getAbsentHiddenField(String value) {
            return new input("hidden", this.field.getAbsentKey(), ObjectUtil.defaultIfNull(value, ""));
        }

        public Object getAttachment() {
            return this.field.getAttachment();
        }

        public String getAttachmentEncoded() {
            return ObjectUtil.defaultIfNull(this.field.getAttachmentEncoded(), "");
        }

        public boolean hasAttachment() {
            return this.field.hasAttachment();
        }

        public void setAttachment(Object attachment) {
            this.field.setAttachment(attachment);
        }

        public input getAttachmentHiddenField() {
            return new input("hidden", this.field.getAttachmentKey(), this.getAttachmentEncoded());
        }

        public void clearAttachment() {
            this.field.clearAttachment();
        }

        public boolean isValid() {
            return this.field.isValid();
        }

        public String getMessage() {
            return this.field.getMessage();
        }

        public String toString() {
            return this.field.toString();
        }
    }

    private class GroupInstanceHelperIterator
    extends FilterIterator<GroupInstanceHelper, Group> {
        private GroupInstanceHelperIterator(Iterator<Group> i) {
            super(i);
        }

        @Override
        public GroupInstanceHelper next() {
            return new GroupInstanceHelper((Group)this.i.next());
        }
    }

    public class GroupInstanceHelper {
        private final Group group;

        public GroupInstanceHelper(Group group) {
            this.group = group;
        }

        public FieldHelper get(String fieldName) {
            Field field = this.group.getField(fieldName);
            return field == null ? null : new FieldHelper(field);
        }

        public Iterator<FieldHelper> getFields() {
            return new FieldHelperIterator(this.group.getFields().iterator());
        }

        public boolean isValid() {
            return this.group.isValid();
        }

        public boolean isValidated() {
            return this.group.isValidated();
        }

        public void mapTo(Object object) {
            this.group.mapTo(object);
        }

        public String toString() {
            return this.group.toString();
        }
    }

    public class GroupHelper {
        private final String groupName;

        public GroupHelper(String groupName) {
            this.groupName = groupName;
        }

        public GroupInstanceHelper getDefaultInstance() {
            Group group = FormTool.this.getForm().getGroup(this.groupName);
            return group == null ? null : new GroupInstanceHelper(group);
        }

        public GroupInstanceHelper getInstance(String instanceName) {
            Group group = FormTool.this.getForm().getGroup(this.groupName, instanceName);
            return group == null ? null : new GroupInstanceHelper(group);
        }

        public GroupInstanceHelper getInstance(String instanceName, boolean create) {
            Group group = FormTool.this.getForm().getGroup(this.groupName, instanceName, create);
            return group == null ? null : new GroupInstanceHelper(group);
        }

        public String toString() {
            return "Group[" + this.groupName + "]";
        }
    }
}

