/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.form.impl.validation;

import com.alibaba.citrus.service.form.Validator;
import com.alibaba.citrus.service.form.support.AbstractValidator;
import com.alibaba.citrus.service.form.support.AbstractValidatorDefinitionParser;
import com.alibaba.citrus.util.ArrayUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.FileUtil;
import com.alibaba.citrus.util.HumanReadableSize;
import com.alibaba.citrus.util.StringUtil;
import java.util.LinkedList;
import org.apache.commons.fileupload.FileItem;

public class UploadedFileValidator
extends AbstractValidator {
    private String[] contentTypes;
    private String[] extensions;
    private HumanReadableSize minSize = new HumanReadableSize(-1L);
    private HumanReadableSize maxSize = new HumanReadableSize(-1L);

    public String[] getContentType() {
        return this.contentTypes;
    }

    public void setContentType(String[] contentTypes) {
        this.contentTypes = this.normalizeStrings(contentTypes, 0);
    }

    public String[] getExtension() {
        return this.extensions;
    }

    public void setExtension(String[] extensions) {
        this.extensions = this.normalizeStrings(extensions, 1);
    }

    public HumanReadableSize getMinSize() {
        return this.minSize;
    }

    public void setMinSize(HumanReadableSize minSize) {
        this.minSize = Assert.assertNotNull(minSize, "minSize", new Object[0]);
    }

    public HumanReadableSize getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(HumanReadableSize maxSize) {
        this.maxSize = Assert.assertNotNull(maxSize, "maxSize", new Object[0]);
    }

    @Override
    public boolean validate(Validator.Context context) {
        long minSize = this.minSize.getValue();
        long maxSize = this.maxSize.getValue();
        if (ArrayUtil.isEmptyArray(this.contentTypes) && ArrayUtil.isEmptyArray(this.extensions) && maxSize <= 0L && minSize < 0L) {
            return true;
        }
        FileItem[] fileItems = context.getField().getFileItems();
        if (ArrayUtil.isEmptyArray(fileItems)) {
            return true;
        }
        for (FileItem fileItem : fileItems) {
            boolean matched;
            if (fileItem == null) continue;
            if (minSize >= 0L && fileItem.getSize() < minSize) {
                return false;
            }
            if (maxSize >= 0L && fileItem.getSize() > maxSize) {
                return false;
            }
            if (!ArrayUtil.isEmptyArray(this.contentTypes)) {
                String fileContentType = this.normalizeContentType(fileItem.getContentType());
                if (fileContentType == null) {
                    return false;
                }
                matched = false;
                for (String expectedContentType : this.contentTypes) {
                    if (!fileContentType.startsWith(expectedContentType)) continue;
                    matched = true;
                    break;
                }
                if (!matched) {
                    return false;
                }
            }
            if (ArrayUtil.isEmptyArray(this.extensions)) continue;
            String ext = FileUtil.getExtension(fileItem.getName(), "null");
            if (ext == null) {
                return false;
            }
            matched = false;
            for (String expectedExtension : this.extensions) {
                if (!expectedExtension.equals(ext)) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            return false;
        }
        return true;
    }

    private String[] normalizeStrings(String[] strs, int type) {
        if (ArrayUtil.isEmptyArray(strs)) {
            return null;
        }
        LinkedList<String> strList = CollectionUtil.createLinkedList();
        for (String str : strs) {
            switch (type) {
                case 0: {
                    str = this.normalizeContentType(str);
                    break;
                }
                case 1: {
                    str = FileUtil.normalizeExtension(str);
                    break;
                }
                default: {
                    Assert.unreachableCode();
                }
            }
            if (str == null) continue;
            strList.add(str);
        }
        if (strList.isEmpty()) {
            return null;
        }
        return strList.toArray(new String[strList.size()]);
    }

    private String normalizeContentType(String contentType) {
        if ((contentType = StringUtil.trimToNull(contentType)) != null) {
            contentType = contentType.toLowerCase();
        }
        return contentType;
    }

    public static class DefinitionParser
    extends AbstractValidatorDefinitionParser<UploadedFileValidator> {
    }
}

