/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.configuration.impl;

import com.alibaba.citrus.service.configuration.support.PropertyPlaceholderConfigurer;
import com.alibaba.citrus.springext.support.parser.AbstractSingleBeanDefinitionParser;
import com.alibaba.citrus.springext.util.DomUtil;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.util.StringUtil;
import java.util.List;
import java.util.Properties;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class PropertyPlaceholderConfigurerDefinitionParser
extends AbstractSingleBeanDefinitionParser<PropertyPlaceholderConfigurer> {
    protected boolean shouldGenerateId() {
        return true;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        Properties specificProps;
        SpringExtUtil.attributesToProperties(element, builder, "ignoreUnresolvablePlaceholders");
        String location = StringUtil.trimToNull(element.getAttribute("location"));
        if (location != null) {
            builder.addPropertyValue("locationNames", (Object)location);
        }
        List<Object> propsList = SpringExtUtil.createManagedList(element, parserContext);
        String propertiesRef = StringUtil.trimToNull(element.getAttribute("properties-ref"));
        if (propertiesRef != null) {
            propsList.add(new RuntimeBeanReference(propertiesRef));
        }
        if ((specificProps = this.parseProperties(element)) != null) {
            propsList.add(specificProps);
        }
        builder.addPropertyValue("propertiesArray", propsList);
        builder.setRole(2);
    }

    private Properties parseProperties(Element element) {
        Properties props = new Properties();
        for (Element propertyElement : DomUtil.subElements(element, DomUtil.and(DomUtil.sameNs(element), DomUtil.name("property")))) {
            String key = StringUtil.trimToEmpty(propertyElement.getAttribute("key"));
            String value = StringUtil.trimToNull(propertyElement.getTextContent());
            props.setProperty(key, value);
        }
        return props.isEmpty() ? null : props;
    }
}

