/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.generictype.impl;

import com.alibaba.citrus.generictype.ClassTypeInfo;
import com.alibaba.citrus.generictype.FieldInfo;
import com.alibaba.citrus.generictype.GenericDeclarationInfo;
import com.alibaba.citrus.generictype.TypeInfo;
import com.alibaba.citrus.util.Assert;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class FieldImpl
implements FieldInfo {
    private static final int MODIFIERS_MASK = 15;
    private final int modifiers;
    private final Field field;
    private final ClassTypeInfo declaringType;
    private final TypeInfo type;

    FieldImpl(Field field, ClassTypeInfo declaringType, TypeInfo type) {
        this.field = Assert.assertNotNull(field, "field", new Object[0]);
        this.modifiers = field.getModifiers() & 0xF;
        this.declaringType = declaringType;
        this.type = type;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public TypeInfo getDeclaringType() {
        return this.declaringType;
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    @Override
    public TypeInfo getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.field.getName();
    }

    @Override
    public FieldInfo resolve(GenericDeclarationInfo context) {
        return this.resolve(context, true);
    }

    @Override
    public FieldInfo resolve(GenericDeclarationInfo context, boolean includeBaseType) {
        TypeInfo resolvedType = this.type.resolve(context, includeBaseType);
        if (this.type != resolvedType) {
            return new FieldImpl(this.field, this.declaringType, resolvedType);
        }
        return this;
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.field.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !other.getClass().equals(this.getClass())) {
            return false;
        }
        FieldImpl otherField = (FieldImpl)other;
        return this.field.equals(otherField.field);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        String mod = Modifier.toString(this.modifiers);
        if (mod.length() > 0) {
            buf.append(mod).append(" ");
        }
        buf.append(this.type).append(" ");
        buf.append(this.declaringType.getSimpleName()).append(".").append(this.getName());
        return buf.toString();
    }
}

