/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.expr.jexl;

import com.alibaba.citrus.expr.ExpressionContext;
import com.alibaba.citrus.expr.support.ExpressionSupport;
import com.alibaba.citrus.util.Assert;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JexlExpression
extends ExpressionSupport {
    private static final Logger log = LoggerFactory.getLogger(JexlExpression.class);
    private Expression expression;

    public JexlExpression(Expression expr) {
        this.expression = expr;
    }

    @Override
    public String getExpressionText() {
        return this.expression.getExpression();
    }

    @Override
    public Object evaluate(ExpressionContext context) {
        try {
            JexlContextAdapter jexlContext = new JexlContextAdapter(context);
            if (log.isDebugEnabled()) {
                log.debug("Evaluating EL: " + this.expression.getExpression());
            }
            Object value = this.expression.evaluate((JexlContext)jexlContext);
            if (log.isDebugEnabled()) {
                log.debug("value of expression: " + value);
            }
            return value;
        }
        catch (Exception e) {
            log.warn("Caught exception evaluating: " + this.expression + ". Reason: " + e, (Throwable)e);
            return null;
        }
    }

    private static class JexlContextAdapter
    implements JexlContext {
        private ExpressionContext expressionContext;

        public JexlContextAdapter(ExpressionContext expressionContext) {
            this.expressionContext = Assert.assertNotNull(expressionContext, "expressionContext", new Object[0]);
        }

        public Object get(String key) {
            return this.expressionContext.get(key);
        }

        public void set(String key, Object value) {
            this.expressionContext.put(key, value);
        }

        public boolean has(String key) {
            return this.expressionContext.get(key) != null;
        }
    }
}

