/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.dev.handler.util;

import com.alibaba.citrus.dev.handler.util.AnchorValue;
import com.alibaba.citrus.dev.handler.util.ClassValue;
import com.alibaba.citrus.dev.handler.util.Element;
import com.alibaba.citrus.dev.handler.util.RawValue;
import com.alibaba.citrus.dev.handler.util.RefValue;
import com.alibaba.citrus.dev.handler.util.StyledValue;
import com.alibaba.citrus.dev.handler.util.TextValue;
import com.alibaba.citrus.util.ArrayUtil;
import com.alibaba.citrus.util.BasicConstant;
import com.alibaba.citrus.util.ClassUtil;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanNameReference;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.AutowireCandidateQualifier;
import org.springframework.beans.factory.support.LookupOverride;
import org.springframework.beans.factory.support.MethodOverride;
import org.springframework.beans.factory.support.ReplaceOverride;

public class BeanDefinitionReverseEngine {
    private final AbstractBeanDefinition bd;
    private final String name;
    private final String[] aliases;
    private final Element beanElement;
    private final boolean innerBean;
    private static final char[] controlChars;

    public BeanDefinitionReverseEngine(AbstractBeanDefinition bd, String name, String[] aliases) {
        this(bd, name, aliases, null);
    }

    public BeanDefinitionReverseEngine(AbstractBeanDefinition bd, String name, String[] aliases, Element parentElement) {
        this.bd = bd;
        this.name = StringUtil.trimToNull(name);
        this.aliases = ArrayUtil.defaultIfEmptyArray(aliases, BasicConstant.EMPTY_STRING_ARRAY);
        this.beanElement = new Element("bean");
        boolean bl = this.innerBean = parentElement != null;
        if (this.innerBean) {
            parentElement.subElements.add(this.beanElement);
        }
        this.doReverseEngineering();
    }

    private void doReverseEngineering() {
        this.beanAttributes();
        this.beanConstructorArgs();
        this.beanProperties();
        this.methodOverrides();
        this.qualifiers();
    }

    private void beanAttributes() {
        if (!this.innerBean && this.name != null) {
            this.beanElement.addAttribute("id", new AnchorValue(new String[]{this.name}));
        }
        if (!this.innerBean && this.aliases.length > 0) {
            this.beanElement.addAttribute("name", new AnchorValue(this.aliases));
        }
        if (this.bd.isAbstract()) {
            this.beanElement.addAttribute("abstract", "true");
        }
        if (this.bd.getParentName() != null) {
            this.beanElement.addAttribute("parent", new RefValue(new String[]{this.bd.getParentName()}));
        }
        if (this.bd.getBeanClassName() != null) {
            this.beanElement.addAttribute("class", new ClassValue(this.bd.getBeanClassName()));
        }
        if (this.bd.isPrimary()) {
            this.beanElement.addAttribute("primary", "true");
        }
        String autowireMode = null;
        switch (this.bd.getAutowireMode()) {
            case 4: {
                autowireMode = "autodetect";
                break;
            }
            case 1: {
                autowireMode = "byName";
                break;
            }
            case 2: {
                autowireMode = "byType";
                break;
            }
            case 3: {
                autowireMode = "constructor";
            }
        }
        if (autowireMode != null) {
            this.beanElement.addAttribute("autowire", autowireMode);
        }
        if (!this.bd.isAutowireCandidate()) {
            this.beanElement.addAttribute("autowire-candidate", "false");
        }
        String dependencyCheck = null;
        switch (this.bd.getDependencyCheck()) {
            case 3: {
                dependencyCheck = "all";
                break;
            }
            case 1: {
                dependencyCheck = "objects";
                break;
            }
            case 2: {
                dependencyCheck = "simple";
            }
        }
        if (dependencyCheck != null) {
            this.beanElement.addAttribute("dependency-check", dependencyCheck);
        }
        if (!ArrayUtil.isEmptyArray(this.bd.getDependsOn())) {
            this.beanElement.addAttribute("depends-on", new RefValue(this.bd.getDependsOn()));
        }
        if (this.bd.getScope() != null && !"singleton".equals(this.bd.getScope())) {
            this.beanElement.addAttribute("scope", this.bd.getScope());
        }
        if (this.bd.getInitMethodName() != null) {
            this.beanElement.addAttribute("init-method", this.bd.getInitMethodName());
        }
        if (this.bd.getDestroyMethodName() != null) {
            this.beanElement.addAttribute("destroy-method", this.bd.getDestroyMethodName());
        }
        if (this.bd.isLazyInit()) {
            this.beanElement.addAttribute("lazy-init", "true");
        }
        if (this.bd.getFactoryBeanName() != null) {
            this.beanElement.addAttribute("factory-bean", new RefValue(new String[]{this.bd.getFactoryBeanName()}));
        }
        if (this.bd.getFactoryMethodName() != null) {
            this.beanElement.addAttribute("factory-method", this.bd.getFactoryMethodName());
        }
    }

    private void beanConstructorArgs() {
        ConstructorArgumentValues values = this.bd.getConstructorArgumentValues();
        TreeMap indexedArgs = new TreeMap(values.getIndexedArgumentValues());
        for (Map.Entry entry : indexedArgs.entrySet()) {
            Integer index = (Integer)entry.getKey();
            ConstructorArgumentValues.ValueHolder valueHolder = (ConstructorArgumentValues.ValueHolder)entry.getValue();
            Element constructorArgElement = this.beanElement.newSubElement("constructor-arg");
            constructorArgElement.addAttribute("index", index.toString());
            this.beanConstructorArg(constructorArgElement, valueHolder);
        }
        List genericArgs = values.getGenericArgumentValues();
        for (ConstructorArgumentValues.ValueHolder valueHolder : genericArgs) {
            Element constructorArgElement = this.beanElement.newSubElement("constructor-arg");
            this.beanConstructorArg(constructorArgElement, valueHolder);
        }
    }

    private void beanConstructorArg(Element constructorArgElement, ConstructorArgumentValues.ValueHolder valueHolder) {
        if (valueHolder.getType() != null) {
            constructorArgElement.addAttribute("type", new ClassValue(valueHolder.getType()));
        }
        this.value(constructorArgElement, valueHolder.getValue(), true, true, null, null);
    }

    private void beanProperties() {
        MutablePropertyValues values = this.bd.getPropertyValues();
        ArrayList<PropertyValue> props = CollectionUtil.createArrayList(values.getPropertyValues());
        Collections.sort(props, new Comparator<PropertyValue>(){

            @Override
            public int compare(PropertyValue o1, PropertyValue o2) {
                String n1 = o1.getName();
                String n2 = o2.getName();
                if (n1 != null && n2 != null) {
                    return n1.compareTo(n2);
                }
                if (n1 == null && n2 == null) {
                    return 0;
                }
                if (n1 == null) {
                    return -1;
                }
                return 1;
            }
        });
        for (PropertyValue prop : props) {
            Element propertyElement = this.beanElement.newSubElement("property");
            if (prop.getName() != null) {
                propertyElement.addAttribute("name", prop.getName());
            }
            this.value(propertyElement, prop.getValue(), true, true, null, null);
        }
    }

    private void value(Element element, Object value, boolean supportValueAttribute, boolean supportRefAttribute, Element containerElement, String typeAttrName) {
        if (value == null || value instanceof TypedStringValue && ((TypedStringValue)value).getValue() == null) {
            element.newSubElement("null");
            return;
        }
        if (value instanceof RuntimeBeanReference) {
            String refto = ((RuntimeBeanReference)value).getBeanName();
            if (((RuntimeBeanReference)value).isToParent()) {
                element.newSubElement("ref").addAttribute("parent", new RefValue(new String[]{refto}));
            } else if (supportRefAttribute) {
                element.addAttribute("ref", new RefValue(new String[]{refto}));
            } else {
                element.newSubElement("ref").addAttribute("bean", new RefValue(new String[]{refto}));
            }
            return;
        }
        if (value instanceof RuntimeBeanNameReference) {
            element.newSubElement("idref").addAttribute("bean", new RefValue(new String[]{((RuntimeBeanNameReference)value).getBeanName()}));
            return;
        }
        BeanDefinition innerBd = null;
        String innerName = null;
        String[] innerAliases = null;
        if (value instanceof BeanDefinitionHolder) {
            innerBd = ((BeanDefinitionHolder)value).getBeanDefinition();
            innerName = ((BeanDefinitionHolder)value).getBeanName();
            innerAliases = ((BeanDefinitionHolder)value).getAliases();
        } else if (value instanceof BeanDefinition) {
            innerBd = (BeanDefinition)value;
        }
        if (innerBd != null) {
            if (innerBd instanceof AbstractBeanDefinition) {
                new BeanDefinitionReverseEngine((AbstractBeanDefinition)innerBd, innerName, innerAliases, element);
            } else {
                element.newSubElement("bean").addAttribute("unknownBeanDefinitionType", new ClassValue(innerBd.getClass().getName()));
            }
            return;
        }
        if (value.getClass().isArray()) {
            value = CollectionUtil.createLinkedList(ArrayUtil.arrayAsIterable(Object.class, value));
        }
        if (value instanceof List) {
            Element listElement = element.newSubElement("list");
            for (Object itemValue : (List)value) {
                this.value(listElement, itemValue, false, false, listElement, "value-type");
            }
            return;
        }
        if (value instanceof Set) {
            Element setElement = element.newSubElement("set");
            for (Object itemValue : (Set)((Object)value)) {
                this.value(setElement, itemValue, false, false, setElement, "value-type");
            }
            return;
        }
        if (value instanceof Properties) {
            Element propsElement = element.newSubElement("props");
            for (Map.Entry entry : ((Map)((Object)value)).entrySet()) {
                Element propElement = propsElement.newSubElement("prop");
                propElement.addAttribute("key", String.valueOf(entry.getKey()));
                propElement.setText(String.valueOf(entry.getValue()));
            }
            return;
        }
        if (value instanceof Map) {
            Element mapElement = element.newSubElement("map");
            for (Map.Entry entry : ((Map)((Object)value)).entrySet()) {
                Element entryElement = mapElement.newSubElement("entry");
                this.mapEntryKeyValue(entryElement, entry.getKey(), "key-ref", "key", "key", mapElement, "key-type");
                this.mapEntryKeyValue(entryElement, entry.getValue(), "value-ref", "value", null, mapElement, "value-type");
            }
            return;
        }
        if (value instanceof TypedStringValue) {
            this.simpleValue(element, new TextValue(((TypedStringValue)value).getValue()), ((TypedStringValue)value).getTargetTypeName(), supportValueAttribute, containerElement, typeAttrName);
            return;
        }
        if (value instanceof String || ClassUtil.getPrimitiveType(value.getClass()) != null) {
            this.simpleValue(element, new TextValue(((Object)value).toString()), null, supportValueAttribute, containerElement, typeAttrName);
            return;
        }
        this.simpleValue(element, new RawValue(value.getClass(), ((Object)value).toString()), null, supportValueAttribute, containerElement, typeAttrName);
    }

    private void mapEntryKeyValue(Element entryElement, Object keyOrValue, String refAttrName, String valueAttrName, String valueElementName, Element mapElement, String typeAttrName) {
        if (keyOrValue != null) {
            if (keyOrValue instanceof RuntimeBeanReference) {
                String refto = ((RuntimeBeanReference)keyOrValue).getBeanName();
                if (!((RuntimeBeanReference)keyOrValue).isToParent()) {
                    entryElement.addAttribute(refAttrName, new RefValue(new String[]{refto}));
                    return;
                }
            }
            String simpleValue = null;
            if (keyOrValue instanceof TypedStringValue) {
                String type = ((TypedStringValue)keyOrValue).getTargetTypeName();
                if (type != null) {
                    if (mapElement != null && typeAttrName != null && !mapElement.hasAttribute(typeAttrName)) {
                        mapElement.addAttribute(typeAttrName, new ClassValue(type));
                    }
                    if (type.equals(mapElement.getAttribute(typeAttrName))) {
                        type = null;
                    }
                }
                if (type == null) {
                    simpleValue = ((TypedStringValue)keyOrValue).getValue();
                }
            }
            if (keyOrValue instanceof String || ClassUtil.getPrimitiveType(keyOrValue.getClass()) != null) {
                simpleValue = keyOrValue.toString();
            }
            if (simpleValue != null && !BeanDefinitionReverseEngine.hasControlChars(simpleValue)) {
                entryElement.addAttribute(valueAttrName, simpleValue);
                return;
            }
        }
        if (valueElementName != null) {
            this.value(entryElement.newSubElement(valueElementName), keyOrValue, false, false, null, null);
        } else {
            this.value(entryElement, keyOrValue, false, false, null, null);
        }
    }

    private void simpleValue(Element element, StyledValue value, String type, boolean supportValueAttribute, Element containerElement, String typeAttrName) {
        if (type != null) {
            if (containerElement != null && typeAttrName != null && !containerElement.hasAttribute(typeAttrName)) {
                containerElement.addAttribute(typeAttrName, new ClassValue(type));
            }
            if (type.equals(containerElement.getAttribute(typeAttrName))) {
                type = null;
            }
        }
        if (type == null && supportValueAttribute && !BeanDefinitionReverseEngine.hasControlChars(value.getText())) {
            element.addAttribute("value", value);
            return;
        }
        Element valueElement = element.newSubElement("value").setText(value);
        if (type != null) {
            valueElement.addAttribute("type", new ClassValue(type));
        }
    }

    private void methodOverrides() {
        Set overrides = this.bd.getMethodOverrides().getOverrides();
        for (MethodOverride override : overrides) {
            String name;
            String bean;
            if (override instanceof LookupOverride) {
                Element lookupMethodElement = this.beanElement.newSubElement("lookup-method");
                bean = ((LookupOverride)override).getBeanName();
                name = override.getMethodName();
                if (bean != null) {
                    lookupMethodElement.addAttribute("bean", new RefValue(new String[]{bean}));
                }
                if (name == null) continue;
                lookupMethodElement.addAttribute("name", name);
                continue;
            }
            if (!(override instanceof ReplaceOverride)) continue;
            Element replacedMethodElement = this.beanElement.newSubElement("replaced-method");
            bean = ((ReplaceOverride)override).getMethodReplacerBeanName();
            name = override.getMethodName();
            if (bean != null) {
                replacedMethodElement.addAttribute("replacer", new RefValue(new String[]{bean}));
            }
            if (name == null) continue;
            replacedMethodElement.addAttribute("name", name);
        }
    }

    private void qualifiers() {
        Set qualifiers = this.bd.getQualifiers();
        for (AutowireCandidateQualifier q : qualifiers) {
            Element qualifierElement = this.beanElement.newSubElement("qualifier");
            if (q.getTypeName() != null) {
                qualifierElement.addAttribute("type", new ClassValue(q.getTypeName()));
            }
            if (q.getAttribute("value") != null) {
                qualifierElement.addAttribute("value", String.valueOf(q.getAttribute("value")));
            }
            for (String attrName : q.attributeNames()) {
                if ("value".equals(attrName)) continue;
                Element attrElement = qualifierElement.newSubElement("attribute");
                attrElement.addAttribute("key", String.valueOf(attrName));
                attrElement.addAttribute("value", String.valueOf(q.getAttribute(attrName)));
            }
        }
    }

    static boolean hasControlChars(String text) {
        return !StringUtil.containsNone(text, controlChars);
    }

    public final Element toDom() {
        return this.beanElement;
    }

    static {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < 32; ++i) {
            buf.append((char)i);
        }
        controlChars = buf.toString().toCharArray();
    }
}

