/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.dev.handler.component;

import com.alibaba.citrus.dev.handler.util.AnchorValue;
import com.alibaba.citrus.dev.handler.util.Attribute;
import com.alibaba.citrus.dev.handler.util.ClassValue;
import com.alibaba.citrus.dev.handler.util.DomUtil;
import com.alibaba.citrus.dev.handler.util.Element;
import com.alibaba.citrus.dev.handler.util.RawValue;
import com.alibaba.citrus.dev.handler.util.RefValue;
import com.alibaba.citrus.dev.handler.util.StyledValue;
import com.alibaba.citrus.dev.handler.util.TextValue;
import com.alibaba.citrus.util.ClassUtil;
import com.alibaba.citrus.util.StringEscapeUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.internal.webpagelite.PageComponent;
import com.alibaba.citrus.util.internal.webpagelite.PageComponentRegistry;
import com.alibaba.citrus.util.templatelite.FallbackTextWriter;
import com.alibaba.citrus.util.templatelite.Template;
import com.alibaba.citrus.webx.handler.RequestHandlerContext;
import com.alibaba.citrus.webx.handler.support.AbstractVisitor;
import java.io.PrintWriter;
import java.util.Iterator;

public class DomComponent
extends PageComponent {
    public DomComponent(PageComponentRegistry registry, String componentPath) {
        super(registry, componentPath);
    }

    public void visitTemplate(RequestHandlerContext context, Iterable<Element> elements) {
        this.visitTemplate(context, elements, null);
    }

    public void visitTemplate(RequestHandlerContext context, Iterable<Element> elements, ControlBarCallback controlBarCallback) {
        this.getTemplate().accept(new ElementsVisitor(context, elements, controlBarCallback));
    }

    private class StyledValueVisitor
    extends FallbackTextWriter<PrintWriter> {
        private final StyledValue value;
        private boolean withSep;

        public StyledValueVisitor(StyledValue value, PrintWriter out) {
            super(out);
            this.value = value;
        }

        private void visitStyledValue(Template[] styledTextTemplates) {
            if (this.value instanceof TextValue) {
                Template template = styledTextTemplates[0];
                this.context().put("value", this.value.getText());
                template.accept(this);
            } else if (this.value instanceof RawValue) {
                Template template = styledTextTemplates[1];
                this.context().put("packageName", ((RawValue)this.value).getRawType().getPackage().getName());
                this.context().put("className", ClassUtil.getSimpleClassName(((RawValue)this.value).getRawType()));
                this.context().put("value", ((RawValue)this.value).getRawToString());
                template.accept(this);
            } else if (this.value instanceof ClassValue) {
                Template template = styledTextTemplates[2];
                this.context().put("packageName", ((ClassValue)this.value).getPackageName());
                this.context().put("className", ((ClassValue)this.value).getSimpleName());
                template.accept(this);
            } else if (this.value instanceof AnchorValue) {
                Template template = styledTextTemplates[3];
                int i = 0;
                for (String name : ((AnchorValue)this.value).getNames()) {
                    this.context().put("anchorName", DomUtil.toId(name));
                    this.context().put("anchorNameDisplay", name);
                    this.withSep = i++ > 0;
                    template.accept(this);
                }
            } else if (this.value instanceof RefValue) {
                Template template = styledTextTemplates[4];
                int i = 0;
                for (String name : ((RefValue)this.value).getNames()) {
                    this.context().put("refName", DomUtil.toId(name));
                    this.context().put("refNameDisplay", name);
                    this.withSep = i++ > 0;
                    template.accept(this);
                }
            } else {
                ((PrintWriter)this.out()).print("unknown value: " + this.value);
            }
        }

        public void visitSep(Template sepTemplate) {
            if (this.withSep) {
                sepTemplate.accept(this);
            }
        }

        public void visitPackageName() {
            String packageName = (String)this.context().get("packageName");
            if (!StringUtil.isEmpty(packageName) && !packageName.endsWith(".")) {
                packageName = packageName + ".";
            }
            ((PrintWriter)this.out()).print(packageName);
        }
    }

    private class ElementsVisitor
    extends AbstractVisitor {
        private final Iterable<Element> elements;
        private final ControlBarCallback controlBarCallback;
        private Element element;
        private Attribute attr;

        public ElementsVisitor(RequestHandlerContext context, Iterable<Element> elements, ControlBarCallback controlBarCallback) {
            super(context, DomComponent.this);
            this.elements = elements;
            this.controlBarCallback = controlBarCallback;
        }

        public void visitControlBar(Template controlBarTemplate) {
            if (this.controlBarCallback == null) {
                controlBarTemplate.accept(this);
            } else {
                this.controlBarCallback.renderControlBar();
            }
        }

        public void visitElementList(Template orderedTemplate, Template unorderedTemplate) {
            Iterator<Element> i = this.elements.iterator();
            if (i.hasNext() && i.next() != null && i.hasNext()) {
                orderedTemplate.accept(this);
            } else {
                unorderedTemplate.accept(this);
            }
        }

        public void visitElements(Template elementWithSubElementsTemplate, Template elementSelfClosedTemplate, Template elementWithTextTemplate) {
            Iterator<Element> i$ = this.elements.iterator();
            while (i$.hasNext()) {
                Element element;
                this.element = element = i$.next();
                if (element.hasSubElements()) {
                    elementWithSubElementsTemplate.accept(this);
                    continue;
                }
                if (element.getText() != null) {
                    elementWithTextTemplate.accept(this);
                    continue;
                }
                elementSelfClosedTemplate.accept(this);
            }
        }

        public void visitSubElements(Template elementWithSubElementsTemplate, Template elementSelfClosedTemplate, Template elementWithTextTemplate) {
            new ElementsVisitor(this.context, this.element.subElements(), this.controlBarCallback).visitElements(elementWithSubElementsTemplate, elementSelfClosedTemplate, elementWithTextTemplate);
        }

        public void visitElementId() {
            ((PrintWriter)this.out()).print(StringEscapeUtil.escapeHtml(this.element.getId()));
        }

        public void visitElementPrefix(Template prefixTemplate) {
            if (this.element.getPrefix() != null) {
                prefixTemplate.accept(this);
            }
        }

        public void visitElementPrefix() {
            ((PrintWriter)this.out()).print(StringEscapeUtil.escapeHtml(this.element.getPrefix()));
        }

        public void visitElementNs(Template nsTemplate) {
            if (this.element.getNs() != null) {
                nsTemplate.accept(this);
            }
        }

        public void visitElementNs() {
            ((PrintWriter)this.out()).print(StringEscapeUtil.escapeHtml(this.element.getNs()));
        }

        public void visitElementName() {
            ((PrintWriter)this.out()).print(StringEscapeUtil.escapeHtml(this.element.getLocalName()));
        }

        public void visitAttribute(Template attributeTemplate) {
            Iterator<Attribute> i$ = this.element.attributes().iterator();
            while (i$.hasNext()) {
                Attribute attr;
                this.attr = attr = i$.next();
                attributeTemplate.accept(this);
            }
        }

        public void visitAttributeKey() {
            ((PrintWriter)this.out()).print(StringEscapeUtil.escapeHtml(this.attr.getKey()));
        }

        public void visitAttributeValue(Template[] styledTextTemplates) {
            new StyledValueVisitor(this.attr.getValue(), (PrintWriter)this.out()).visitStyledValue(styledTextTemplates);
        }

        public void visitElementTexts(Template singleLineTemplate, Template multiLineTemplate) {
            if (this.element.getText().hasControlChars()) {
                multiLineTemplate.accept(this);
            } else {
                singleLineTemplate.accept(this);
            }
        }

        public void visitElementText(Template[] styledTextTemplates) {
            new StyledValueVisitor(this.element.getText(), (PrintWriter)this.out()).visitStyledValue(styledTextTemplates);
        }
    }

    public static interface ControlBarCallback {
        public void renderControlBar();
    }
}

