/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.dev.handler.component;

import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.internal.webpagelite.PageComponent;
import com.alibaba.citrus.util.internal.webpagelite.PageComponentRegistry;
import com.alibaba.citrus.util.regex.ClassNameWildcardCompiler;
import com.alibaba.citrus.webx.handler.RequestHandlerContext;
import com.alibaba.citrus.webx.handler.support.AbstractVisitor;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.regex.Pattern;

public class AccessControlComponent
extends PageComponent {
    private static final String PROPERTY_ALLOWD_HOSTS = "developmentMode.allowedHosts";
    private final Pattern[] allowdHostPatterns;

    public AccessControlComponent(PageComponentRegistry registry, String componentPath) {
        super(registry, componentPath);
        String[] allowedHosts = StringUtil.split(ObjectUtil.defaultIfNull(System.getProperty(PROPERTY_ALLOWD_HOSTS), ""), ", ");
        LinkedList<Pattern> patterns = CollectionUtil.createLinkedList();
        for (String allowedHost : allowedHosts) {
            patterns.add(ClassNameWildcardCompiler.compileClassName(allowedHost));
        }
        this.allowdHostPatterns = patterns.toArray(new Pattern[patterns.size()]);
    }

    public boolean accessAllowed(RequestHandlerContext context) {
        if (this.checkPermission(context)) {
            return true;
        }
        this.getTemplate().accept(new AccessDeniedVisitor(context));
        return false;
    }

    private boolean checkPermission(RequestHandlerContext context) {
        String remoteAddr = this.getRemoteAddr(context);
        try {
            InetAddress addr = InetAddress.getByName(remoteAddr);
            for (Pattern allowedHostPattern : this.allowdHostPatterns) {
                if (!allowedHostPattern.matcher(remoteAddr).matches()) continue;
                return true;
            }
            if (addr.isLoopbackAddress()) {
                return true;
            }
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                Enumeration<InetAddress> f = e.nextElement().getInetAddresses();
                while (f.hasMoreElements()) {
                    if (!addr.equals(f.nextElement())) continue;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private String getRemoteAddr(RequestHandlerContext context) {
        return StringUtil.trimToNull(context.getRequest().getRemoteAddr());
    }

    private class AccessDeniedVisitor
    extends AbstractVisitor {
        public AccessDeniedVisitor(RequestHandlerContext context) {
            super(context, AccessControlComponent.this);
        }

        public void visitPropertyName() {
            ((PrintWriter)this.out()).print(AccessControlComponent.PROPERTY_ALLOWD_HOSTS);
        }

        public void visitPropertyValue() {
            String remoteAddr = AccessControlComponent.this.getRemoteAddr(this.context);
            if (remoteAddr != null) {
                ((PrintWriter)this.out()).print(remoteAddr);
            }
        }

        public void visitPropertyValueWildcard() {
            String remoteAddr = AccessControlComponent.this.getRemoteAddr(this.context);
            if (remoteAddr != null) {
                ((PrintWriter)this.out()).print(remoteAddr.substring(0, remoteAddr.lastIndexOf(".") + 1) + "*");
            }
        }
    }
}

