/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.velocity.web.servlet;

import com.alibaba.boot.velocity.annotation.VelocityLayout;
import com.alibaba.spring.web.servlet.handler.AnnotatedHandlerMethodHandlerInterceptorAdapter;
import com.alibaba.spring.web.servlet.mvc.util.WebMvcUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;

public class VelocityLayoutHandlerInterceptor
extends AnnotatedHandlerMethodHandlerInterceptorAdapter<VelocityLayout> {
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final String layoutKey;

    public VelocityLayoutHandlerInterceptor(String layoutKey) {
        this.layoutKey = layoutKey;
    }

    protected void postHandle(HttpServletRequest request, HttpServletResponse response, HandlerMethod handlerMethod, VelocityLayout velocityLayout, ModelAndView modelAndView) throws Exception {
        if (WebMvcUtils.isPageRenderRequest((ModelAndView)modelAndView)) {
            Map model = modelAndView.getModel();
            if (model.containsKey(this.layoutKey)) {
                if (this.logger.isDebugEnabled()) {
                    String message = "Velocity Layout URL[ key : " + this.layoutKey + "] has been set into Model from HandlerMethod[ " + handlerMethod + " ]";
                    this.logger.debug((Object)message);
                }
                return;
            }
            model.put(this.layoutKey, velocityLayout.value());
        }
    }
}

