/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.velocity.tools;

import com.alibaba.boot.velocity.tools.VelocityTool;
import com.alibaba.boot.velocity.tools.VelocityToolsRepository;
import com.alibaba.boot.velocity.tools.VelocityToolsScanner;
import java.util.Collection;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

@Component
public class VelocityToolsRepositoryInitializer
implements ServletContextInitializer,
ApplicationListener<ContextRefreshedEvent>,
Ordered {
    private final VelocityToolsRepository velocityToolsRepository;
    private final Collection<VelocityToolsScanner> scanners;

    public VelocityToolsRepositoryInitializer(VelocityToolsRepository velocityToolsRepository, Collection<VelocityToolsScanner> scanners) {
        this.velocityToolsRepository = velocityToolsRepository;
        this.scanners = scanners;
    }

    public void onStartup(ServletContext servletContext) throws ServletException {
        for (VelocityToolsScanner scanner : this.scanners) {
            Map<String, VelocityTool> velocityToolsMap = scanner.scan();
            for (Map.Entry<String, VelocityTool> entry : velocityToolsMap.entrySet()) {
                this.velocityToolsRepository.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public int getOrder() {
        return -2147483647;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.velocityToolsRepository.init();
    }
}

