/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.velocity.tools;

import com.alibaba.boot.velocity.tools.VelocityTool;
import com.alibaba.boot.velocity.util.CompatibleRelaxedPropertyResolver;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.stereotype.Repository;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

@Repository
public class VelocityToolsRepository
implements EnvironmentAware,
BeanFactoryPostProcessor {
    private final Map<String, VelocityTool> repository = new LinkedHashMap<String, VelocityTool>();
    private boolean exposeBeans = false;
    private CompatibleRelaxedPropertyResolver propertyResolver;
    private ConfigurableListableBeanFactory beanFactory;
    private Map<String, Object> toolsMap;

    protected void init() {
        this.toolsMap = this.initToolsMap();
    }

    private Map<String, Object> initToolsMap() {
        LinkedHashMap<String, Object> toolsMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, VelocityTool> entry : this.repository.entrySet()) {
            String key = entry.getKey();
            VelocityTool velocityTool = entry.getValue();
            Object tool = this.exposeBeans ? this.beanFactory.getBean(key, velocityTool.getToolClass()) : velocityTool.create(Collections.emptyMap());
            toolsMap.put(key, tool);
        }
        return Collections.unmodifiableMap(toolsMap);
    }

    protected boolean put(String toolName, VelocityTool velocityTool) {
        return this.repository.put(toolName, velocityTool) == null;
    }

    public Map<String, VelocityTool> findAll() {
        return Collections.unmodifiableMap(this.repository);
    }

    public Map<String, Object> getTools() {
        return this.toolsMap;
    }

    public static VelocityToolsRepository get(ServletContext servletContext) {
        WebApplicationContext webApplicationContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
        return (VelocityToolsRepository)webApplicationContext.getBean(VelocityToolsRepository.class);
    }

    public void setEnvironment(Environment environment) {
        this.propertyResolver = new CompatibleRelaxedPropertyResolver((PropertyResolver)environment);
        this.exposeBeans = this.propertyResolver.getProperty("spring.velocity.tools-expose-beans", Boolean.TYPE, false);
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

