/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.velocity.tools;

import com.alibaba.boot.velocity.tools.AbstractVelocityToolsScanner;
import com.alibaba.boot.velocity.tools.VelocityTool;
import java.util.Map;
import java.util.Set;
import org.apache.velocity.tools.ToolInfo;
import org.apache.velocity.tools.config.DefaultKey;
import org.apache.velocity.tools.config.ValidScope;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

@Component
public class AnnotatedVelocityToolsScanner
extends AbstractVelocityToolsScanner
implements ResourceLoaderAware {
    private final ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
    private ClassLoader classLoader;

    public AnnotatedVelocityToolsScanner() {
        this.provider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(DefaultKey.class));
    }

    @Override
    protected void scan(String[] sources, Map<String, VelocityTool> velocityToolsMap) {
        for (String basePackage : sources) {
            Set candidates = this.provider.findCandidateComponents(basePackage);
            for (BeanDefinition beanDefinition : candidates) {
                Class<?> toolClass = this.resolveToolClass(beanDefinition);
                DefaultKey defaultKey = (DefaultKey)AnnotationUtils.findAnnotation(toolClass, DefaultKey.class);
                String key = defaultKey.value();
                String scope = this.getScope(toolClass);
                VelocityTool velocityTool = new VelocityTool(new ToolInfo(key, toolClass), scope);
                velocityToolsMap.put(key, velocityTool);
            }
        }
    }

    private Class<?> resolveToolClass(BeanDefinition beanDefinition) {
        String className = beanDefinition.getBeanClassName();
        return ClassUtils.resolveClassName((String)className, (ClassLoader)this.classLoader);
    }

    @Override
    protected String[] resolveSources() {
        return this.resolveRelaxedPropertyAsStringArray("spring.velocity.tools-base-packages");
    }

    private String getScope(Class<?> toolClass) {
        ValidScope validScope = (ValidScope)AnnotationUtils.findAnnotation(toolClass, ValidScope.class);
        if (validScope == null || ObjectUtils.isEmpty((Object[])validScope.value())) {
            return null;
        }
        return validScope.value()[0];
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.provider.setResourceLoader(resourceLoader);
        this.classLoader = resourceLoader.getClassLoader();
    }

    @Override
    public void setEnvironment(Environment environment) {
        super.setEnvironment(environment);
        this.provider.setEnvironment(environment);
    }
}

