/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.nacos.config.binder;

import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.annotation.NacosConfigurationProperties;
import com.alibaba.nacos.spring.context.properties.config.NacosConfigurationPropertiesBinder;
import com.alibaba.nacos.spring.core.env.NacosPropertySource;
import com.alibaba.nacos.spring.util.ObjectUtils;
import java.lang.reflect.Method;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.ResolvableType;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;

public class NacosBootConfigurationPropertiesBinder
extends NacosConfigurationPropertiesBinder {
    private final ConfigurableApplicationContext applicationContext;
    private final StandardEnvironment environment = new StandardEnvironment();

    public NacosBootConfigurationPropertiesBinder(ConfigurableApplicationContext applicationContext) {
        super(applicationContext);
        this.applicationContext = applicationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doBind(Object bean, String beanName, String dataId, String groupId, String configType, NacosConfigurationProperties properties, String content, ConfigService configService) {
        NacosBootConfigurationPropertiesBinder nacosBootConfigurationPropertiesBinder = this;
        synchronized (nacosBootConfigurationPropertiesBinder) {
            String name = "nacos-bootstrap-" + beanName;
            NacosPropertySource propertySource = new NacosPropertySource(dataId, groupId, name, content, configType);
            this.environment.getPropertySources().addLast((PropertySource)propertySource);
            ObjectUtils.cleanMapOrCollectionField((Object)bean);
            Binder binder = Binder.get((Environment)this.environment);
            ResolvableType type = this.getBeanType(bean, beanName);
            Bindable target = Bindable.of((ResolvableType)type).withExistingValue(bean);
            binder.bind(properties.prefix(), target);
            this.publishBoundEvent(bean, beanName, dataId, groupId, properties, content, configService);
            this.publishMetadataEvent(bean, beanName, dataId, groupId, properties);
            this.environment.getPropertySources().remove(name);
        }
    }

    private ResolvableType getBeanType(Object bean, String beanName) {
        Method factoryMethod = this.findFactoryMethod(beanName);
        if (factoryMethod != null) {
            return ResolvableType.forMethodReturnType((Method)factoryMethod);
        }
        return ResolvableType.forClass(bean.getClass());
    }

    public Method findFactoryMethod(String beanName) {
        BeanDefinition beanDefinition;
        ConfigurableListableBeanFactory beanFactory = this.applicationContext.getBeanFactory();
        if (beanFactory.containsBeanDefinition(beanName) && (beanDefinition = beanFactory.getMergedBeanDefinition(beanName)) instanceof RootBeanDefinition) {
            return ((RootBeanDefinition)beanDefinition).getResolvedFactoryMethod();
        }
        return null;
    }
}

