/*
 * Decompiled with CFR 0.152.
 */
package com.ql.util.express.instruction.detail;

import com.ql.util.express.RunEnvironment;
import com.ql.util.express.instruction.detail.Instruction;
import java.util.List;

public class InstructionGoToWithNotNull
extends Instruction {
    private final int offset;
    private final boolean isPopStackData;

    public InstructionGoToWithNotNull(int offset, boolean isPopStackData) {
        this.offset = offset;
        this.isPopStackData = isPopStackData;
    }

    @Override
    public void execute(RunEnvironment environment, List<String> errorList) throws Exception {
        Object o = !this.isPopStackData ? environment.peek().getObject(environment.getContext()) : environment.pop().getObject(environment.getContext());
        if (o != null) {
            if (environment.isTrace() && log.isDebugEnabled()) {
                log.debug((Object)("goto +" + this.offset));
            }
            environment.gotoWithOffset(this.offset);
        } else {
            if (environment.isTrace() && log.isDebugEnabled()) {
                log.debug((Object)"programPoint ++ ");
            }
            environment.programPointAddOne();
        }
    }

    public String toString() {
        String result = "GoToIf[NOTNULL,isPop=" + this.isPopStackData + "] ";
        if (this.offset >= 0) {
            result = result + "+";
        }
        result = result + this.offset;
        return result;
    }
}

