/*
 * Decompiled with CFR 0.152.
 */
package com.ql.util.express.instruction.detail;

import com.ql.util.express.RunEnvironment;
import com.ql.util.express.exception.QLException;
import com.ql.util.express.instruction.OperateDataCacheManager;
import com.ql.util.express.instruction.detail.Instruction;
import java.util.List;

public class InstructionGoToWithCondition
extends Instruction {
    private int offset;
    private final boolean condition;
    private final boolean isPopStackData;

    public InstructionGoToWithCondition(boolean condition, int offset, boolean isPopStackData) {
        this.offset = offset;
        this.condition = condition;
        this.isPopStackData = isPopStackData;
    }

    @Override
    public void execute(RunEnvironment environment, List<String> errorList) throws Exception {
        boolean r;
        Object o;
        if (!this.isPopStackData) {
            o = environment.peek().getObject(environment.getContext());
            if (o == null) {
                environment.pop();
                environment.push(OperateDataCacheManager.fetchOperateData(false, Boolean.TYPE));
            }
        } else {
            o = environment.pop().getObject(environment.getContext());
        }
        if (o == null) {
            r = false;
        } else if (o instanceof Boolean) {
            r = (Boolean)o;
        } else {
            throw new QLException(this.getExceptionPrefix() + "\u6307\u4ee4\u9519\u8bef:" + o + " \u4e0d\u662fBoolean");
        }
        if (r == this.condition) {
            if (environment.isTrace() && log.isDebugEnabled()) {
                log.debug((Object)("goto +" + this.offset));
            }
            environment.gotoWithOffset(this.offset);
        } else {
            if (environment.isTrace() && log.isDebugEnabled()) {
                log.debug((Object)"programPoint ++ ");
            }
            environment.programPointAddOne();
        }
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public String toString() {
        String result = "GoToIf[" + this.condition + ",isPop=" + this.isPopStackData + "] ";
        if (this.offset >= 0) {
            result = result + "+";
        }
        result = result + this.offset;
        return result;
    }
}

