/*
 * Decompiled with CFR 0.152.
 */
package com.ql.util.express.parse;

import com.ql.util.express.match.IDataNode;
import com.ql.util.express.match.INodeType;
import com.ql.util.express.parse.NodeType;
import java.util.ArrayList;
import java.util.List;

public class ExpressNode
implements IDataNode {
    private NodeType nodeType;
    private NodeType treeType;
    private String value;
    private String orgiValue;
    private Object objectValue;
    private ExpressNode parent;
    private List<ExpressNode> leftChildren;
    private List<ExpressNode> rightChildren;
    private boolean isSplitStatement = false;
    private int line;
    private int col;
    private int wordIndex = -1;

    public int getWordIndex() {
        return this.wordIndex;
    }

    public ExpressNode(NodeType aType, String aValue) throws Exception {
        this(aType, aValue, null, null, null, -1, -1, -1);
    }

    public ExpressNode(NodeType aType, String aValue, String aOrgiValue, Object aObjectValue, NodeType aTreeType, int aLine, int aCol, int wordIndex) throws Exception {
        if (aType == null) {
            throw new Exception(aValue + " \u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u8282\u70b9\u7c7b\u578b");
        }
        this.nodeType = aType;
        this.treeType = aTreeType;
        if (aValue != null && aValue.length() > 0) {
            this.value = aValue;
        }
        if (aOrgiValue != null && aOrgiValue.length() > 0) {
            this.orgiValue = aOrgiValue;
        }
        if (aObjectValue != null) {
            this.objectValue = aObjectValue;
        }
        this.line = aLine;
        this.col = aCol;
        this.wordIndex = wordIndex;
    }

    public boolean isTypeEqualsOrChild(String parent) {
        boolean result = this.getTreeType().isEqualsOrChild(parent);
        if (!result && this.treeType != null) {
            result = this.getNodeType().isEqualsOrChild(parent);
        }
        return result;
    }

    @Override
    public NodeType getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(NodeType type) {
        this.nodeType = type;
    }

    @Override
    public String getValue() {
        if (this.value == null) {
            return this.nodeType.getName();
        }
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isSplitStatement() {
        return this.isSplitStatement;
    }

    public void setSplitStatement(boolean isSplitStatement) {
        this.isSplitStatement = isSplitStatement;
    }

    public String getInstructionFactory() {
        if (this.nodeType.getInstructionFactory() != null) {
            return this.nodeType.getInstructionFactory();
        }
        if (this.treeType != null && this.treeType.getInstructionFactory() != null) {
            return this.treeType.getInstructionFactory();
        }
        throw new RuntimeException("\u6ca1\u6709\u5b9a\u4e49\u8282\u70b9\u7684\u6307\u4ee4InstructionFactory\u4fe1\u606f\uff1a" + this.nodeType.getName() + (this.treeType == null ? "" : " \u6216\u8005 " + this.treeType.getName()));
    }

    public String getOrgiValue() {
        return this.orgiValue;
    }

    public void setOrgiValue(String orgiValue) {
        this.orgiValue = orgiValue;
    }

    public Object getObjectValue() {
        return this.objectValue;
    }

    @Override
    public void setObjectValue(Object objectValue) {
        this.objectValue = objectValue;
    }

    public ExpressNode getParent() {
        return this.parent;
    }

    public void setParent(ExpressNode parent) {
        this.parent = parent;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public int getCol() {
        return this.col;
    }

    public void setCol(int col) {
        this.col = col;
    }

    public NodeType getRealTreeType() {
        return this.treeType;
    }

    @Override
    public NodeType getTreeType() {
        if (this.treeType == null) {
            return this.nodeType;
        }
        return this.treeType;
    }

    public void setTreeType(NodeType treeType) {
        this.treeType = treeType;
    }

    public List<ExpressNode> getLeftChildren() {
        return this.leftChildren;
    }

    public void setLeftChildren(List<ExpressNode> leftChildren) {
        this.leftChildren = leftChildren;
    }

    public List<ExpressNode> getRightChildren() {
        return this.rightChildren;
    }

    public void setRightChildren(List<ExpressNode> rightChildren) {
        this.rightChildren = rightChildren;
    }

    public void addLeftChild(ExpressNode leftChild) {
        if (leftChild == null) {
            return;
        }
        if (this.leftChildren == null) {
            this.leftChildren = new ArrayList<ExpressNode>();
        }
        this.leftChildren.add(leftChild);
    }

    public void addRightChild(ExpressNode rightChild) {
        if (rightChild == null) {
            return;
        }
        if (this.leftChildren == null) {
            this.leftChildren = new ArrayList<ExpressNode>();
        }
        this.leftChildren.add(rightChild);
    }

    public ExpressNode[] getChildren() {
        ArrayList<ExpressNode> result = new ArrayList<ExpressNode>();
        if (this.leftChildren != null && this.leftChildren.size() > 0) {
            result.addAll(this.leftChildren);
        }
        if (this.rightChildren != null && this.rightChildren.size() > 0) {
            result.addAll(this.rightChildren);
        }
        return result.toArray(new ExpressNode[0]);
    }

    public String toString() {
        String str = (this.orgiValue == null ? this.getValue() : this.orgiValue) + (this.nodeType.getName() == null ? "" : ":" + this.nodeType.getName());
        return str;
    }

    @Override
    public IDataNode createExpressNode(INodeType aType, String aValue) throws Exception {
        return new ExpressNode((NodeType)aType, aValue);
    }

    @Override
    public void setNodeType(INodeType type) {
        this.setNodeType((NodeType)type);
    }

    @Override
    public void addLeftChild(IDataNode ref) {
        this.addLeftChild((ExpressNode)ref);
    }

    @Override
    public void setTreeType(INodeType aTreeType) {
        this.setTreeType((NodeType)aTreeType);
    }
}

