/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.controller;

import com.aizuda.snailjob.server.web.annotation.LoginRequired;
import com.aizuda.snailjob.server.web.model.base.PageResult;
import com.aizuda.snailjob.server.web.model.request.JobExecutorQueryVO;
import com.aizuda.snailjob.server.web.service.JobExecutorService;
import com.aizuda.snailjob.template.datasource.persistence.po.JobExecutor;
import jakarta.validation.constraints.NotEmpty;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/job/executor"})
public class JobExecutorController {
    @Autowired
    private JobExecutorService jobExecutorService;

    @GetMapping(value={"/page/list"})
    @LoginRequired
    public PageResult<List<JobExecutor>> getJobPage(JobExecutorQueryVO executorQueryVO) {
        return this.jobExecutorService.getJobExecutorPage(executorQueryVO);
    }

    @GetMapping(value={"/list"})
    @LoginRequired
    public Set<String> getJobList(JobExecutorQueryVO executorQueryVO) {
        return this.jobExecutorService.getJobExecutorList(executorQueryVO);
    }

    @GetMapping(value={"{id}"})
    @LoginRequired
    public JobExecutor getJobExecutorsDetail(@PathVariable(value="id") Long id) {
        return this.jobExecutorService.getJobExecutorDetail(id);
    }

    @DeleteMapping(value={"/ids"})
    @LoginRequired
    public Boolean deleteJobExecutorsById(@RequestBody @NotEmpty(message="ids cannot be null") @NotEmpty(message="ids cannot be null") Set<Long> ids) {
        return this.jobExecutorService.deleteJobExecutorByIds(ids);
    }
}

