/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.controller;

import com.aizuda.snailjob.common.core.annotation.OriginalControllerReturnValue;
import com.aizuda.snailjob.server.web.annotation.LoginRequired;
import com.aizuda.snailjob.server.web.model.base.PageResult;
import com.aizuda.snailjob.server.web.model.request.ExportSceneVO;
import com.aizuda.snailjob.server.web.model.request.SceneConfigQueryVO;
import com.aizuda.snailjob.server.web.model.request.SceneConfigRequestVO;
import com.aizuda.snailjob.server.web.model.response.SceneConfigResponseVO;
import com.aizuda.snailjob.server.web.service.SceneConfigService;
import com.aizuda.snailjob.server.web.util.ExportUtils;
import com.aizuda.snailjob.server.web.util.ImportUtils;
import jakarta.validation.constraints.NotEmpty;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/scene-config"})
public class SceneConfigController {
    private final SceneConfigService sceneConfigService;

    @LoginRequired
    @GetMapping(value={"page/list"})
    public PageResult<List<SceneConfigResponseVO>> getSceneConfigPageList(SceneConfigQueryVO queryVO) {
        return this.sceneConfigService.getSceneConfigPageList(queryVO);
    }

    @LoginRequired
    @GetMapping(value={"list"})
    public List<SceneConfigResponseVO> getSceneConfigList(@RequestParam(value="groupName") String groupName) {
        return this.sceneConfigService.getSceneConfigList(groupName);
    }

    @LoginRequired
    @GetMapping(value={"{id}"})
    public SceneConfigResponseVO getSceneConfigDetail(@PathVariable(value="id") Long id) {
        return this.sceneConfigService.getSceneConfigDetail(id);
    }

    @LoginRequired
    @PutMapping(value={"/{id}/status/{status}"})
    public Boolean updateStatus(@PathVariable(value="id") Long id, @PathVariable(value="status") Integer status) {
        return this.sceneConfigService.updateStatus(id, status);
    }

    @LoginRequired
    @PostMapping
    public Boolean saveSceneConfig(@RequestBody @Validated SceneConfigRequestVO requestVO) {
        return this.sceneConfigService.saveSceneConfig(requestVO);
    }

    @LoginRequired
    @PutMapping
    public Boolean updateSceneConfig(@RequestBody @Validated SceneConfigRequestVO requestVO) {
        return this.sceneConfigService.updateSceneConfig(requestVO);
    }

    @LoginRequired
    @PostMapping(value={"/import"}, consumes={"multipart/form-data"})
    public void importScene(@RequestPart(value="file") MultipartFile file) throws IOException {
        this.sceneConfigService.importSceneConfig(ImportUtils.parseList(file, SceneConfigRequestVO.class));
    }

    @LoginRequired
    @PostMapping(value={"/export"})
    @OriginalControllerReturnValue
    public ResponseEntity<String> export(@RequestBody ExportSceneVO exportSceneVO) {
        return ExportUtils.doExport(this.sceneConfigService.exportSceneConfig(exportSceneVO));
    }

    @LoginRequired
    @DeleteMapping(value={"/ids"})
    public boolean deleteByIds(@RequestBody @NotEmpty(message="ids\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="ids\u4e0d\u80fd\u4e3a\u7a7a") Set<Long> ids) {
        return this.sceneConfigService.deleteByIds(ids);
    }

    @Generated
    public SceneConfigController(SceneConfigService sceneConfigService) {
        this.sceneConfigService = sceneConfigService;
    }
}

