/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.controller;

import com.aizuda.snailjob.server.web.annotation.LoginRequired;
import com.aizuda.snailjob.server.web.model.base.PageResult;
import com.aizuda.snailjob.server.web.model.request.NotifyConfigQueryVO;
import com.aizuda.snailjob.server.web.model.request.NotifyConfigRequestVO;
import com.aizuda.snailjob.server.web.model.response.NotifyConfigResponseVO;
import com.aizuda.snailjob.server.web.service.NotifyConfigService;
import com.aizuda.snailjob.template.datasource.persistence.po.NotifyConfig;
import jakarta.validation.constraints.NotEmpty;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/notify-config"})
public class NotifyConfigController {
    private final NotifyConfigService notifyConfigService;

    @LoginRequired
    @GetMapping(value={"list"})
    public PageResult<List<NotifyConfigResponseVO>> getNotifyConfigList(NotifyConfigQueryVO queryVO) {
        return this.notifyConfigService.getNotifyConfigList(queryVO);
    }

    @LoginRequired
    @GetMapping(value={"/all/{systemTaskType}"})
    public List<NotifyConfig> getNotifyConfigBySystemTaskTypeList(@PathVariable(value="systemTaskType") Integer systemTaskType) {
        return this.notifyConfigService.getNotifyConfigBySystemTaskTypeList(systemTaskType);
    }

    @LoginRequired
    @GetMapping(value={"{id}"})
    public NotifyConfigResponseVO getNotifyConfigDetail(@PathVariable(value="id") Long id) {
        return this.notifyConfigService.getNotifyConfigDetail(id);
    }

    @LoginRequired
    @PostMapping
    public Boolean saveNotify(@RequestBody @Validated NotifyConfigRequestVO requestVO) {
        return this.notifyConfigService.saveNotify(requestVO);
    }

    @LoginRequired
    @PutMapping
    public Boolean updateNotify(@RequestBody @Validated NotifyConfigRequestVO requestVO) {
        return this.notifyConfigService.updateNotify(requestVO);
    }

    @LoginRequired
    @PutMapping(value={"/{id}/status/{status}"})
    public Boolean updateStatus(@PathVariable(value="id") Long id, @PathVariable(value="status") Integer status) {
        return this.notifyConfigService.updateStatus(id, status);
    }

    @LoginRequired
    @DeleteMapping(value={"ids"})
    public Boolean batchDeleteNotify(@RequestBody @NotEmpty(message="ids\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="ids\u4e0d\u80fd\u4e3a\u7a7a") Set<Long> ids) {
        return this.notifyConfigService.batchDeleteNotify(ids);
    }

    @Generated
    public NotifyConfigController(NotifyConfigService notifyConfigService) {
        this.notifyConfigService = notifyConfigService;
    }
}

