/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.controller;

import com.aizuda.snailjob.server.web.annotation.LoginRequired;
import com.aizuda.snailjob.server.web.model.base.PageResult;
import com.aizuda.snailjob.server.web.model.request.RetryTaskLogMessageQueryVO;
import com.aizuda.snailjob.server.web.model.request.RetryTaskLogQueryVO;
import com.aizuda.snailjob.server.web.model.response.RetryTaskLogMessageResponseVO;
import com.aizuda.snailjob.server.web.model.response.RetryTaskLogResponseVO;
import com.aizuda.snailjob.server.web.service.RetryTaskLogService;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/retry-task-log"})
public class RetryTaskLogController {
    @Autowired
    private RetryTaskLogService retryTaskLogService;

    @LoginRequired
    @GetMapping(value={"list"})
    public PageResult<List<RetryTaskLogResponseVO>> getRetryTaskLogPage(RetryTaskLogQueryVO queryVO) {
        return this.retryTaskLogService.getRetryTaskLogPage(queryVO);
    }

    @LoginRequired
    @GetMapping(value={"/message/list"})
    public RetryTaskLogMessageResponseVO getRetryTaskLogPage(RetryTaskLogMessageQueryVO queryVO) {
        return this.retryTaskLogService.getRetryTaskLogMessagePage(queryVO);
    }

    @LoginRequired
    @GetMapping(value={"{id}"})
    public RetryTaskLogResponseVO getRetryTaskLogById(@PathVariable(value="id") Long id) {
        return this.retryTaskLogService.getRetryTaskLogById(id);
    }

    @LoginRequired
    @DeleteMapping(value={"{id}"})
    public Boolean deleteById(@PathVariable(value="id") Long id) {
        return this.retryTaskLogService.deleteById(id);
    }

    @LoginRequired
    @DeleteMapping(value={"ids"})
    public Boolean batchDelete(@RequestBody @Valid @NotEmpty(message="ids\u4e0d\u80fd\u4e3a\u7a7a") @Valid @NotEmpty(message="ids\u4e0d\u80fd\u4e3a\u7a7a") Set<Long> ids) {
        return this.retryTaskLogService.batchDelete(ids);
    }
}

