/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.service.impl;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.strategy.WaitStrategies;
import com.aizuda.snailjob.server.common.util.CronUtils;
import com.aizuda.snailjob.server.web.model.base.PageResult;
import com.aizuda.snailjob.server.web.model.request.SceneConfigQueryVO;
import com.aizuda.snailjob.server.web.model.request.SceneConfigRequestVO;
import com.aizuda.snailjob.server.web.model.request.UserSessionVO;
import com.aizuda.snailjob.server.web.model.response.SceneConfigResponseVO;
import com.aizuda.snailjob.server.web.service.SceneConfigService;
import com.aizuda.snailjob.server.web.service.convert.SceneConfigConverter;
import com.aizuda.snailjob.server.web.service.convert.SceneConfigResponseVOConverter;
import com.aizuda.snailjob.server.web.service.handler.SyncConfigHandler;
import com.aizuda.snailjob.server.web.util.UserSessionUtils;
import com.aizuda.snailjob.template.datasource.access.AccessTemplate;
import com.aizuda.snailjob.template.datasource.access.ConfigAccess;
import com.aizuda.snailjob.template.datasource.persistence.po.RetrySceneConfig;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class SceneConfigServiceImpl
implements SceneConfigService {
    private final AccessTemplate accessTemplate;

    private static void checkExecuteInterval(SceneConfigRequestVO requestVO) {
        if (Lists.newArrayList((Object[])new Integer[]{WaitStrategies.WaitStrategyEnum.FIXED.getType(), WaitStrategies.WaitStrategyEnum.RANDOM.getType()}).contains(requestVO.getBackOff()) ? Integer.parseInt(requestVO.getTriggerInterval()) < 10 : requestVO.getBackOff().intValue() == WaitStrategies.WaitStrategyEnum.CRON.getType() && CronUtils.getExecuteInterval((String)requestVO.getTriggerInterval()) < 10000L) {
            throw new SnailJobServerException("\u95f4\u9694\u65f6\u95f4\u4e0d\u5f97\u5c0f\u4e8e10");
        }
    }

    @Override
    public PageResult<List<SceneConfigResponseVO>> getSceneConfigPageList(SceneConfigQueryVO queryVO) {
        PageDTO pageDTO = new PageDTO((long)queryVO.getPage(), (long)queryVO.getSize());
        UserSessionVO userSessionVO = UserSessionUtils.currentUserSession();
        String namespaceId = userSessionVO.getNamespaceId();
        pageDTO = this.accessTemplate.getSceneConfigAccess().listPage(pageDTO, (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetrySceneConfig::getNamespaceId, (Object)namespaceId)).in(userSessionVO.isUser(), RetrySceneConfig::getGroupName, userSessionVO.getGroupNames())).eq(StrUtil.isNotBlank((CharSequence)queryVO.getGroupName()), RetrySceneConfig::getGroupName, (Object)StrUtil.trim((CharSequence)queryVO.getGroupName()))).eq(StrUtil.isNotBlank((CharSequence)queryVO.getSceneName()), RetrySceneConfig::getSceneName, (Object)StrUtil.trim((CharSequence)queryVO.getSceneName()))).orderByDesc(RetrySceneConfig::getCreateDt));
        return new PageResult<List<SceneConfigResponseVO>>(pageDTO, SceneConfigResponseVOConverter.INSTANCE.convertList(pageDTO.getRecords()));
    }

    @Override
    public List<SceneConfigResponseVO> getSceneConfigList(String groupName) {
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        List retrySceneConfigs = this.accessTemplate.getSceneConfigAccess().list((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetrySceneConfig::getNamespaceId, (Object)namespaceId)).eq(RetrySceneConfig::getGroupName, (Object)groupName)).select(new SFunction[]{RetrySceneConfig::getSceneName, RetrySceneConfig::getDescription, RetrySceneConfig::getMaxRetryCount}).orderByDesc(RetrySceneConfig::getCreateDt));
        return SceneConfigResponseVOConverter.INSTANCE.convertList(retrySceneConfigs);
    }

    @Override
    public Boolean saveSceneConfig(SceneConfigRequestVO requestVO) {
        SceneConfigServiceImpl.checkExecuteInterval(requestVO);
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        ConfigAccess sceneConfigAccess = this.accessTemplate.getSceneConfigAccess();
        Assert.isTrue((0L == sceneConfigAccess.count((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetrySceneConfig::getNamespaceId, (Object)namespaceId)).eq(RetrySceneConfig::getGroupName, (Object)requestVO.getGroupName())).eq(RetrySceneConfig::getSceneName, (Object)requestVO.getSceneName())) ? 1 : 0) != 0, () -> new SnailJobServerException("\u573a\u666f\u540d\u79f0\u91cd\u590d. {}", new Object[]{requestVO.getSceneName()}));
        RetrySceneConfig retrySceneConfig = SceneConfigConverter.INSTANCE.convert(requestVO);
        retrySceneConfig.setCreateDt(LocalDateTime.now());
        retrySceneConfig.setNamespaceId(namespaceId);
        if (requestVO.getBackOff().intValue() == WaitStrategies.WaitStrategyEnum.DELAY_LEVEL.getType()) {
            retrySceneConfig.setTriggerInterval("");
        }
        Assert.isTrue((1 == sceneConfigAccess.insert((Object)retrySceneConfig) ? 1 : 0) != 0, () -> new SnailJobServerException("failed to insert scene. retrySceneConfig:[{}]", new Object[]{JsonUtil.toJsonString((Object)retrySceneConfig)}));
        SyncConfigHandler.addSyncTask(requestVO.getGroupName(), namespaceId);
        return Boolean.TRUE;
    }

    @Override
    public Boolean updateSceneConfig(SceneConfigRequestVO requestVO) {
        SceneConfigServiceImpl.checkExecuteInterval(requestVO);
        RetrySceneConfig retrySceneConfig = SceneConfigConverter.INSTANCE.convert(requestVO);
        retrySceneConfig.setSceneName(null);
        retrySceneConfig.setGroupName(null);
        retrySceneConfig.setNamespaceId(null);
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        retrySceneConfig.setTriggerInterval(Optional.ofNullable(retrySceneConfig.getTriggerInterval()).orElse(""));
        Assert.isTrue((1 == this.accessTemplate.getSceneConfigAccess().update((Object)retrySceneConfig, (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(RetrySceneConfig::getNamespaceId, (Object)namespaceId)).eq(RetrySceneConfig::getGroupName, (Object)requestVO.getGroupName())).eq(RetrySceneConfig::getSceneName, (Object)requestVO.getSceneName())) ? 1 : 0) != 0, () -> new SnailJobServerException("failed to update scene. retrySceneConfig:[{}]", new Object[]{JsonUtil.toJsonString((Object)retrySceneConfig)}));
        SyncConfigHandler.addSyncTask(requestVO.getGroupName(), namespaceId);
        return Boolean.TRUE;
    }

    @Override
    public SceneConfigResponseVO getSceneConfigDetail(Long id) {
        RetrySceneConfig retrySceneConfig = (RetrySceneConfig)this.accessTemplate.getSceneConfigAccess().one((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetrySceneConfig::getId, (Object)id));
        return SceneConfigResponseVOConverter.INSTANCE.convert(retrySceneConfig);
    }

    @Override
    public boolean updateStatus(Long id, Integer status) {
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        RetrySceneConfig config = new RetrySceneConfig();
        config.setSceneStatus(status);
        return 1 == this.accessTemplate.getSceneConfigAccess().update((Object)config, (LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(RetrySceneConfig::getId, (Object)id)).eq(RetrySceneConfig::getNamespaceId, (Object)namespaceId));
    }

    public SceneConfigServiceImpl(AccessTemplate accessTemplate) {
        this.accessTemplate = accessTemplate;
    }
}

