/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.service.impl;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.client.model.GenerateRetryIdempotentIdDTO;
import com.aizuda.snailjob.common.core.enums.RetryStatusEnum;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.model.Result;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.WaitStrategy;
import com.aizuda.snailjob.server.common.cache.CacheRegisterTable;
import com.aizuda.snailjob.server.common.dto.RegisterNodeInfo;
import com.aizuda.snailjob.server.common.dto.RetryLogMetaDTO;
import com.aizuda.snailjob.server.common.enums.SyetemTaskTypeEnum;
import com.aizuda.snailjob.server.common.enums.TaskGeneratorSceneEnum;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.handler.ClientNodeAllocateHandler;
import com.aizuda.snailjob.server.common.rpc.client.RequestBuilder;
import com.aizuda.snailjob.server.common.strategy.WaitStrategies;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.server.model.dto.RetryTaskDTO;
import com.aizuda.snailjob.server.retry.task.client.RetryRpcClient;
import com.aizuda.snailjob.server.retry.task.generator.task.TaskContext;
import com.aizuda.snailjob.server.retry.task.generator.task.TaskGenerator;
import com.aizuda.snailjob.server.retry.task.support.RetryTaskConverter;
import com.aizuda.snailjob.server.retry.task.support.dispatch.task.TaskExecutor;
import com.aizuda.snailjob.server.retry.task.support.dispatch.task.TaskExecutorSceneEnum;
import com.aizuda.snailjob.server.web.model.base.PageResult;
import com.aizuda.snailjob.server.web.model.request.BatchDeleteRetryTaskVO;
import com.aizuda.snailjob.server.web.model.request.GenerateRetryIdempotentIdVO;
import com.aizuda.snailjob.server.web.model.request.ManualTriggerTaskRequestVO;
import com.aizuda.snailjob.server.web.model.request.ParseLogsVO;
import com.aizuda.snailjob.server.web.model.request.RetryTaskQueryVO;
import com.aizuda.snailjob.server.web.model.request.RetryTaskSaveRequestVO;
import com.aizuda.snailjob.server.web.model.request.RetryTaskUpdateExecutorNameRequestVO;
import com.aizuda.snailjob.server.web.model.request.RetryTaskUpdateStatusRequestVO;
import com.aizuda.snailjob.server.web.model.response.RetryTaskResponseVO;
import com.aizuda.snailjob.server.web.service.RetryTaskService;
import com.aizuda.snailjob.server.web.service.convert.RetryTaskResponseVOConverter;
import com.aizuda.snailjob.server.web.service.convert.TaskContextConverter;
import com.aizuda.snailjob.server.web.util.UserSessionUtils;
import com.aizuda.snailjob.template.datasource.access.AccessTemplate;
import com.aizuda.snailjob.template.datasource.access.TaskAccess;
import com.aizuda.snailjob.template.datasource.persistence.mapper.RetryTaskLogMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.GroupConfig;
import com.aizuda.snailjob.template.datasource.persistence.po.RetrySceneConfig;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTask;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTaskLog;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class RetryTaskServiceImpl
implements RetryTaskService {
    @Autowired
    private ClientNodeAllocateHandler clientNodeAllocateHandler;
    @Autowired
    private RetryTaskLogMapper retryTaskLogMapper;
    @Autowired
    private AccessTemplate accessTemplate;
    @Autowired
    @Lazy
    private List<TaskGenerator> taskGenerators;
    @Lazy
    @Autowired
    private List<TaskExecutor> taskExecutors;

    @Override
    public PageResult<List<RetryTaskResponseVO>> getRetryTaskPage(RetryTaskQueryVO queryVO) {
        PageDTO pageDTO = new PageDTO((long)queryVO.getPage(), (long)queryVO.getSize());
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        if (StrUtil.isBlank((CharSequence)queryVO.getGroupName())) {
            return new PageResult<List<RetryTaskResponseVO>>(pageDTO, new ArrayList());
        }
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetryTask::getNamespaceId, (Object)namespaceId)).eq(RetryTask::getGroupName, (Object)queryVO.getGroupName())).eq(StrUtil.isNotBlank((CharSequence)queryVO.getSceneName()), RetryTask::getSceneName, (Object)queryVO.getSceneName())).eq(StrUtil.isNotBlank((CharSequence)queryVO.getBizNo()), RetryTask::getBizNo, (Object)queryVO.getBizNo())).eq(StrUtil.isNotBlank((CharSequence)queryVO.getIdempotentId()), RetryTask::getIdempotentId, (Object)queryVO.getIdempotentId())).eq(StrUtil.isNotBlank((CharSequence)queryVO.getUniqueId()), RetryTask::getUniqueId, (Object)queryVO.getUniqueId())).eq(Objects.nonNull(queryVO.getRetryStatus()), RetryTask::getRetryStatus, (Object)queryVO.getRetryStatus())).select(new SFunction[]{RetryTask::getId, RetryTask::getBizNo, RetryTask::getIdempotentId, RetryTask::getGroupName, RetryTask::getNextTriggerAt, RetryTask::getRetryCount, RetryTask::getRetryStatus, RetryTask::getUpdateDt, RetryTask::getSceneName, RetryTask::getUniqueId, RetryTask::getTaskType}).orderByDesc(RetryTask::getCreateDt);
        pageDTO = this.accessTemplate.getRetryTaskAccess().listPage(queryVO.getGroupName(), namespaceId, pageDTO, queryWrapper);
        return new PageResult<List<RetryTaskResponseVO>>(pageDTO, RetryTaskResponseVOConverter.INSTANCE.convertList(pageDTO.getRecords()));
    }

    @Override
    public RetryTaskResponseVO getRetryTaskById(String groupName, Long id) {
        TaskAccess retryTaskAccess = this.accessTemplate.getRetryTaskAccess();
        RetryTask retryTask = (RetryTask)retryTaskAccess.one(groupName, UserSessionUtils.currentUserSession().getNamespaceId(), (LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetryTask::getId, (Object)id));
        return RetryTaskResponseVOConverter.INSTANCE.convert(retryTask);
    }

    @Override
    @Transactional
    public int updateRetryTaskStatus(RetryTaskUpdateStatusRequestVO requestVO) {
        RetryStatusEnum retryStatusEnum = RetryStatusEnum.getByStatus((Integer)requestVO.getRetryStatus());
        if (Objects.isNull(retryStatusEnum)) {
            throw new SnailJobServerException("\u91cd\u8bd5\u72b6\u6001\u9519\u8bef. [{}]", new Object[]{requestVO.getRetryStatus()});
        }
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        TaskAccess retryTaskAccess = this.accessTemplate.getRetryTaskAccess();
        RetryTask retryTask = (RetryTask)retryTaskAccess.one(requestVO.getGroupName(), namespaceId, (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetryTask::getNamespaceId, (Object)namespaceId)).eq(RetryTask::getId, (Object)requestVO.getId()));
        if (Objects.isNull(retryTask)) {
            throw new SnailJobServerException("\u672a\u67e5\u8be2\u5230\u91cd\u8bd5\u4efb\u52a1");
        }
        retryTask.setRetryStatus(requestVO.getRetryStatus());
        retryTask.setGroupName(requestVO.getGroupName());
        if (RetryStatusEnum.RUNNING.getStatus().equals(retryStatusEnum.getStatus())) {
            RetrySceneConfig retrySceneConfig = this.accessTemplate.getSceneConfigAccess().getSceneConfigByGroupNameAndSceneName(retryTask.getGroupName(), retryTask.getSceneName(), namespaceId);
            WaitStrategies.WaitStrategyContext waitStrategyContext = new WaitStrategies.WaitStrategyContext();
            waitStrategyContext.setNextTriggerAt(DateUtils.toNowMilli());
            waitStrategyContext.setTriggerInterval(retrySceneConfig.getTriggerInterval());
            waitStrategyContext.setDelayLevel(Integer.valueOf(retryTask.getRetryCount() + 1));
            WaitStrategy waitStrategy = WaitStrategies.WaitStrategyEnum.getWaitStrategy((int)retrySceneConfig.getBackOff());
            retryTask.setNextTriggerAt(DateUtils.toLocalDateTime((long)waitStrategy.computeTriggerTime(waitStrategyContext)));
        }
        if (RetryStatusEnum.FINISH.getStatus().equals(retryStatusEnum.getStatus())) {
            RetryLogMetaDTO retryLogMetaDTO = RetryTaskConverter.INSTANCE.toLogMetaDTO(retryTask);
            retryLogMetaDTO.setTimestamp(Long.valueOf(DateUtils.toNowMilli()));
            SnailJobLog.REMOTE.info("=============\u624b\u52a8\u64cd\u4f5c\u5b8c\u6210============. <|>{}<|>", new Object[]{retryLogMetaDTO});
        }
        RetryTaskLog retryTaskLog = new RetryTaskLog();
        retryTaskLog.setRetryStatus(requestVO.getRetryStatus());
        this.retryTaskLogMapper.update((Object)retryTaskLog, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(RetryTaskLog::getNamespaceId, (Object)namespaceId)).eq(RetryTaskLog::getUniqueId, (Object)retryTask.getUniqueId())).eq(RetryTaskLog::getGroupName, (Object)retryTask.getGroupName()));
        retryTask.setUpdateDt(LocalDateTime.now());
        return retryTaskAccess.updateById(requestVO.getGroupName(), namespaceId, (Object)retryTask);
    }

    @Override
    public int saveRetryTask(RetryTaskSaveRequestVO retryTaskRequestVO) {
        RetryStatusEnum retryStatusEnum = RetryStatusEnum.getByStatus((Integer)retryTaskRequestVO.getRetryStatus());
        if (Objects.isNull(retryStatusEnum)) {
            throw new SnailJobServerException("\u91cd\u8bd5\u72b6\u6001\u9519\u8bef");
        }
        TaskGenerator taskGenerator = this.taskGenerators.stream().filter(t -> t.supports(TaskGeneratorSceneEnum.MANA_SINGLE.getScene())).findFirst().orElseThrow(() -> new SnailJobServerException("\u6ca1\u6709\u5339\u914d\u7684\u4efb\u52a1\u751f\u6210\u5668"));
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        TaskContext taskContext = new TaskContext();
        taskContext.setSceneName(retryTaskRequestVO.getSceneName());
        taskContext.setGroupName(retryTaskRequestVO.getGroupName());
        taskContext.setInitStatus(retryTaskRequestVO.getRetryStatus());
        taskContext.setNamespaceId(namespaceId);
        taskContext.setTaskInfos(Collections.singletonList(TaskContextConverter.INSTANCE.convert(retryTaskRequestVO)));
        taskGenerator.taskGenerator(taskContext);
        return 1;
    }

    @Override
    public String idempotentIdGenerate(GenerateRetryIdempotentIdVO generateRetryIdempotentIdVO) {
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        Set serverNodes = CacheRegisterTable.getServerNodeSet((String)generateRetryIdempotentIdVO.getGroupName(), (String)namespaceId);
        Assert.notEmpty((Iterable)serverNodes, () -> new SnailJobServerException("\u751f\u6210idempotentId\u5931\u8d25: \u4e0d\u5b58\u5728\u6d3b\u8dc3\u7684\u5ba2\u6237\u7aef\u8282\u70b9"));
        RetrySceneConfig retrySceneConfig = this.accessTemplate.getSceneConfigAccess().getSceneConfigByGroupNameAndSceneName(generateRetryIdempotentIdVO.getGroupName(), generateRetryIdempotentIdVO.getSceneName(), namespaceId);
        RegisterNodeInfo serverNode = this.clientNodeAllocateHandler.getServerNode(retrySceneConfig.getSceneName(), retrySceneConfig.getGroupName(), retrySceneConfig.getNamespaceId(), retrySceneConfig.getRouteKey());
        GenerateRetryIdempotentIdDTO generateRetryIdempotentIdDTO = new GenerateRetryIdempotentIdDTO();
        generateRetryIdempotentIdDTO.setGroup(generateRetryIdempotentIdVO.getGroupName());
        generateRetryIdempotentIdDTO.setScene(generateRetryIdempotentIdVO.getSceneName());
        generateRetryIdempotentIdDTO.setArgsStr(generateRetryIdempotentIdVO.getArgsStr());
        generateRetryIdempotentIdDTO.setExecutorName(generateRetryIdempotentIdVO.getExecutorName());
        RetryRpcClient rpcClient = (RetryRpcClient)RequestBuilder.newBuilder().nodeInfo(serverNode).client(RetryRpcClient.class).build();
        Result result = rpcClient.generateIdempotentId(generateRetryIdempotentIdDTO);
        Assert.notNull((Object)result, () -> new SnailJobServerException("idempotentId\u751f\u6210\u5931\u8d25"));
        Assert.isTrue((1 == result.getStatus() ? 1 : 0) != 0, () -> new SnailJobServerException("idempotentId\u751f\u6210\u5931\u8d25:\u8bf7\u786e\u4fdd\u53c2\u6570\u4e0e\u6267\u884c\u5668\u540d\u79f0\u6b63\u786e"));
        return (String)result.getData();
    }

    @Override
    public int updateRetryTaskExecutorName(RetryTaskUpdateExecutorNameRequestVO requestVO) {
        RetryTask retryTask = new RetryTask();
        retryTask.setExecutorName(requestVO.getExecutorName());
        retryTask.setRetryStatus(requestVO.getRetryStatus());
        retryTask.setUpdateDt(LocalDateTime.now());
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        TaskAccess retryTaskAccess = this.accessTemplate.getRetryTaskAccess();
        return retryTaskAccess.update(requestVO.getGroupName(), namespaceId, (Object)retryTask, (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(RetryTask::getNamespaceId, (Object)namespaceId)).eq(RetryTask::getGroupName, (Object)requestVO.getGroupName())).in(RetryTask::getId, requestVO.getIds()));
    }

    @Override
    public Integer deleteRetryTask(BatchDeleteRetryTaskVO requestVO) {
        TaskAccess retryTaskAccess = this.accessTemplate.getRetryTaskAccess();
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        return retryTaskAccess.delete(requestVO.getGroupName(), namespaceId, (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetryTask::getNamespaceId, (Object)namespaceId)).eq(RetryTask::getGroupName, (Object)requestVO.getGroupName())).in(RetryTask::getId, requestVO.getIds()));
    }

    @Override
    public Integer parseLogs(ParseLogsVO parseLogsVO) {
        RetryStatusEnum retryStatusEnum = RetryStatusEnum.getByStatus((Integer)parseLogsVO.getRetryStatus());
        if (Objects.isNull(retryStatusEnum)) {
            throw new SnailJobServerException("\u91cd\u8bd5\u72b6\u6001\u9519\u8bef");
        }
        String logStr = parseLogsVO.getLogStr();
        String patternString = "<\\|>(.*?)<\\|>";
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(logStr);
        ArrayList waitInsertList = new ArrayList();
        while (matcher.find()) {
            List retryTaskList;
            String extractedData = matcher.group(1);
            if (StrUtil.isBlank((CharSequence)extractedData) || CollectionUtils.isEmpty((Collection)(retryTaskList = JsonUtil.parseList((String)extractedData, RetryTaskDTO.class)))) continue;
            waitInsertList.addAll(retryTaskList);
        }
        Assert.isFalse((boolean)waitInsertList.isEmpty(), () -> new SnailJobServerException("\u672a\u627e\u5230\u5339\u914d\u7684\u6570\u636e"));
        Assert.isTrue((waitInsertList.size() <= 500 ? 1 : 0) != 0, () -> new SnailJobServerException("\u6700\u591a\u53ea\u80fd\u5904\u7406500\u6761\u6570\u636e"));
        TaskGenerator taskGenerator = this.taskGenerators.stream().filter(t -> t.supports(TaskGeneratorSceneEnum.MANA_BATCH.getScene())).findFirst().orElseThrow(() -> new SnailJobServerException("\u6ca1\u6709\u5339\u914d\u7684\u4efb\u52a1\u751f\u6210\u5668"));
        boolean allMatch = waitInsertList.stream().allMatch(retryTaskDTO -> retryTaskDTO.getGroupName().equals(parseLogsVO.getGroupName()));
        Assert.isTrue((boolean)allMatch, () -> new SnailJobServerException("\u5b58\u5728\u6570\u636egroupName\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u60a8\u7684\u6570\u636e"));
        Map map = StreamUtils.groupByKey(waitInsertList, RetryTaskDTO::getSceneName);
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        map.forEach((sceneName, retryTaskDTOS) -> {
            TaskContext taskContext = new TaskContext();
            taskContext.setSceneName(sceneName);
            taskContext.setGroupName(parseLogsVO.getGroupName());
            taskContext.setNamespaceId(namespaceId);
            taskContext.setInitStatus(parseLogsVO.getRetryStatus());
            taskContext.setTaskInfos(TaskContextConverter.INSTANCE.convert((List<RetryTaskDTO>)retryTaskDTOS));
            taskGenerator.taskGenerator(taskContext);
        });
        return waitInsertList.size();
    }

    @Override
    public boolean manualTriggerRetryTask(ManualTriggerTaskRequestVO requestVO) {
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        long count = this.accessTemplate.getGroupConfigAccess().count((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(GroupConfig::getGroupName, (Object)requestVO.getGroupName())).eq(GroupConfig::getNamespaceId, (Object)namespaceId)).eq(GroupConfig::getGroupStatus, (Object)StatusEnum.YES.getStatus()));
        Assert.isTrue((count > 0L ? 1 : 0) != 0, () -> new SnailJobServerException("\u7ec4:[{}]\u5df2\u7ecf\u5173\u95ed\uff0c\u4e0d\u652f\u6301\u624b\u52a8\u6267\u884c.", new Object[]{requestVO.getGroupName()}));
        List<String> uniqueIds = requestVO.getUniqueIds();
        List list = this.accessTemplate.getRetryTaskAccess().list(requestVO.getGroupName(), namespaceId, (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetryTask::getNamespaceId, (Object)namespaceId)).eq(RetryTask::getTaskType, (Object)SyetemTaskTypeEnum.RETRY.getType())).in(RetryTask::getUniqueId, uniqueIds));
        Assert.notEmpty((Iterable)list, () -> new SnailJobServerException("\u6ca1\u6709\u53ef\u6267\u884c\u7684\u4efb\u52a1"));
        for (RetryTask retryTask : list) {
            for (TaskExecutor taskExecutor : this.taskExecutors) {
                if (taskExecutor.getTaskType().getScene() != TaskExecutorSceneEnum.MANUAL_RETRY.getScene()) continue;
                taskExecutor.actuator(retryTask);
            }
        }
        return true;
    }

    @Override
    public boolean manualTriggerCallbackTask(ManualTriggerTaskRequestVO requestVO) {
        List<String> uniqueIds = requestVO.getUniqueIds();
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        long count = this.accessTemplate.getGroupConfigAccess().count((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(GroupConfig::getGroupName, (Object)requestVO.getGroupName())).eq(GroupConfig::getNamespaceId, (Object)namespaceId)).eq(GroupConfig::getGroupStatus, (Object)StatusEnum.YES.getStatus()));
        Assert.isTrue((count > 0L ? 1 : 0) != 0, () -> new SnailJobServerException("\u7ec4:[{}]\u5df2\u7ecf\u5173\u95ed\uff0c\u4e0d\u652f\u6301\u624b\u52a8\u6267\u884c.", new Object[]{requestVO.getGroupName()}));
        List list = this.accessTemplate.getRetryTaskAccess().list(requestVO.getGroupName(), namespaceId, (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetryTask::getNamespaceId, (Object)namespaceId)).eq(RetryTask::getTaskType, (Object)SyetemTaskTypeEnum.CALLBACK.getType())).in(RetryTask::getUniqueId, uniqueIds));
        Assert.notEmpty((Iterable)list, () -> new SnailJobServerException("\u6ca1\u6709\u53ef\u6267\u884c\u7684\u4efb\u52a1"));
        for (RetryTask retryTask : list) {
            for (TaskExecutor taskExecutor : this.taskExecutors) {
                if (taskExecutor.getTaskType().getScene() != TaskExecutorSceneEnum.MANUAL_CALLBACK.getScene()) continue;
                taskExecutor.actuator(retryTask);
            }
        }
        return true;
    }
}

