/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.service.impl;

import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.server.web.model.base.PageResult;
import com.aizuda.snailjob.server.web.model.request.NotifyRecipientQueryVO;
import com.aizuda.snailjob.server.web.model.request.NotifyRecipientRequestVO;
import com.aizuda.snailjob.server.web.model.response.CommonLabelValueResponseVO;
import com.aizuda.snailjob.server.web.model.response.NotifyRecipientResponseVO;
import com.aizuda.snailjob.server.web.service.NotifyRecipientService;
import com.aizuda.snailjob.server.web.service.convert.NotifyRecipientConverter;
import com.aizuda.snailjob.server.web.util.UserSessionUtils;
import com.aizuda.snailjob.template.datasource.persistence.mapper.NotifyRecipientMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.NotifyRecipient;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.springframework.stereotype.Service;

@Service
public class NotifyRecipientServiceImpl
implements NotifyRecipientService {
    private final NotifyRecipientMapper notifyRecipientMapper;

    @Override
    public PageResult<List<NotifyRecipientResponseVO>> getNotifyRecipientPageList(NotifyRecipientQueryVO queryVO) {
        PageDTO pageDTO = new PageDTO((long)queryVO.getPage(), (long)queryVO.getSize());
        PageDTO notifyRecipientPageDTO = (PageDTO)this.notifyRecipientMapper.selectPage((IPage)pageDTO, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().likeRight(StrUtil.isNotBlank((CharSequence)queryVO.getRecipientName()), NotifyRecipient::getRecipientName, (Object)queryVO.getRecipientName())).likeRight(Objects.nonNull(queryVO.getNotifyType()), NotifyRecipient::getNotifyType, (Object)queryVO.getNotifyType())).orderByDesc(NotifyRecipient::getCreateDt));
        return new PageResult<List<NotifyRecipientResponseVO>>(pageDTO, NotifyRecipientConverter.INSTANCE.convertList(notifyRecipientPageDTO.getRecords()));
    }

    @Override
    public Boolean saveNotifyRecipient(NotifyRecipientRequestVO requestVO) {
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        NotifyRecipient notifyRecipient = NotifyRecipientConverter.INSTANCE.convert(requestVO);
        notifyRecipient.setNamespaceId(namespaceId);
        return 1 == this.notifyRecipientMapper.insert((Object)notifyRecipient);
    }

    @Override
    public Boolean updateNotifyRecipient(NotifyRecipientRequestVO requestVO) {
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        NotifyRecipient notifyRecipient = NotifyRecipientConverter.INSTANCE.convert(requestVO);
        notifyRecipient.setNamespaceId(namespaceId);
        return 1 == this.notifyRecipientMapper.updateById((Object)notifyRecipient);
    }

    @Override
    public List<CommonLabelValueResponseVO> getNotifyRecipientList() {
        List notifyRecipients = this.notifyRecipientMapper.selectList((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{NotifyRecipient::getRecipientName, NotifyRecipient::getId}));
        return NotifyRecipientConverter.INSTANCE.convertListToCommonLabelValueList(notifyRecipients);
    }

    @Override
    public Boolean batchDeleteByIds(Set<Long> ids) {
        return ids.size() == this.notifyRecipientMapper.deleteBatchIds(ids);
    }

    public NotifyRecipientServiceImpl(NotifyRecipientMapper notifyRecipientMapper) {
        this.notifyRecipientMapper = notifyRecipientMapper;
    }
}

