/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.service.impl;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.HashUtil;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.core.constant.SystemConstants;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.server.common.WaitStrategy;
import com.aizuda.snailjob.server.common.config.SystemProperties;
import com.aizuda.snailjob.server.common.enums.JobTaskExecutorSceneEnum;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.strategy.WaitStrategies;
import com.aizuda.snailjob.server.common.util.CronUtils;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.server.job.task.dto.JobTaskPrepareDTO;
import com.aizuda.snailjob.server.job.task.support.JobPrePareHandler;
import com.aizuda.snailjob.server.job.task.support.JobTaskConverter;
import com.aizuda.snailjob.server.job.task.support.cache.ResidentTaskCache;
import com.aizuda.snailjob.server.web.model.base.PageResult;
import com.aizuda.snailjob.server.web.model.request.JobQueryVO;
import com.aizuda.snailjob.server.web.model.request.JobRequestVO;
import com.aizuda.snailjob.server.web.model.request.JobUpdateJobStatusRequestVO;
import com.aizuda.snailjob.server.web.model.request.UserSessionVO;
import com.aizuda.snailjob.server.web.model.response.JobResponseVO;
import com.aizuda.snailjob.server.web.service.JobService;
import com.aizuda.snailjob.server.web.service.convert.JobConverter;
import com.aizuda.snailjob.server.web.service.convert.JobResponseVOConverter;
import com.aizuda.snailjob.server.web.util.UserSessionUtils;
import com.aizuda.snailjob.template.datasource.access.AccessTemplate;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.GroupConfig;
import com.aizuda.snailjob.template.datasource.persistence.po.Job;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class JobServiceImpl
implements JobService {
    private static final Logger log = LoggerFactory.getLogger(JobServiceImpl.class);
    private final SystemProperties systemProperties;
    private final JobMapper jobMapper;
    @Lazy
    private final JobPrePareHandler terminalJobPrepareHandler;
    private final AccessTemplate accessTemplate;

    private static Long calculateNextTriggerAt(JobRequestVO jobRequestVO, Long time) {
        if (Objects.equals(jobRequestVO.getTriggerType(), SystemConstants.WORKFLOW_TRIGGER_TYPE)) {
            return 0L;
        }
        WaitStrategy waitStrategy = WaitStrategies.WaitStrategyEnum.getWaitStrategy((int)jobRequestVO.getTriggerType());
        WaitStrategies.WaitStrategyContext waitStrategyContext = new WaitStrategies.WaitStrategyContext();
        waitStrategyContext.setTriggerInterval(jobRequestVO.getTriggerInterval());
        waitStrategyContext.setNextTriggerAt(time.longValue());
        return waitStrategy.computeTriggerTime(waitStrategyContext);
    }

    @Override
    public PageResult<List<JobResponseVO>> getJobPage(JobQueryVO queryVO) {
        PageDTO pageDTO = new PageDTO((long)queryVO.getPage(), (long)queryVO.getSize());
        UserSessionVO userSessionVO = UserSessionUtils.currentUserSession();
        PageDTO selectPage = (PageDTO)this.jobMapper.selectPage((IPage)pageDTO, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Job::getDeleted, (Object)StatusEnum.NO.getStatus())).eq(Job::getNamespaceId, (Object)userSessionVO.getNamespaceId())).in(userSessionVO.isUser(), Job::getGroupName, userSessionVO.getGroupNames())).eq(StrUtil.isNotBlank((CharSequence)queryVO.getGroupName()), Job::getGroupName, (Object)queryVO.getGroupName())).likeRight(StrUtil.isNotBlank((CharSequence)queryVO.getJobName()), Job::getJobName, (Object)StrUtil.trim((CharSequence)queryVO.getJobName()))).eq(Objects.nonNull(queryVO.getJobStatus()), Job::getJobStatus, (Object)queryVO.getJobStatus())).eq(Job::getDeleted, (Object)StatusEnum.NO.getStatus())).orderByDesc(Job::getId));
        List<JobResponseVO> jobResponseList = JobResponseVOConverter.INSTANCE.convertList(selectPage.getRecords());
        return new PageResult<List<JobResponseVO>>(pageDTO, jobResponseList);
    }

    @Override
    public JobResponseVO getJobDetail(Long id) {
        Job job = (Job)this.jobMapper.selectById((Serializable)id);
        return JobResponseVOConverter.INSTANCE.convert(job);
    }

    @Override
    public List<String> getTimeByCron(String cron) {
        return CronUtils.getExecuteTimeByCron((String)cron, (int)5);
    }

    @Override
    public List<JobResponseVO> getJobNameList(String keywords, Long jobId, String groupName) {
        UserSessionVO userSessionVO = UserSessionUtils.currentUserSession();
        PageDTO selectPage = (PageDTO)this.jobMapper.selectPage((IPage)new PageDTO(1L, 20L), (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{Job::getId, Job::getJobName}).eq(Job::getNamespaceId, (Object)userSessionVO.getNamespaceId())).likeRight(StrUtil.isNotBlank((CharSequence)keywords), Job::getJobName, (Object)StrUtil.trim((CharSequence)keywords))).eq(StrUtil.isNotBlank((CharSequence)groupName), Job::getGroupName, (Object)groupName)).eq(Objects.nonNull(jobId), Job::getId, (Object)jobId)).eq(Job::getDeleted, (Object)StatusEnum.NO.getStatus())).orderByAsc(Job::getId));
        return JobResponseVOConverter.INSTANCE.convertList(selectPage.getRecords());
    }

    @Override
    public boolean saveJob(JobRequestVO jobRequestVO) {
        Job job = this.updateJobResident(jobRequestVO);
        job.setBucketIndex(Integer.valueOf(HashUtil.bkdrHash((String)(jobRequestVO.getGroupName() + jobRequestVO.getJobName())) % this.systemProperties.getBucketTotal()));
        job.setNextTriggerAt(JobServiceImpl.calculateNextTriggerAt(jobRequestVO, DateUtils.toNowMilli()));
        job.setNamespaceId(UserSessionUtils.currentUserSession().getNamespaceId());
        return 1 == this.jobMapper.insert((Object)job);
    }

    @Override
    public boolean updateJob(JobRequestVO jobRequestVO) {
        Assert.notNull((Object)jobRequestVO.getId(), () -> new SnailJobServerException("id \u4e0d\u80fd\u4e3a\u7a7a"));
        Job job = (Job)this.jobMapper.selectById((Serializable)jobRequestVO.getId());
        Assert.notNull((Object)job, () -> new SnailJobServerException("\u66f4\u65b0\u5931\u8d25"));
        Job updateJob = this.updateJobResident(jobRequestVO);
        updateJob.setNamespaceId(job.getNamespaceId());
        if (Objects.equals(jobRequestVO.getTriggerType(), SystemConstants.WORKFLOW_TRIGGER_TYPE)) {
            job.setNextTriggerAt(Long.valueOf(0L));
        } else if (Objects.equals(job.getResident(), StatusEnum.NO.getStatus()) && Objects.equals(updateJob.getResident(), StatusEnum.NO.getStatus())) {
            updateJob.setNextTriggerAt(JobServiceImpl.calculateNextTriggerAt(jobRequestVO, DateUtils.toNowMilli()));
        } else if (Objects.equals(job.getResident(), StatusEnum.YES.getStatus()) && Objects.equals(updateJob.getResident(), StatusEnum.NO.getStatus())) {
            long time = Optional.ofNullable(ResidentTaskCache.get((Long)jobRequestVO.getId())).orElse(DateUtils.toNowMilli());
            updateJob.setNextTriggerAt(JobServiceImpl.calculateNextTriggerAt(jobRequestVO, time));
        } else if (Objects.equals(job.getResident(), StatusEnum.NO.getStatus()) && Objects.equals(updateJob.getResident(), StatusEnum.YES.getStatus())) {
            updateJob.setNextTriggerAt(Long.valueOf(DateUtils.toNowMilli()));
        }
        return 1 == this.jobMapper.updateById((Object)updateJob);
    }

    @Override
    public Job updateJobResident(JobRequestVO jobRequestVO) {
        Job job = JobConverter.INSTANCE.convert(jobRequestVO);
        job.setResident(StatusEnum.NO.getStatus());
        if (Objects.equals(jobRequestVO.getTriggerType(), SystemConstants.WORKFLOW_TRIGGER_TYPE)) {
            return job;
        }
        if (jobRequestVO.getTriggerType().intValue() == WaitStrategies.WaitStrategyEnum.FIXED.getType()) {
            if (Integer.parseInt(jobRequestVO.getTriggerInterval()) < 10) {
                job.setResident(StatusEnum.YES.getStatus());
            }
        } else if (jobRequestVO.getTriggerType().intValue() == WaitStrategies.WaitStrategyEnum.CRON.getType()) {
            if (CronUtils.getExecuteInterval((String)jobRequestVO.getTriggerInterval()) < 10000L) {
                job.setResident(StatusEnum.YES.getStatus());
            }
        } else {
            throw new SnailJobServerException("\u672a\u77e5\u89e6\u53d1\u7c7b\u578b");
        }
        return job;
    }

    @Override
    public Boolean updateJobStatus(JobUpdateJobStatusRequestVO jobRequestVO) {
        Assert.notNull((Object)jobRequestVO.getId(), () -> new SnailJobServerException("id \u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.isTrue((1L == this.jobMapper.selectCount((Wrapper)new LambdaQueryWrapper().eq(Job::getId, (Object)jobRequestVO.getId())) ? 1 : 0) != 0);
        Job job = new Job();
        job.setId(jobRequestVO.getId());
        job.setJobStatus(jobRequestVO.getJobStatus());
        return 1 == this.jobMapper.updateById((Object)job);
    }

    @Override
    public Boolean deleteJobById(Long id) {
        Job job = new Job();
        job.setId(id);
        job.setDeleted(StatusEnum.YES.getStatus());
        return 1 == this.jobMapper.updateById((Object)job);
    }

    @Override
    public boolean trigger(Long jobId) {
        Job job = (Job)this.jobMapper.selectById((Serializable)jobId);
        Assert.notNull((Object)job, () -> new SnailJobServerException("job can not be null."));
        long count = this.accessTemplate.getGroupConfigAccess().count((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(GroupConfig::getGroupName, (Object)job.getGroupName())).eq(GroupConfig::getNamespaceId, (Object)job.getNamespaceId())).eq(GroupConfig::getGroupStatus, (Object)StatusEnum.YES.getStatus()));
        Assert.isTrue((count > 0L ? 1 : 0) != 0, () -> new SnailJobServerException("\u7ec4:[{}]\u5df2\u7ecf\u5173\u95ed\uff0c\u4e0d\u652f\u6301\u624b\u52a8\u6267\u884c.", new Object[]{job.getGroupName()}));
        JobTaskPrepareDTO jobTaskPrepare = JobTaskConverter.INSTANCE.toJobTaskPrepare(job);
        jobTaskPrepare.setNextTriggerAt(DateUtils.toNowMilli());
        jobTaskPrepare.setTaskExecutorScene(JobTaskExecutorSceneEnum.MANUAL_JOB.getType());
        this.terminalJobPrepareHandler.handler(jobTaskPrepare);
        return Boolean.TRUE;
    }

    @Override
    public List<JobResponseVO> getJobList(String groupName) {
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        List jobs = this.jobMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{Job::getId, Job::getJobName}).eq(Job::getNamespaceId, (Object)namespaceId)).eq(Job::getGroupName, (Object)groupName)).eq(Job::getDeleted, (Object)StatusEnum.NO.getStatus())).orderByDesc(Job::getCreateDt));
        List<JobResponseVO> jobResponseList = JobResponseVOConverter.INSTANCE.convertList(jobs);
        return jobResponseList;
    }

    public JobServiceImpl(SystemProperties systemProperties, JobMapper jobMapper, JobPrePareHandler terminalJobPrepareHandler, AccessTemplate accessTemplate) {
        this.systemProperties = systemProperties;
        this.jobMapper = jobMapper;
        this.terminalJobPrepareHandler = terminalJobPrepareHandler;
        this.accessTemplate = accessTemplate;
    }
}

