/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.HashUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.server.common.config.SystemProperties;
import com.aizuda.snailjob.server.common.enums.IdGeneratorModeEnum;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.handler.ConfigVersionSyncHandler;
import com.aizuda.snailjob.server.web.model.base.PageResult;
import com.aizuda.snailjob.server.web.model.request.GroupConfigQueryVO;
import com.aizuda.snailjob.server.web.model.request.GroupConfigRequestVO;
import com.aizuda.snailjob.server.web.model.request.UserSessionVO;
import com.aizuda.snailjob.server.web.model.response.GroupConfigResponseVO;
import com.aizuda.snailjob.server.web.service.GroupConfigService;
import com.aizuda.snailjob.server.web.service.convert.GroupConfigConverter;
import com.aizuda.snailjob.server.web.service.convert.GroupConfigResponseVOConverter;
import com.aizuda.snailjob.server.web.util.UserSessionUtils;
import com.aizuda.snailjob.template.datasource.access.AccessTemplate;
import com.aizuda.snailjob.template.datasource.access.ConfigAccess;
import com.aizuda.snailjob.template.datasource.access.TaskAccess;
import com.aizuda.snailjob.template.datasource.enums.DbTypeEnum;
import com.aizuda.snailjob.template.datasource.persistence.mapper.NamespaceMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.SequenceAllocMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.ServerNodeMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.GroupConfig;
import com.aizuda.snailjob.template.datasource.persistence.po.Namespace;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryDeadLetter;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTask;
import com.aizuda.snailjob.template.datasource.persistence.po.SequenceAlloc;
import com.aizuda.snailjob.template.datasource.persistence.po.ServerNode;
import com.aizuda.snailjob.template.datasource.utils.DbUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.springframework.context.annotation.Lazy;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class GroupConfigServiceImpl
implements GroupConfigService {
    private final ServerNodeMapper serverNodeMapper;
    private final AccessTemplate accessTemplate;
    private final SequenceAllocMapper sequenceAllocMapper;
    @Lazy
    private final ConfigVersionSyncHandler configVersionSyncHandler;
    private final SystemProperties systemProperties;
    private final JdbcTemplate jdbcTemplate;
    private final NamespaceMapper namespaceMapper;

    @Override
    @Transactional
    public Boolean addGroup(UserSessionVO systemUser, GroupConfigRequestVO groupConfigRequestVO) {
        ConfigAccess groupConfigAccess = this.accessTemplate.getGroupConfigAccess();
        Assert.isTrue((groupConfigAccess.count((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(GroupConfig::getNamespaceId, (Object)systemUser.getNamespaceId())).eq(GroupConfig::getGroupName, (Object)groupConfigRequestVO.getGroupName())) == 0L ? 1 : 0) != 0, () -> new SnailJobServerException("GroupName\u5df2\u7ecf\u5b58\u5728 {}", new Object[]{groupConfigRequestVO.getGroupName()}));
        Boolean isSuccess = this.doSaveGroupConfig(systemUser, groupConfigRequestVO);
        this.doSaveSequenceAlloc(systemUser, groupConfigRequestVO);
        return isSuccess;
    }

    private void doSaveSequenceAlloc(UserSessionVO systemUser, GroupConfigRequestVO groupConfigRequestVO) {
        SequenceAlloc sequenceAlloc = new SequenceAlloc();
        sequenceAlloc.setGroupName(groupConfigRequestVO.getGroupName());
        sequenceAlloc.setNamespaceId(systemUser.getNamespaceId());
        sequenceAlloc.setStep(Integer.valueOf(this.systemProperties.getStep()));
        sequenceAlloc.setUpdateDt(LocalDateTime.now());
        Assert.isTrue((1 == this.sequenceAllocMapper.insert((Object)sequenceAlloc) ? 1 : 0) != 0, () -> new SnailJobServerException("failed to save sequence generation rule configuration [{}].", new Object[]{groupConfigRequestVO.getGroupName()}));
    }

    @Override
    @Transactional
    public Boolean updateGroup(GroupConfigRequestVO groupConfigRequestVO) {
        List<Integer> tablePartitionList = this.getTablePartitionList();
        if (CollectionUtils.isEmpty(tablePartitionList)) {
            return Boolean.FALSE;
        }
        String groupName = groupConfigRequestVO.getGroupName();
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        ConfigAccess groupConfigAccess = this.accessTemplate.getGroupConfigAccess();
        long count = groupConfigAccess.count((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(GroupConfig::getNamespaceId, (Object)namespaceId)).eq(GroupConfig::getGroupName, (Object)groupName));
        if (count <= 0L) {
            return false;
        }
        GroupConfig groupConfig = GroupConfigConverter.INSTANCE.convert(groupConfigRequestVO);
        groupConfig.setDescription(Optional.ofNullable(groupConfigRequestVO.getDescription()).orElse(""));
        groupConfig.setVersion(Integer.valueOf(1));
        groupConfig.setToken(null);
        Assert.isTrue((boolean)tablePartitionList.contains(groupConfigRequestVO.getGroupPartition()), () -> new SnailJobServerException("\u5206\u533a\u4e0d\u5b58\u5728. [{}]", new Object[]{tablePartitionList}));
        Assert.isTrue((groupConfigRequestVO.getGroupPartition() >= 0 ? 1 : 0) != 0, () -> new SnailJobServerException("\u5206\u533a\u4e0d\u80fd\u662f\u8d1f\u6570."));
        this.checkGroupPartition(groupConfig, namespaceId);
        Assert.isTrue((1 == groupConfigAccess.update((Object)groupConfig, (LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(GroupConfig::getNamespaceId, (Object)namespaceId)).eq(GroupConfig::getGroupName, (Object)groupName)) ? 1 : 0) != 0, () -> new SnailJobServerException("exception occurred while adding group. groupConfigVO[{}]", new Object[]{groupConfigRequestVO}));
        boolean add = this.configVersionSyncHandler.addSyncTask(groupName, namespaceId, Integer.valueOf(0));
        if (!add) {
            this.configVersionSyncHandler.syncVersion(groupName, namespaceId);
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean updateGroupStatus(String groupName, Integer status) {
        GroupConfig groupConfig = new GroupConfig();
        groupConfig.setGroupStatus(status);
        ConfigAccess groupConfigAccess = this.accessTemplate.getGroupConfigAccess();
        return groupConfigAccess.update((Object)groupConfig, (LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(GroupConfig::getNamespaceId, (Object)UserSessionUtils.currentUserSession().getNamespaceId())).eq(GroupConfig::getGroupName, (Object)groupName)) == 1;
    }

    @Override
    public PageResult<List<GroupConfigResponseVO>> getGroupConfigForPage(GroupConfigQueryVO queryVO) {
        UserSessionVO userSessionVO = UserSessionUtils.currentUserSession();
        String namespaceId = userSessionVO.getNamespaceId();
        ConfigAccess groupConfigAccess = this.accessTemplate.getGroupConfigAccess();
        PageDTO groupConfigPageDTO = groupConfigAccess.listPage(new PageDTO((long)queryVO.getPage(), (long)queryVO.getSize()), (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(GroupConfig::getNamespaceId, (Object)namespaceId)).in(userSessionVO.isUser(), GroupConfig::getGroupName, userSessionVO.getGroupNames())).likeRight(StrUtil.isNotBlank((CharSequence)queryVO.getGroupName()), GroupConfig::getGroupName, (Object)StrUtil.trim((CharSequence)queryVO.getGroupName()))).orderByDesc(GroupConfig::getId));
        List records = groupConfigPageDTO.getRecords();
        if (CollectionUtils.isEmpty((Collection)records)) {
            return new PageResult<List<GroupConfigResponseVO>>(groupConfigPageDTO.getCurrent(), groupConfigPageDTO.getSize(), groupConfigPageDTO.getTotal());
        }
        PageResult<List<GroupConfigResponseVO>> pageResult = new PageResult<List<GroupConfigResponseVO>>(groupConfigPageDTO.getCurrent(), groupConfigPageDTO.getSize(), groupConfigPageDTO.getTotal());
        List<GroupConfigResponseVO> responseVOList = GroupConfigResponseVOConverter.INSTANCE.convertList(records);
        for (GroupConfigResponseVO groupConfigResponseVO : responseVOList) {
            Optional.ofNullable(IdGeneratorModeEnum.modeOf((int)groupConfigResponseVO.getIdGeneratorMode())).ifPresent(idGeneratorMode -> groupConfigResponseVO.setIdGeneratorModeName(idGeneratorMode.getDesc()));
        }
        pageResult.setData(responseVOList);
        return pageResult;
    }

    private boolean doSaveGroupConfig(UserSessionVO systemUser, GroupConfigRequestVO groupConfigRequestVO) {
        List<Integer> tablePartitionList = this.getTablePartitionList();
        if (CollectionUtils.isEmpty(tablePartitionList)) {
            return Boolean.FALSE;
        }
        GroupConfig groupConfig = GroupConfigConverter.INSTANCE.convert(groupConfigRequestVO);
        groupConfig.setCreateDt(LocalDateTime.now());
        groupConfig.setVersion(Integer.valueOf(1));
        groupConfig.setNamespaceId(systemUser.getNamespaceId());
        groupConfig.setGroupName(groupConfigRequestVO.getGroupName());
        groupConfig.setToken(groupConfigRequestVO.getToken());
        groupConfig.setDescription(Optional.ofNullable(groupConfigRequestVO.getDescription()).orElse(""));
        if (Objects.isNull(groupConfigRequestVO.getGroupPartition())) {
            groupConfig.setGroupPartition(Integer.valueOf(HashUtil.bkdrHash((String)groupConfigRequestVO.getGroupName()) % tablePartitionList.size()));
        } else {
            Assert.isTrue((boolean)tablePartitionList.contains(groupConfigRequestVO.getGroupPartition()), () -> new SnailJobServerException("\u5206\u533a\u4e0d\u5b58\u5728. [{}]", new Object[]{tablePartitionList}));
            Assert.isTrue((groupConfigRequestVO.getGroupPartition() >= 0 ? 1 : 0) != 0, () -> new SnailJobServerException("\u5206\u533a\u4e0d\u80fd\u662f\u8d1f\u6570."));
        }
        groupConfig.setBucketIndex(Integer.valueOf(HashUtil.bkdrHash((String)groupConfigRequestVO.getGroupName()) % this.systemProperties.getBucketTotal()));
        ConfigAccess groupConfigAccess = this.accessTemplate.getGroupConfigAccess();
        Assert.isTrue((1 == groupConfigAccess.insert((Object)groupConfig) ? 1 : 0) != 0, () -> new SnailJobServerException("\u65b0\u589e\u7ec4\u5f02\u5e38\u5f02\u5e38 groupConfigVO[{}]", new Object[]{groupConfigRequestVO}));
        this.checkGroupPartition(groupConfig, systemUser.getNamespaceId());
        return Boolean.TRUE;
    }

    private void checkGroupPartition(GroupConfig groupConfig, String namespaceId) {
        TaskAccess retryTaskAccess;
        try {
            retryTaskAccess = this.accessTemplate.getRetryTaskAccess();
            retryTaskAccess.count(groupConfig.getGroupName(), namespaceId, (LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetryTask::getId, (Object)1));
        }
        catch (BadSqlGrammarException e) {
            Optional.ofNullable(e.getMessage()).ifPresent(s -> {
                if (s.contains("retry_task_" + groupConfig.getGroupPartition()) && s.contains("doesn't exist")) {
                    throw new SnailJobServerException("\u5206\u533a:[{}] '\u672a\u914d\u7f6e\u8868retry_task_{}', \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u914d\u7f6e", new Object[]{groupConfig.getGroupPartition(), groupConfig.getGroupPartition()});
                }
            });
        }
        try {
            retryTaskAccess = this.accessTemplate.getRetryDeadLetterAccess();
            retryTaskAccess.one(groupConfig.getGroupName(), namespaceId, (LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetryDeadLetter::getId, (Object)1));
        }
        catch (BadSqlGrammarException e) {
            Optional.ofNullable(e.getMessage()).ifPresent(s -> {
                if (s.contains("retry_dead_letter_" + groupConfig.getGroupPartition()) && s.contains("doesn't exist")) {
                    throw new SnailJobServerException("\u5206\u533a:[{}] '\u672a\u914d\u7f6e\u8868retry_dead_letter_{}', \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u914d\u7f6e", new Object[]{groupConfig.getGroupPartition(), groupConfig.getGroupPartition()});
                }
            });
        }
    }

    @Override
    public GroupConfigResponseVO getGroupConfigByGroupName(String groupName) {
        ConfigAccess groupConfigAccess = this.accessTemplate.getGroupConfigAccess();
        GroupConfig groupConfig = (GroupConfig)groupConfigAccess.one((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(GroupConfig::getNamespaceId, (Object)UserSessionUtils.currentUserSession().getNamespaceId())).eq(GroupConfig::getGroupName, (Object)groupName));
        GroupConfigResponseVO groupConfigResponseVO = GroupConfigResponseVOConverter.INSTANCE.convert(groupConfig);
        Optional.ofNullable(IdGeneratorModeEnum.modeOf((int)groupConfig.getIdGeneratorMode())).ifPresent(idGeneratorMode -> groupConfigResponseVO.setIdGeneratorModeName(idGeneratorMode.getDesc()));
        return groupConfigResponseVO;
    }

    @Override
    public List<GroupConfigResponseVO> getAllGroupConfigList(List<String> namespaceIds) {
        ConfigAccess groupConfigAccess = this.accessTemplate.getGroupConfigAccess();
        List groupConfigs = groupConfigAccess.list((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{GroupConfig::getGroupName, GroupConfig::getNamespaceId}).in(CollUtil.isNotEmpty(namespaceIds), GroupConfig::getNamespaceId, namespaceIds));
        if (CollUtil.isEmpty((Collection)groupConfigs)) {
            return Collections.emptyList();
        }
        List namespaces = this.namespaceMapper.selectList((Wrapper)new LambdaQueryWrapper().in(Namespace::getUniqueId, (Collection)StreamUtils.toSet((Collection)groupConfigs, GroupConfig::getNamespaceId)));
        Map namespaceMap = StreamUtils.toMap((Collection)namespaces, Namespace::getUniqueId, Namespace::getName);
        List<GroupConfigResponseVO> groupConfigResponses = GroupConfigResponseVOConverter.INSTANCE.convertList(groupConfigs);
        for (GroupConfigResponseVO groupConfigResponseVO : groupConfigResponses) {
            groupConfigResponseVO.setNamespaceName((String)namespaceMap.get(groupConfigResponseVO.getNamespaceId()));
        }
        return groupConfigResponses;
    }

    @Override
    public List<String> getAllGroupNameList() {
        UserSessionVO userSessionVO = UserSessionUtils.currentUserSession();
        if (userSessionVO.isUser()) {
            return userSessionVO.getGroupNames();
        }
        ConfigAccess groupConfigAccess = this.accessTemplate.getGroupConfigAccess();
        List groupConfigs = groupConfigAccess.list(((LambdaQueryWrapper)new LambdaQueryWrapper().eq(GroupConfig::getNamespaceId, (Object)userSessionVO.getNamespaceId())).select(new SFunction[]{GroupConfig::getGroupName}));
        return StreamUtils.toList((Collection)groupConfigs, GroupConfig::getGroupName);
    }

    @Override
    public List<String> getOnlinePods(String groupName) {
        List serverNodes = this.serverNodeMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ServerNode::getNamespaceId, (Object)UserSessionUtils.currentUserSession().getNamespaceId())).eq(ServerNode::getGroupName, (Object)groupName));
        return StreamUtils.toList((Collection)serverNodes, serverNode -> serverNode.getHostIp() + ":" + serverNode.getHostPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Integer> getTablePartitionList() {
        DataSource dataSource = this.jdbcTemplate.getDataSource();
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            String catalog = connection.getCatalog();
            String schema = connection.getSchema();
            String tableNamePattern = "sj_retry_task_%";
            DbTypeEnum dbType = DbUtils.getDbType();
            if (DbTypeEnum.ORACLE.getDb().equals(dbType.getDb())) {
                tableNamePattern = tableNamePattern.toUpperCase();
            }
            DatabaseMetaData metaData = connection.getMetaData();
            ResultSet tables = metaData.getTables(catalog, schema, tableNamePattern, new String[]{"TABLE"});
            ArrayList<String> tableList = new ArrayList<String>();
            while (tables.next()) {
                String tableName = tables.getString("TABLE_NAME");
                tableList.add(tableName);
            }
            List<Integer> list = tableList.stream().map(ReUtil::getFirstNumber).filter(i -> !Objects.isNull(i)).distinct().collect(Collectors.toList());
            return list;
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (Objects.nonNull(connection)) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return Lists.newArrayList();
    }

    public GroupConfigServiceImpl(ServerNodeMapper serverNodeMapper, AccessTemplate accessTemplate, SequenceAllocMapper sequenceAllocMapper, ConfigVersionSyncHandler configVersionSyncHandler, SystemProperties systemProperties, JdbcTemplate jdbcTemplate, NamespaceMapper namespaceMapper) {
        this.serverNodeMapper = serverNodeMapper;
        this.accessTemplate = accessTemplate;
        this.sequenceAllocMapper = sequenceAllocMapper;
        this.configVersionSyncHandler = configVersionSyncHandler;
        this.systemProperties = systemProperties;
        this.jdbcTemplate = jdbcTemplate;
        this.namespaceMapper = namespaceMapper;
    }
}

