/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.service.handler;

import cn.hutool.core.lang.Assert;
import com.aizuda.snailjob.common.core.constant.SystemConstants;
import com.aizuda.snailjob.common.core.enums.WorkflowNodeTypeEnum;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.server.common.dto.CallbackConfig;
import com.aizuda.snailjob.server.common.dto.DecisionConfig;
import com.aizuda.snailjob.server.common.dto.JobTaskConfig;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.web.model.request.WorkflowRequestVO;
import com.aizuda.snailjob.server.web.model.response.WorkflowDetailResponseVO;
import com.aizuda.snailjob.server.web.service.convert.WorkflowConverter;
import com.aizuda.snailjob.template.datasource.persistence.mapper.WorkflowNodeMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.WorkflowNode;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.graph.MutableGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="webWorkflowHandler")
public class WorkflowHandler {
    private static final Logger log = LoggerFactory.getLogger(WorkflowHandler.class);
    private final WorkflowNodeMapper workflowNodeMapper;

    public WorkflowDetailResponseVO.NodeConfig buildNodeConfig(MutableGraph<Long> graph, Long parentId, Map<Long, WorkflowDetailResponseVO.NodeConfig> nodeConfigMap, Map<Long, WorkflowDetailResponseVO.NodeInfo> workflowNodeMap) {
        Set successors = graph.successors((Object)parentId);
        if (CollectionUtils.isEmpty((Collection)successors)) {
            return null;
        }
        WorkflowDetailResponseVO.NodeInfo previousNodeInfo = workflowNodeMap.get(parentId);
        WorkflowDetailResponseVO.NodeConfig currentConfig = new WorkflowDetailResponseVO.NodeConfig();
        currentConfig.setConditionNodes(Lists.newArrayList());
        boolean mount = false;
        for (Long successor : Sets.newTreeSet((Iterable)successors)) {
            Set predecessors = graph.predecessors((Object)successor);
            WorkflowDetailResponseVO.NodeInfo nodeInfo = workflowNodeMap.get(successor);
            currentConfig.setNodeType(nodeInfo.getNodeType());
            currentConfig.getConditionNodes().add(nodeInfo);
            nodeConfigMap.put(successor, currentConfig);
            if (predecessors.size() >= 2) {
                Object predecessor2;
                HashMap<Long, TreeSet> sets = new HashMap<Long, TreeSet>();
                for (Object predecessor2 : predecessors) {
                    TreeSet set = Sets.newTreeSet();
                    sets.put((Long)predecessor2, set);
                    this.findCommonAncestor((Long)predecessor2, set, graph);
                }
                Set intersection = (Set)sets.values().stream().findFirst().get();
                predecessor2 = sets.values().iterator();
                while (predecessor2.hasNext()) {
                    Set value = (Set)predecessor2.next();
                    intersection = Sets.intersection((Set)value, (Set)intersection);
                }
                Long commonAncestor = (Long)intersection.stream().toList().get(intersection.size() - 1);
                WorkflowDetailResponseVO.NodeConfig parentNodeConfig = nodeConfigMap.get(Sets.newTreeSet((Iterable)graph.successors((Object)commonAncestor)).stream().findFirst().get());
                parentNodeConfig.setChildNode(currentConfig);
                mount = false;
            } else {
                mount = true;
            }
            this.buildNodeConfig(graph, successor, nodeConfigMap, workflowNodeMap);
        }
        if (!parentId.equals(SystemConstants.ROOT) && mount) {
            previousNodeInfo.setChildNode(currentConfig);
        }
        currentConfig.getConditionNodes().sort(Comparator.comparing(WorkflowDetailResponseVO.NodeInfo::getPriorityLevel));
        return currentConfig;
    }

    private void findCommonAncestor(Long predecessor, Set<Long> set, MutableGraph<Long> graph) {
        Set predecessors = graph.predecessors((Object)predecessor);
        if (CollectionUtils.isEmpty((Collection)predecessors)) {
            return;
        }
        set.addAll(predecessors);
        this.findCommonAncestor((Long)new ArrayList(predecessors).get(0), set, graph);
    }

    public void buildGraph(List<Long> parentIds, LinkedBlockingDeque<Long> deque, String groupName, Long workflowId, WorkflowRequestVO.NodeConfig nodeConfig, MutableGraph<Long> graph, Integer version) {
        WorkflowRequestVO.NodeConfig childNode;
        if (Objects.isNull(nodeConfig)) {
            return;
        }
        List<WorkflowRequestVO.NodeInfo> conditionNodes = nodeConfig.getConditionNodes();
        if (!CollectionUtils.isEmpty(conditionNodes)) {
            conditionNodes = conditionNodes.stream().sorted(Comparator.comparing(WorkflowRequestVO.NodeInfo::getPriorityLevel)).collect(Collectors.toList());
            for (WorkflowRequestVO.NodeInfo nodeInfo : conditionNodes) {
                WorkflowNode workflowNode = WorkflowConverter.INSTANCE.convert(nodeInfo);
                workflowNode.setWorkflowId(workflowId);
                workflowNode.setGroupName(groupName);
                workflowNode.setNodeType(nodeConfig.getNodeType());
                workflowNode.setVersion(version);
                if (WorkflowNodeTypeEnum.DECISION.getType() == nodeConfig.getNodeType().intValue()) {
                    workflowNode.setJobId(SystemConstants.DECISION_JOB_ID);
                    DecisionConfig decision = nodeInfo.getDecision();
                    Assert.notNull((Object)decision, () -> new SnailJobServerException("\u3010{}\u3011\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", new Object[]{nodeInfo.getNodeName()}));
                    Assert.notBlank((CharSequence)decision.getNodeExpression(), () -> new SnailJobServerException("\u3010{}\u3011\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", new Object[]{nodeInfo.getNodeName()}));
                    Assert.notNull((Object)decision.getDefaultDecision(), () -> new SnailJobServerException("\u3010{}\u3011\u9ed8\u8ba4\u51b3\u7b56\u4e0d\u80fd\u4e3a\u7a7a", new Object[]{nodeInfo.getNodeName()}));
                    Assert.notNull((Object)decision.getExpressionType(), () -> new SnailJobServerException("\u3010{}\u3011\u8868\u8fbe\u5f0f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", new Object[]{nodeInfo.getNodeName()}));
                    workflowNode.setNodeInfo(JsonUtil.toJsonString((Object)decision));
                }
                if (WorkflowNodeTypeEnum.CALLBACK.getType() == nodeConfig.getNodeType().intValue()) {
                    workflowNode.setJobId(SystemConstants.CALLBACK_JOB_ID);
                    CallbackConfig callback = nodeInfo.getCallback();
                    Assert.notNull((Object)callback, () -> new SnailJobServerException("\u3010{}\u3011\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", new Object[]{nodeInfo.getNodeName()}));
                    Assert.notBlank((CharSequence)callback.getWebhook(), () -> new SnailJobServerException("\u3010{}\u3011webhook\u4e0d\u80fd\u4e3a\u7a7a", new Object[]{nodeInfo.getNodeName()}));
                    Assert.notNull((Object)callback.getContentType(), () -> new SnailJobServerException("\u3010{}\u3011\u8bf7\u6c42\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", new Object[]{nodeInfo.getNodeName()}));
                    Assert.notBlank((CharSequence)callback.getSecret(), () -> new SnailJobServerException("\u3010{}\u3011\u79d8\u94a5\u4e0d\u80fd\u4e3a\u7a7a", new Object[]{nodeInfo.getNodeName()}));
                    workflowNode.setNodeInfo(JsonUtil.toJsonString((Object)callback));
                }
                if (WorkflowNodeTypeEnum.JOB_TASK.getType() == nodeConfig.getNodeType().intValue()) {
                    JobTaskConfig jobTask = nodeInfo.getJobTask();
                    Assert.notNull((Object)jobTask, () -> new SnailJobServerException("\u3010{}\u3011\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", new Object[]{nodeInfo.getNodeName()}));
                    Assert.notNull((Object)jobTask.getJobId(), () -> new SnailJobServerException("\u3010{}\u3011\u6240\u5c5e\u4efb\u52a1\u4e0d\u80fd\u4e3a\u7a7a", new Object[]{nodeInfo.getNodeName()}));
                    workflowNode.setJobId(jobTask.getJobId());
                }
                Assert.isTrue((1 == this.workflowNodeMapper.insert((Object)workflowNode) ? 1 : 0) != 0, () -> new SnailJobServerException("\u65b0\u589e\u5de5\u4f5c\u6d41\u8282\u70b9\u5931\u8d25"));
                graph.addNode((Object)workflowNode.getId());
                for (Long parentId : parentIds) {
                    graph.putEdge((Object)parentId, (Object)workflowNode.getId());
                }
                WorkflowRequestVO.NodeConfig childNode2 = nodeInfo.getChildNode();
                if (Objects.nonNull(childNode2) && !CollectionUtils.isEmpty(childNode2.getConditionNodes())) {
                    this.buildGraph(Lists.newArrayList((Object[])new Long[]{workflowNode.getId()}), deque, groupName, workflowId, childNode2, graph, version);
                    continue;
                }
                if (WorkflowNodeTypeEnum.DECISION.getType() == nodeConfig.getNodeType().intValue()) {
                    throw new SnailJobServerException("\u51b3\u7b56\u8282\u70b9\u4e0d\u80fd\u4f5c\u4e3a\u53f6\u5b50\u8282\u70b9");
                }
                deque.add(workflowNode.getId());
            }
        }
        if (Objects.nonNull(childNode = nodeConfig.getChildNode()) && !CollectionUtils.isEmpty(childNode.getConditionNodes())) {
            ArrayList list = Lists.newArrayList();
            deque.drainTo(list);
            this.buildGraph(list, deque, groupName, workflowId, childNode, graph, version);
        }
    }

    public WorkflowHandler(WorkflowNodeMapper workflowNodeMapper) {
        this.workflowNodeMapper = workflowNodeMapper;
    }
}

