/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.controller;

import com.aizuda.snailjob.server.web.annotation.LoginRequired;
import com.aizuda.snailjob.server.web.annotation.LoginUser;
import com.aizuda.snailjob.server.web.annotation.RoleEnum;
import com.aizuda.snailjob.server.web.model.base.PageResult;
import com.aizuda.snailjob.server.web.model.request.SystemUserQueryVO;
import com.aizuda.snailjob.server.web.model.request.SystemUserRequestVO;
import com.aizuda.snailjob.server.web.model.request.UserSessionVO;
import com.aizuda.snailjob.server.web.model.response.PermissionsResponseVO;
import com.aizuda.snailjob.server.web.model.response.SystemUserResponseVO;
import com.aizuda.snailjob.server.web.service.SystemUserService;
import jakarta.validation.Valid;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SystemUserController {
    @Autowired
    private SystemUserService systemUserService;

    @PostMapping(value={"/auth/login"})
    public SystemUserResponseVO login(@RequestBody SystemUserRequestVO requestVO) {
        return this.systemUserService.login(requestVO);
    }

    @LoginRequired
    @GetMapping(value={"/user/info"})
    public SystemUserResponseVO getUserInfo(@LoginUser UserSessionVO systemUser) {
        return this.systemUserService.getUserInfo(systemUser);
    }

    @LoginRequired(role=RoleEnum.ADMIN)
    @PostMapping(value={"/user"})
    public void addUser(@RequestBody @Valid SystemUserRequestVO requestVO) {
        this.systemUserService.addUser(requestVO);
    }

    @LoginRequired(role=RoleEnum.ADMIN)
    @GetMapping(value={"/user/page/list"})
    public PageResult<List<SystemUserResponseVO>> getSystemUserPageList(SystemUserQueryVO systemUserQueryVO) {
        return this.systemUserService.getSystemUserPageList(systemUserQueryVO);
    }

    @LoginRequired(role=RoleEnum.ADMIN)
    @PutMapping(value={"/user"})
    public void update(@RequestBody @Valid SystemUserRequestVO requestVO) {
        this.systemUserService.update(requestVO);
    }

    @LoginRequired(role=RoleEnum.ADMIN)
    @GetMapping(value={"/user/username/user-info"})
    public SystemUserResponseVO getSystemUserByUserName(@RequestParam(value="username") String username) {
        return this.systemUserService.getSystemUserByUserName(username);
    }

    @LoginRequired(role=RoleEnum.ADMIN)
    @GetMapping(value={"/user-permissions/{id}"})
    public List<PermissionsResponseVO> getSystemUserPermissionByUserName(@PathVariable(value="id") Long id) {
        return this.systemUserService.getSystemUserPermissionByUserName(id);
    }

    @LoginRequired
    @DeleteMapping(value={"/user/{id}"})
    public boolean delUser(@PathVariable(value="id") Long id) {
        return this.systemUserService.delUser(id);
    }
}

