/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.controller;

import com.aizuda.snailjob.server.web.annotation.LoginRequired;
import com.aizuda.snailjob.server.web.model.base.PageResult;
import com.aizuda.snailjob.server.web.model.request.NotifyRecipientQueryVO;
import com.aizuda.snailjob.server.web.model.request.NotifyRecipientRequestVO;
import com.aizuda.snailjob.server.web.model.response.CommonLabelValueResponseVO;
import com.aizuda.snailjob.server.web.model.response.NotifyRecipientResponseVO;
import com.aizuda.snailjob.server.web.service.NotifyRecipientService;
import java.util.List;
import java.util.Set;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/notify-recipient"})
public class NotifyRecipientController {
    private final NotifyRecipientService notifyRecipientService;

    @PostMapping
    @LoginRequired
    public Boolean saveNotifyRecipient(@RequestBody @Validated NotifyRecipientRequestVO requestVO) {
        return this.notifyRecipientService.saveNotifyRecipient(requestVO);
    }

    @PutMapping
    @LoginRequired
    public Boolean updateNotifyRecipient(@RequestBody @Validated NotifyRecipientRequestVO requestVO) {
        return this.notifyRecipientService.updateNotifyRecipient(requestVO);
    }

    @GetMapping(value={"/page/list"})
    @LoginRequired
    public PageResult<List<NotifyRecipientResponseVO>> getNotifyRecipientPageList(NotifyRecipientQueryVO queryVO) {
        return this.notifyRecipientService.getNotifyRecipientPageList(queryVO);
    }

    @GetMapping(value={"/list"})
    @LoginRequired
    public List<CommonLabelValueResponseVO> getNotifyRecipientList() {
        return this.notifyRecipientService.getNotifyRecipientList();
    }

    @DeleteMapping(value={"/ids"})
    @LoginRequired
    public Boolean batchDeleteByIds(@RequestBody Set<Long> ids) {
        return this.notifyRecipientService.batchDeleteByIds(ids);
    }

    public NotifyRecipientController(NotifyRecipientService notifyRecipientService) {
        this.notifyRecipientService = notifyRecipientService;
    }
}

