/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.controller;

import com.aizuda.snailjob.server.web.annotation.LoginRequired;
import com.aizuda.snailjob.server.web.annotation.LoginUser;
import com.aizuda.snailjob.server.web.annotation.RoleEnum;
import com.aizuda.snailjob.server.web.model.base.PageResult;
import com.aizuda.snailjob.server.web.model.request.GroupConfigQueryVO;
import com.aizuda.snailjob.server.web.model.request.GroupConfigRequestVO;
import com.aizuda.snailjob.server.web.model.request.UserSessionVO;
import com.aizuda.snailjob.server.web.model.response.GroupConfigResponseVO;
import com.aizuda.snailjob.server.web.service.GroupConfigService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/group"})
public class GroupConfigController {
    @Autowired
    private GroupConfigService groupConfigService;

    @LoginRequired(role=RoleEnum.ADMIN)
    @PostMapping(value={""})
    public Boolean addGroup(@LoginUser UserSessionVO systemUser, @RequestBody @Validated GroupConfigRequestVO groupConfigRequestVO) {
        return this.groupConfigService.addGroup(systemUser, groupConfigRequestVO);
    }

    @LoginRequired(role=RoleEnum.ADMIN)
    @PutMapping(value={""})
    public Boolean updateGroup(@RequestBody @Validated GroupConfigRequestVO groupConfigRequestVO) {
        return this.groupConfigService.updateGroup(groupConfigRequestVO);
    }

    @LoginRequired(role=RoleEnum.ADMIN)
    @PutMapping(value={"status"})
    public Boolean updateGroupStatus(@RequestBody @Validated GroupConfigRequestVO groupConfigRequestVO) {
        String groupName = groupConfigRequestVO.getGroupName();
        Integer groupStatus = groupConfigRequestVO.getGroupStatus();
        return this.groupConfigService.updateGroupStatus(groupName, groupStatus);
    }

    @LoginRequired
    @GetMapping(value={"list"})
    public PageResult<List<GroupConfigResponseVO>> getGroupConfigForPage(GroupConfigQueryVO queryVO) {
        return this.groupConfigService.getGroupConfigForPage(queryVO);
    }

    @LoginRequired
    @GetMapping(value={"{groupName}"})
    public GroupConfigResponseVO getGroupConfigByGroupName(@PathVariable(value="groupName") String groupName) {
        return this.groupConfigService.getGroupConfigByGroupName(groupName);
    }

    @LoginRequired
    @PostMapping(value={"/all/group-config/list"})
    public List<GroupConfigResponseVO> getAllGroupNameList(@RequestBody List<String> namespaceIds) {
        return this.groupConfigService.getAllGroupConfigList(namespaceIds);
    }

    @LoginRequired
    @GetMapping(value={"/all/group-name/list"})
    public List<String> getAllGroupNameList() {
        return this.groupConfigService.getAllGroupNameList();
    }

    @LoginRequired
    @GetMapping(value={"/on-line/pods/{groupName}"})
    public List<String> getOnlinePods(@PathVariable(value="groupName") String groupName) {
        return this.groupConfigService.getOnlinePods(groupName);
    }

    @LoginRequired(role=RoleEnum.ADMIN)
    @GetMapping(value={"/partition-table/list"})
    public List<Integer> getTablePartitionList() {
        return this.groupConfigService.getTablePartitionList();
    }
}

