/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.aizuda.snailjob.common.core.constant.SystemConstants;
import com.aizuda.snailjob.common.core.enums.JobOperationReasonEnum;
import com.aizuda.snailjob.common.core.enums.JobTaskBatchStatusEnum;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.model.request.JobTaskConfigRequest;
import com.aizuda.snailjob.model.response.base.JobBatchResponse;
import com.aizuda.snailjob.model.response.base.WorkflowDetailResponse;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.job.task.support.cache.MutableGraphCache;
import com.aizuda.snailjob.server.service.convert.JobBatchResponseConverter;
import com.aizuda.snailjob.server.service.convert.WorkflowConverter;
import com.aizuda.snailjob.server.service.handler.WorkflowHandler;
import com.aizuda.snailjob.server.service.service.WorkflowBatchService;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobTaskBatchMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.WorkflowMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.WorkflowNodeMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.WorkflowTaskBatchMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.Job;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTaskBatch;
import com.aizuda.snailjob.template.datasource.persistence.po.Workflow;
import com.aizuda.snailjob.template.datasource.persistence.po.WorkflowNode;
import com.aizuda.snailjob.template.datasource.persistence.po.WorkflowTaskBatch;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.graph.MutableGraph;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractWorkflowBatchService
implements WorkflowBatchService {
    private static final Integer WORKFLOW_DECISION_FAILED_STATUS = 98;
    @Autowired
    protected WorkflowTaskBatchMapper workflowTaskBatchMapper;
    @Autowired
    protected WorkflowMapper workflowMapper;
    @Autowired
    protected WorkflowNodeMapper workflowNodeMapper;
    @Autowired
    protected JobTaskBatchMapper jobTaskBatchMapper;
    @Autowired
    protected JobMapper jobMapper;
    @Autowired
    protected WorkflowHandler workflowHandler;

    @Override
    public <T extends WorkflowDetailResponse> T getWorkflowBatchById(Long workflowBatchId, Class<T> clazz) {
        WorkflowDetailResponse responseVO;
        WorkflowTaskBatch workflowTaskBatch = (WorkflowTaskBatch)this.workflowTaskBatchMapper.selectById((Serializable)workflowBatchId);
        if (Objects.isNull(workflowTaskBatch)) {
            return null;
        }
        Workflow workflow = (Workflow)this.workflowMapper.selectById((Serializable)workflowTaskBatch.getWorkflowId());
        try {
            responseVO = (WorkflowDetailResponse)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            WorkflowConverter.INSTANCE.fillCommonFields(workflow, responseVO);
        }
        catch (Exception e) {
            throw new SnailJobServerException("Failed to get workflow batch by id [{}]", new Object[]{workflowBatchId, e});
        }
        responseVO.setWorkflowBatchStatus(workflowTaskBatch.getTaskBatchStatus());
        responseVO.setWfContext(workflowTaskBatch.getWfContext());
        List workflowNodes = this.workflowNodeMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(WorkflowNode::getDeleted, (Object)StatusEnum.NO.getStatus())).eq(WorkflowNode::getWorkflowId, (Object)workflow.getId()));
        List jobs = this.jobMapper.selectList((Wrapper)new LambdaQueryWrapper().in(Job::getId, (Collection)StreamUtils.toSet((Collection)workflowNodes, WorkflowNode::getJobId)));
        Map jobMap = StreamUtils.toIdentityMap((Collection)jobs, Job::getId);
        List alJobTaskBatchList = this.jobTaskBatchMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(JobTaskBatch::getWorkflowTaskBatchId, (Object)workflowBatchId)).orderByDesc(JobTaskBatch::getId));
        Map jobTaskBatchMap = StreamUtils.groupByKey((Collection)alJobTaskBatchList, JobTaskBatch::getWorkflowNodeId);
        List<WorkflowDetailResponse.NodeInfo> nodeInfos = WorkflowConverter.INSTANCE.convertList(workflowNodes);
        String flowInfo = workflowTaskBatch.getFlowInfo();
        MutableGraph graph = MutableGraphCache.getOrDefault((Long)workflowBatchId, (String)flowInfo);
        HashSet allNoOperationNode = Sets.newHashSet();
        Map<Long, WorkflowDetailResponse.NodeInfo> workflowNodeMap = nodeInfos.stream().peek(nodeInfo -> {
            List<JobTaskBatch> jobTaskBatchList;
            JobTaskConfigRequest jobTask = nodeInfo.getJobTask();
            if (Objects.nonNull(jobTask)) {
                jobTask.setJobName(jobMap.getOrDefault(jobTask.getJobId(), new Job()).getJobName());
            }
            if (CollUtil.isNotEmpty((Collection)(jobTaskBatchList = (List<JobTaskBatch>)jobTaskBatchMap.get(nodeInfo.getId())))) {
                jobTaskBatchList = jobTaskBatchList.stream().sorted(Comparator.comparingInt(JobTaskBatch::getTaskBatchStatus)).collect(Collectors.toList());
                nodeInfo.setJobBatchList(JobBatchResponseConverter.INSTANCE.convertListToJobBatchList(jobTaskBatchList));
                JobTaskBatch jobTaskBatch = jobTaskBatchList.get(0);
                if (JobOperationReasonEnum.WORKFLOW_DECISION_FAILED.getReason() == jobTaskBatch.getOperationReason().intValue()) {
                    nodeInfo.setTaskBatchStatus(WORKFLOW_DECISION_FAILED_STATUS);
                } else {
                    nodeInfo.setTaskBatchStatus(jobTaskBatch.getTaskBatchStatus());
                }
                if (jobTaskBatchList.stream().filter(Objects::nonNull).anyMatch(AbstractWorkflowBatchService::isNoOperation)) {
                    Set allDescendants = MutableGraphCache.getAllDescendants((MutableGraph)graph, (Long)nodeInfo.getId());
                    allNoOperationNode.addAll(allDescendants);
                } else {
                    allNoOperationNode.remove(nodeInfo.getId());
                }
            } else if (JobTaskBatchStatusEnum.NOT_SUCCESS.contains(workflowTaskBatch.getTaskBatchStatus())) {
                allNoOperationNode.add(nodeInfo.getId());
            }
        }).collect(Collectors.toMap(WorkflowDetailResponse.NodeInfo::getId, Function.identity()));
        for (Long noOperationNodeId : allNoOperationNode) {
            WorkflowDetailResponse.NodeInfo nodeInfo2 = (WorkflowDetailResponse.NodeInfo)workflowNodeMap.get(noOperationNodeId);
            List<JobTaskBatch> jobTaskBatches = (List<JobTaskBatch>)jobTaskBatchMap.get(nodeInfo2.getId());
            if (CollUtil.isNotEmpty((Collection)jobTaskBatches)) {
                jobTaskBatches = jobTaskBatches.stream().sorted(Comparator.comparingInt(JobTaskBatch::getTaskBatchStatus)).collect(Collectors.toList());
                nodeInfo2.setJobBatchList(JobBatchResponseConverter.INSTANCE.convertListToJobBatchList(jobTaskBatches));
                continue;
            }
            JobBatchResponse jobBatchResponse = new JobBatchResponse();
            JobTaskConfigRequest jobTask = nodeInfo2.getJobTask();
            if (Objects.nonNull(jobTask)) {
                jobBatchResponse.setJobId(jobTask.getJobId());
            }
            nodeInfo2.setJobBatchList((List)Lists.newArrayList((Object[])new JobBatchResponse[]{jobBatchResponse}));
        }
        try {
            WorkflowDetailResponse.NodeConfig config = this.workflowHandler.buildNodeConfig((MutableGraph<Long>)graph, SystemConstants.ROOT, new HashMap<Long, WorkflowDetailResponse.NodeConfig>(), workflowNodeMap);
            responseVO.setNodeConfig(config);
        }
        catch (Exception e) {
            SnailJobLog.LOCAL.error("Deserialization failed. json:[{}]", new Object[]{flowInfo, e});
            throw new SnailJobServerException("Failed to query workflow batch details");
        }
        return (T)responseVO;
    }

    private static boolean isNoOperation(JobTaskBatch i) {
        return JobOperationReasonEnum.WORKFLOW_SUCCESSOR_SKIP_EXECUTION.contains(i.getOperationReason()) || i.getTaskBatchStatus().intValue() == JobTaskBatchStatusEnum.STOP.getStatus();
    }
}

