/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.service.convert;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.core.enums.WorkflowNodeTypeEnum;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.model.request.DecisionConfigRequest;
import com.aizuda.snailjob.model.request.JobTaskConfigRequest;
import com.aizuda.snailjob.model.response.base.WorkflowDetailResponse;
import com.aizuda.snailjob.server.common.dto.PointInTimeDTO;
import com.aizuda.snailjob.server.common.strategy.WaitStrategies;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.server.service.convert.JobConverter;
import com.aizuda.snailjob.template.datasource.persistence.po.Workflow;
import com.aizuda.snailjob.template.datasource.persistence.po.WorkflowNode;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.mapstruct.factory.Mappers;

@Mapper
public interface WorkflowConverter {
    public static final WorkflowConverter INSTANCE = (WorkflowConverter)Mappers.getMapper(WorkflowConverter.class);

    @Mappings(value={@Mapping(target="notifyIds", expression="java(WorkflowConverter.toNotifyIds(workflow.getNotifyIds()))"), @Mapping(target="triggerInterval", expression="java(WorkflowConverter.toTriggerInterval(workflow))"), @Mapping(target="ownerId", expression="java(WorkflowConverter.getOwnerId(workflow))")})
    public WorkflowDetailResponse convert(Workflow var1);

    @Mappings(value={@Mapping(target="notifyIds", expression="java(WorkflowConverter.toNotifyIds(workflow.getNotifyIds()))"), @Mapping(target="triggerInterval", expression="java(WorkflowConverter.toTriggerInterval(workflow))"), @Mapping(target="ownerId", expression="java(WorkflowConverter.getOwnerId(workflow))")})
    public void fillCommonFields(Workflow var1, @MappingTarget WorkflowDetailResponse var2);

    public List<WorkflowDetailResponse.NodeInfo> convertList(List<WorkflowNode> var1);

    @Mappings(value={@Mapping(target="decision", expression="java(WorkflowConverter.parseDecisionConfig(workflowNode))"), @Mapping(target="jobTask", expression="java(WorkflowConverter.parseJobTaskConfig(workflowNode))")})
    public WorkflowDetailResponse.NodeInfo convert(WorkflowNode var1);

    public static Long getOwnerId(Workflow workflow) {
        return Objects.nonNull(workflow.getOwnerId()) && workflow.getOwnerId() > 0L ? workflow.getOwnerId() : null;
    }

    public static LocalDateTime toLocalDateTime(Long nextTriggerAt) {
        return JobConverter.toLocalDateTime(nextTriggerAt);
    }

    public static DecisionConfigRequest parseDecisionConfig(WorkflowNode workflowNode) {
        if (WorkflowNodeTypeEnum.DECISION.getType() == workflowNode.getNodeType().intValue()) {
            return (DecisionConfigRequest)JsonUtil.parseObject((String)workflowNode.getNodeInfo(), DecisionConfigRequest.class);
        }
        return null;
    }

    public static JobTaskConfigRequest parseJobTaskConfig(WorkflowNode workflowNode) {
        if (WorkflowNodeTypeEnum.JOB_TASK.getType() == workflowNode.getNodeType().intValue()) {
            JobTaskConfigRequest jobTaskConfigRequest = new JobTaskConfigRequest();
            jobTaskConfigRequest.setJobId(workflowNode.getJobId());
            return jobTaskConfigRequest;
        }
        return null;
    }

    public static Set<Long> toNotifyIds(String notifyIds) {
        if (StrUtil.isBlank((CharSequence)notifyIds)) {
            return new HashSet<Long>();
        }
        return new HashSet<Long>(JsonUtil.parseList((String)notifyIds, Long.class));
    }

    public static String toNotifyIdsStr(Set<Long> notifyIds) {
        if (CollUtil.isEmpty(notifyIds)) {
            return "";
        }
        return JsonUtil.toJsonString(notifyIds);
    }

    public static String toTriggerInterval(Workflow workflow) {
        String triggerInterval = workflow.getTriggerInterval();
        Integer triggerType = workflow.getTriggerType();
        if (WaitStrategies.WaitStrategyEnum.POINT_IN_TIME.getType().equals(triggerType)) {
            List pointInTimeDTOS = JsonUtil.parseList((String)triggerInterval, PointInTimeDTO.class);
            List<String> timeStrList = pointInTimeDTOS.stream().map(time -> DateUtils.format((LocalDateTime)DateUtils.toLocalDateTime((Long)time.getTime()))).toList();
            return JsonUtil.toJsonString(timeStrList);
        }
        return triggerInterval;
    }
}

