/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.model.request.base.StatusUpdateRequest;
import com.aizuda.snailjob.model.request.base.WorkflowTriggerRequest;
import com.aizuda.snailjob.server.common.enums.JobTaskExecutorSceneEnum;
import com.aizuda.snailjob.server.common.enums.SyetemTaskTypeEnum;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.server.job.task.dto.WorkflowTaskPrepareDTO;
import com.aizuda.snailjob.server.job.task.support.prepare.workflow.TerminalWorkflowPrepareHandler;
import com.aizuda.snailjob.server.service.convert.WorkflowTaskConverter;
import com.aizuda.snailjob.server.service.kit.WorkflowKit;
import com.aizuda.snailjob.server.service.service.WorkflowService;
import com.aizuda.snailjob.template.datasource.access.AccessTemplate;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobSummaryMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.WorkflowMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.GroupConfig;
import com.aizuda.snailjob.template.datasource.persistence.po.JobSummary;
import com.aizuda.snailjob.template.datasource.persistence.po.Workflow;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractWorkflowService
implements WorkflowService {
    @Autowired
    protected WorkflowMapper workflowMapper;
    @Autowired
    protected AccessTemplate accessTemplate;
    @Autowired
    protected TerminalWorkflowPrepareHandler terminalWorkflowPrepareHandler;
    @Autowired
    protected JobSummaryMapper jobSummaryMapper;

    @Override
    public boolean updateWorkFlowStatus(StatusUpdateRequest requestDTO) {
        Assert.notNull((Object)StatusEnum.of((Integer)requestDTO.getStatus()), () -> new SnailJobServerException("Status cannot be empty"));
        Workflow workflow = (Workflow)this.workflowMapper.selectById((Serializable)requestDTO.getId());
        Assert.notNull((Object)workflow, (String)"workflow does not exist", (Object[])new Object[0]);
        if (Objects.equals(requestDTO.getStatus(), workflow.getWorkflowStatus())) {
            return true;
        }
        Workflow updateWorkflow = new Workflow();
        if (Objects.equals(requestDTO.getStatus(), StatusEnum.YES.getStatus())) {
            updateWorkflow.setNextTriggerAt(WorkflowKit.calculateNextTriggerAt(workflow.getTriggerType(), workflow.getTriggerInterval(), DateUtils.toNowMilli()));
        }
        updateWorkflow.setId(workflow.getId());
        updateWorkflow.setWorkflowStatus(requestDTO.getStatus());
        return 1 == this.workflowMapper.updateById((Object)updateWorkflow);
    }

    @Override
    public boolean triggerWorkFlow(WorkflowTriggerRequest request) {
        HashSet<String> namesSet;
        Workflow workflow = (Workflow)this.workflowMapper.selectById((Serializable)request.getWorkflowId());
        Assert.notNull((Object)workflow, () -> new SnailJobServerException("workflow can not be null."));
        Assert.isTrue((boolean)workflow.getNamespaceId().equals(this.getNamespaceId()), () -> new SnailJobServerException("namespace id not match."));
        if (StrUtil.isNotBlank((CharSequence)workflow.getGroupName()) && CollectionUtil.isNotEmpty(namesSet = new HashSet<String>(Arrays.asList(workflow.getGroupName().split(", "))))) {
            for (String groupName : namesSet) {
                long count = this.accessTemplate.getGroupConfigAccess().count((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(GroupConfig::getGroupName, (Object)groupName)).eq(GroupConfig::getNamespaceId, (Object)workflow.getNamespaceId())).eq(GroupConfig::getGroupStatus, (Object)StatusEnum.YES.getStatus()));
                Assert.isTrue((count > 0L ? 1 : 0) != 0, () -> new SnailJobServerException("Group [{}] is closed, manual execution is not supported.", new Object[]{workflow.getGroupName()}));
            }
        }
        WorkflowTaskPrepareDTO prepareDTO = WorkflowTaskConverter.INSTANCE.toWorkflowTaskPrepareDTO(workflow);
        prepareDTO.setNextTriggerAt(DateUtils.toNowMilli());
        prepareDTO.setTaskExecutorScene(JobTaskExecutorSceneEnum.MANUAL_WORKFLOW.getType());
        String tmpWfContext = request.getTmpWfContext();
        if (StrUtil.isNotBlank((CharSequence)tmpWfContext) && !JsonUtil.isEmptyJson((String)tmpWfContext)) {
            Map tmpWfContextMap = JsonUtil.parseHashMap((String)tmpWfContext);
            Map wfContextMap = JsonUtil.parseHashMap((String)workflow.getWfContext());
            tmpWfContextMap.putAll(wfContextMap);
            prepareDTO.setWfContext(JsonUtil.toJsonString((Object)tmpWfContextMap));
        }
        this.terminalWorkflowPrepareHandler.handler(prepareDTO);
        return true;
    }

    @Override
    public boolean deleteWorkflowByIds(Set<Long> ids) {
        Assert.isTrue(((long)ids.size() == this.workflowMapper.selectCount((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Workflow::getNamespaceId, (Object)this.getNamespaceId())).eq(Workflow::getWorkflowStatus, (Object)StatusEnum.NO.getStatus())).in(Workflow::getId, ids)) ? 1 : 0) != 0, () -> new SnailJobServerException("Failed to delete workflow task, please check if the task status is closed"));
        List jobSummaries = this.jobSummaryMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{JobSummary::getId}).in(JobSummary::getBusinessId, ids)).eq(JobSummary::getNamespaceId, (Object)this.getNamespaceId())).eq(JobSummary::getSystemTaskType, (Object)SyetemTaskTypeEnum.WORKFLOW.getType()));
        if (CollUtil.isNotEmpty((Collection)jobSummaries)) {
            Assert.isTrue((jobSummaries.size() == this.jobSummaryMapper.deleteByIds((Collection)StreamUtils.toSet((Collection)jobSummaries, JobSummary::getId)) ? 1 : 0) != 0, () -> new SnailJobServerException("Summary table deletion failed"));
        }
        Assert.isTrue((ids.size() == this.workflowMapper.delete((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Workflow::getNamespaceId, (Object)this.getNamespaceId())).eq(Workflow::getWorkflowStatus, (Object)StatusEnum.NO.getStatus())).in(Workflow::getId, ids)) ? 1 : 0) != 0, () -> new SnailJobServerException("Failed to delete workflow task, please check if the task status is closed"));
        return true;
    }

    protected abstract String getNamespaceId();
}

