/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.service.convert;

import com.aizuda.snailjob.model.response.base.WorkflowDetailResponse;
import com.aizuda.snailjob.server.common.vo.WorkflowBatchResponseVO;
import com.aizuda.snailjob.server.common.vo.WorkflowResponseVO;
import com.aizuda.snailjob.server.common.vo.request.WorkflowRequestVO;
import com.aizuda.snailjob.server.service.convert.WorkflowConverter;
import com.aizuda.snailjob.template.datasource.persistence.dataobject.WorkflowBatchResponseDO;
import com.aizuda.snailjob.template.datasource.persistence.po.Workflow;
import com.aizuda.snailjob.template.datasource.persistence.po.WorkflowNode;
import com.aizuda.snailjob.template.datasource.persistence.po.WorkflowTaskBatch;
import java.util.ArrayList;
import java.util.List;

public class WorkflowConverterImpl
implements WorkflowConverter {
    @Override
    public Workflow convert(WorkflowRequestVO workflowRequestVO) {
        if (workflowRequestVO == null) {
            return null;
        }
        Workflow workflow = new Workflow();
        workflow.setId(workflowRequestVO.getId());
        workflow.setWorkflowName(workflowRequestVO.getWorkflowName());
        workflow.setGroupName(workflowRequestVO.getGroupName());
        workflow.setTriggerType(workflowRequestVO.getTriggerType());
        workflow.setBlockStrategy(workflowRequestVO.getBlockStrategy());
        workflow.setExecutorTimeout(workflowRequestVO.getExecutorTimeout());
        workflow.setWorkflowStatus(workflowRequestVO.getWorkflowStatus());
        workflow.setDescription(workflowRequestVO.getDescription());
        workflow.setWfContext(workflowRequestVO.getWfContext());
        workflow.setOwnerId(workflowRequestVO.getOwnerId());
        workflow.setNotifyIds(WorkflowConverter.toNotifyIdsStr(workflowRequestVO.getNotifyIds()));
        workflow.setTriggerInterval(WorkflowConverter.toTriggerInterval(workflowRequestVO));
        return workflow;
    }

    @Override
    public WorkflowNode convert(WorkflowRequestVO.NodeInfo nodeInfo) {
        if (nodeInfo == null) {
            return null;
        }
        WorkflowNode workflowNode = new WorkflowNode();
        workflowNode.setNodeName(nodeInfo.getNodeName());
        workflowNode.setFailStrategy(nodeInfo.getFailStrategy());
        workflowNode.setPriorityLevel(nodeInfo.getPriorityLevel());
        workflowNode.setWorkflowNodeStatus(nodeInfo.getWorkflowNodeStatus());
        return workflowNode;
    }

    @Override
    public WorkflowDetailResponse convert(Workflow workflow) {
        if (workflow == null) {
            return null;
        }
        WorkflowDetailResponse workflowDetailResponse = new WorkflowDetailResponse();
        workflowDetailResponse.setId(workflow.getId());
        workflowDetailResponse.setWorkflowName(workflow.getWorkflowName());
        workflowDetailResponse.setGroupName(workflow.getGroupName());
        workflowDetailResponse.setTriggerType(workflow.getTriggerType());
        workflowDetailResponse.setBlockStrategy(workflow.getBlockStrategy());
        workflowDetailResponse.setExecutorTimeout(workflow.getExecutorTimeout());
        workflowDetailResponse.setWorkflowStatus(workflow.getWorkflowStatus());
        workflowDetailResponse.setWfContext(workflow.getWfContext());
        workflowDetailResponse.setNotifyIds(WorkflowConverter.toNotifyIds(workflow.getNotifyIds()));
        workflowDetailResponse.setTriggerInterval(WorkflowConverter.toTriggerInterval(workflow));
        workflowDetailResponse.setOwnerId(WorkflowConverter.getOwnerId(workflow));
        return workflowDetailResponse;
    }

    @Override
    public void fillCommonFields(Workflow workflow, WorkflowDetailResponse target) {
        if (workflow == null) {
            return;
        }
        target.setId(workflow.getId());
        target.setWorkflowName(workflow.getWorkflowName());
        target.setGroupName(workflow.getGroupName());
        target.setTriggerType(workflow.getTriggerType());
        target.setBlockStrategy(workflow.getBlockStrategy());
        target.setExecutorTimeout(workflow.getExecutorTimeout());
        target.setWorkflowStatus(workflow.getWorkflowStatus());
        target.setWfContext(workflow.getWfContext());
        target.setNotifyIds(WorkflowConverter.toNotifyIds(workflow.getNotifyIds()));
        target.setTriggerInterval(WorkflowConverter.toTriggerInterval(workflow));
        target.setOwnerId(WorkflowConverter.getOwnerId(workflow));
    }

    @Override
    public List<WorkflowDetailResponse.NodeInfo> convertList(List<WorkflowNode> workflowNodes) {
        if (workflowNodes == null) {
            return null;
        }
        ArrayList<WorkflowDetailResponse.NodeInfo> list = new ArrayList<WorkflowDetailResponse.NodeInfo>(workflowNodes.size());
        for (WorkflowNode workflowNode : workflowNodes) {
            list.add(this.convert(workflowNode));
        }
        return list;
    }

    @Override
    public WorkflowDetailResponse.NodeInfo convert(WorkflowNode workflowNode) {
        if (workflowNode == null) {
            return null;
        }
        WorkflowDetailResponse.NodeInfo nodeInfo = new WorkflowDetailResponse.NodeInfo();
        nodeInfo.setId(workflowNode.getId());
        nodeInfo.setNodeType(workflowNode.getNodeType());
        nodeInfo.setNodeName(workflowNode.getNodeName());
        nodeInfo.setPriorityLevel(workflowNode.getPriorityLevel());
        nodeInfo.setWorkflowNodeStatus(workflowNode.getWorkflowNodeStatus());
        nodeInfo.setFailStrategy(workflowNode.getFailStrategy());
        nodeInfo.setDecision(WorkflowConverter.parseDecisionConfig(workflowNode));
        nodeInfo.setCallback(WorkflowConverter.parseCallbackConfig(workflowNode));
        nodeInfo.setJobTask(WorkflowConverter.parseJobTaskConfig(workflowNode));
        return nodeInfo;
    }

    @Override
    public WorkflowResponseVO convertToWorkflow(Workflow workflow) {
        if (workflow == null) {
            return null;
        }
        WorkflowResponseVO workflowResponseVO = new WorkflowResponseVO();
        workflowResponseVO.setId(workflow.getId());
        workflowResponseVO.setWorkflowName(workflow.getWorkflowName());
        workflowResponseVO.setGroupName(workflow.getGroupName());
        workflowResponseVO.setTriggerType(workflow.getTriggerType());
        workflowResponseVO.setExecutorTimeout(workflow.getExecutorTimeout());
        workflowResponseVO.setWorkflowStatus(workflow.getWorkflowStatus());
        workflowResponseVO.setCreateDt(workflow.getCreateDt());
        workflowResponseVO.setUpdateDt(workflow.getUpdateDt());
        workflowResponseVO.setWfContext(workflow.getWfContext());
        workflowResponseVO.setOwnerId(workflow.getOwnerId());
        workflowResponseVO.setNextTriggerAt(WorkflowConverter.toLocalDateTime(workflow.getNextTriggerAt()));
        workflowResponseVO.setNotifyIds(WorkflowConverter.toNotifyIds(workflow.getNotifyIds()));
        workflowResponseVO.setTriggerInterval(WorkflowConverter.toTriggerInterval(workflow));
        return workflowResponseVO;
    }

    @Override
    public List<WorkflowBatchResponseVO> convertListToWorkflowBatchList(List<WorkflowBatchResponseDO> workflowBatchResponseList) {
        if (workflowBatchResponseList == null) {
            return null;
        }
        ArrayList<WorkflowBatchResponseVO> list = new ArrayList<WorkflowBatchResponseVO>(workflowBatchResponseList.size());
        for (WorkflowBatchResponseDO workflowBatchResponseDO : workflowBatchResponseList) {
            list.add(this.workflowBatchResponseDOToWorkflowBatchResponseVO(workflowBatchResponseDO));
        }
        return list;
    }

    @Override
    public WorkflowBatchResponseVO convert(WorkflowTaskBatch workflowTaskBatch, Workflow workflow) {
        if (workflowTaskBatch == null && workflow == null) {
            return null;
        }
        WorkflowBatchResponseVO workflowBatchResponseVO = new WorkflowBatchResponseVO();
        if (workflowTaskBatch != null) {
            workflowBatchResponseVO.setGroupName(workflowTaskBatch.getGroupName());
            workflowBatchResponseVO.setId(workflowTaskBatch.getId());
            workflowBatchResponseVO.setCreateDt(workflowTaskBatch.getCreateDt());
            workflowBatchResponseVO.setWorkflowId(workflowTaskBatch.getWorkflowId());
            workflowBatchResponseVO.setTaskBatchStatus(workflowTaskBatch.getTaskBatchStatus());
            workflowBatchResponseVO.setOperationReason(workflowTaskBatch.getOperationReason());
        }
        if (workflow != null) {
            workflowBatchResponseVO.setWorkflowName(workflow.getWorkflowName());
        }
        workflowBatchResponseVO.setExecutionAt(WorkflowConverter.toLocalDateTime(workflowTaskBatch.getExecutionAt()));
        return workflowBatchResponseVO;
    }

    protected WorkflowBatchResponseVO workflowBatchResponseDOToWorkflowBatchResponseVO(WorkflowBatchResponseDO workflowBatchResponseDO) {
        if (workflowBatchResponseDO == null) {
            return null;
        }
        WorkflowBatchResponseVO workflowBatchResponseVO = new WorkflowBatchResponseVO();
        workflowBatchResponseVO.setId(workflowBatchResponseDO.getId());
        workflowBatchResponseVO.setGroupName(workflowBatchResponseDO.getGroupName());
        workflowBatchResponseVO.setWorkflowId(workflowBatchResponseDO.getWorkflowId());
        workflowBatchResponseVO.setWorkflowName(workflowBatchResponseDO.getWorkflowName());
        workflowBatchResponseVO.setTaskBatchStatus(workflowBatchResponseDO.getTaskBatchStatus());
        workflowBatchResponseVO.setOperationReason(workflowBatchResponseDO.getOperationReason());
        workflowBatchResponseVO.setExecutionAt(WorkflowConverter.toLocalDateTime(workflowBatchResponseDO.getExecutionAt()));
        workflowBatchResponseVO.setCreateDt(workflowBatchResponseDO.getCreateDt());
        return workflowBatchResponseVO;
    }
}

