/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.request;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.net.url.UrlQuery;
import com.aizuda.snailjob.common.core.enums.RetryOperationReasonEnum;
import com.aizuda.snailjob.common.core.enums.RetryTaskStatusEnum;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.model.SnailJobRequest;
import com.aizuda.snailjob.common.core.model.SnailJobRpcResult;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.model.request.DispatchRetryResultRequest;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.handler.PostHttpRequestHandler;
import com.aizuda.snailjob.server.common.pekko.ActorGenerator;
import com.aizuda.snailjob.server.retry.task.dto.RetryExecutorResultDTO;
import com.aizuda.snailjob.server.retry.task.support.RetryTaskConverter;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import lombok.Generated;
import org.apache.pekko.actor.ActorRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ReportDispatchResultHttpRequestHandler
extends PostHttpRequestHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReportDispatchResultHttpRequestHandler.class);

    public boolean supports(String path) {
        return "/report/retry/dispatch/result".equals(path);
    }

    public HttpMethod method() {
        return HttpMethod.POST;
    }

    @Transactional
    public SnailJobRpcResult doHandler(String content, UrlQuery urlQuery, HttpHeaders headers) {
        SnailJobRequest retryRequest = (SnailJobRequest)JsonUtil.parseObject((String)content, SnailJobRequest.class);
        Object[] args = retryRequest.getArgs();
        try {
            DispatchRetryResultRequest request = (DispatchRetryResultRequest)JsonUtil.parseObject((String)JsonUtil.toJsonString((Object)args[0]), DispatchRetryResultRequest.class);
            RetryExecutorResultDTO executorResultDTO = RetryTaskConverter.INSTANCE.toRetryExecutorResultDTO(request);
            RetryTaskStatusEnum statusEnum = RetryTaskStatusEnum.getByStatus((Integer)request.getTaskStatus());
            Assert.notNull((Object)statusEnum, () -> new SnailJobServerException("task status code is invalid"));
            executorResultDTO.setIncrementRetryCount(true);
            if (RetryTaskStatusEnum.FAIL.getStatus().equals(statusEnum.getStatus())) {
                executorResultDTO.setOperationReason(RetryOperationReasonEnum.RETRY_FAIL.getReason());
            } else if (RetryTaskStatusEnum.STOP.getStatus().equals(statusEnum.getStatus())) {
                executorResultDTO.setOperationReason(RetryOperationReasonEnum.CLIENT_TRIGGER_RETRY_STOP.getReason());
            }
            ActorRef actorRef = ActorGenerator.retryTaskExecutorResultActor();
            actorRef.tell((Object)executorResultDTO, actorRef);
            return new SnailJobRpcResult(StatusEnum.YES.getStatus().intValue(), "Report dispatch result processed successfully", (Object)Boolean.TRUE, retryRequest.getReqId());
        }
        catch (Exception e) {
            return new SnailJobRpcResult(StatusEnum.YES.getStatus().intValue(), e.getMessage(), (Object)Boolean.FALSE, retryRequest.getReqId());
        }
    }

    @Generated
    public ReportDispatchResultHttpRequestHandler() {
    }
}

