/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.dispatch;

import com.aizuda.snailjob.common.core.enums.RetryTaskStatusEnum;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.model.Result;
import com.aizuda.snailjob.common.core.model.SnailJobHeaders;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.model.request.DispatchRetryRequest;
import com.aizuda.snailjob.server.common.dto.InstanceKey;
import com.aizuda.snailjob.server.common.dto.InstanceLiveInfo;
import com.aizuda.snailjob.server.common.dto.RegisterNodeInfo;
import com.aizuda.snailjob.server.common.dto.RetryLogMetaDTO;
import com.aizuda.snailjob.server.common.handler.InstanceManager;
import com.aizuda.snailjob.server.common.pekko.ActorGenerator;
import com.aizuda.snailjob.server.common.rpc.client.RequestBuilder;
import com.aizuda.snailjob.server.common.rpc.client.SnailJobRetryListener;
import com.aizuda.snailjob.server.common.util.ClientInfoUtils;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.server.retry.task.client.RetryRpcClient;
import com.aizuda.snailjob.server.retry.task.dto.RequestRetryExecutorDTO;
import com.aizuda.snailjob.server.retry.task.dto.RetryExecutorResultDTO;
import com.aizuda.snailjob.server.retry.task.support.RetryTaskConverter;
import com.aizuda.snailjob.server.retry.task.support.RetryTaskLogConverter;
import com.aizuda.snailjob.template.datasource.persistence.mapper.RetryTaskMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTask;
import com.github.rholder.retry.Attempt;
import com.github.rholder.retry.RetryException;
import com.google.common.collect.Maps;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.pekko.actor.AbstractActor;
import org.apache.pekko.actor.ActorRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="RealRetryExecutorActor")
@Scope(value="prototype")
public class RequestRetryClientActor
extends AbstractActor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RequestRetryClientActor.class);
    private final RetryTaskMapper retryTaskMapper;
    private final InstanceManager instanceManager;

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(RequestRetryExecutorDTO.class, realRetryExecutorDTO -> {
            try {
                this.doExecute((RequestRetryExecutorDTO)realRetryExecutorDTO);
            }
            catch (Exception e) {
                log.error("Client request exception occurred", (Throwable)e);
            }
            finally {
                this.getContext().stop(this.getSelf());
            }
        }).build();
    }

    private void doExecute(RequestRetryExecutorDTO executorDTO) {
        long nowMilli = DateUtils.toNowMilli();
        InstanceLiveInfo instanceLiveInfo = this.instanceManager.getInstanceALiveInfoSet(InstanceKey.builder().namespaceId(executorDTO.getNamespaceId()).groupName(executorDTO.getGroupName()).hostId(executorDTO.getClientId()).build());
        if (Objects.isNull(instanceLiveInfo)) {
            RequestRetryClientActor.taskExecuteFailure(executorDTO, "Client does not exist");
            RetryLogMetaDTO retryTaskLogDTO = RetryTaskLogConverter.INSTANCE.toRetryLogMetaDTO(executorDTO);
            retryTaskLogDTO.setTimestamp(Long.valueOf(nowMilli));
            SnailJobLog.REMOTE.error("RetryTaskId:[{}] Task scheduling failed. Reason: No executable client <|>{}<|>", new Object[]{executorDTO.getRetryTaskId(), retryTaskLogDTO});
            return;
        }
        DispatchRetryRequest dispatchJobRequest = RetryTaskConverter.INSTANCE.toDispatchRetryRequest(executorDTO);
        try {
            SnailJobHeaders snailJobHeaders = new SnailJobHeaders();
            snailJobHeaders.setRetry(Boolean.TRUE.booleanValue());
            snailJobHeaders.setRetryId(String.valueOf(executorDTO.getRetryId()));
            snailJobHeaders.setDdl((long)executorDTO.getExecutorTimeout().intValue());
            RetryRpcClient rpcClient = this.buildRpcClient(instanceLiveInfo, executorDTO);
            Result<Boolean> dispatch = rpcClient.dispatch(dispatchJobRequest, snailJobHeaders);
            Boolean data = (Boolean)dispatch.getData();
            if (dispatch.getStatus() == StatusEnum.YES.getStatus().intValue() && Objects.nonNull(data) && data.booleanValue()) {
                SnailJobLog.LOCAL.info("RetryTaskId:[{}] Task scheduled successfully.", new Object[]{executorDTO.getRetryTaskId()});
            } else {
                SnailJobLog.LOCAL.error("RetryTaskId:[{}] Task scheduling failed. Msg:[{}]", new Object[]{executorDTO.getRetryTaskId(), dispatch.getMessage()});
                RequestRetryClientActor.taskExecuteFailure(executorDTO, dispatch.getMessage());
            }
        }
        catch (Exception e) {
            Throwable throwable;
            if (e.getClass().isAssignableFrom(RetryException.class)) {
                re = (RetryException)e;
                throwable = re.getLastFailedAttempt().getExceptionCause();
            } else if (e.getClass().isAssignableFrom(UndeclaredThrowableException.class)) {
                re = (UndeclaredThrowableException)e;
                throwable = ((UndeclaredThrowableException)re).getUndeclaredThrowable();
            } else {
                throwable = e;
            }
            RetryLogMetaDTO retryTaskLogDTO = RetryTaskLogConverter.INSTANCE.toRetryLogMetaDTO(executorDTO);
            retryTaskLogDTO.setTimestamp(Long.valueOf(nowMilli));
            SnailJobLog.REMOTE.error("RetryTaskId:[{}] Task scheduling failed. <|>{}<|>", new Object[]{retryTaskLogDTO.getRetryTaskId(), retryTaskLogDTO, throwable});
            RequestRetryClientActor.taskExecuteFailure(executorDTO, throwable.getMessage());
        }
    }

    private RetryRpcClient buildRpcClient(InstanceLiveInfo instanceLiveInfo, RequestRetryExecutorDTO executorDTO) {
        return (RetryRpcClient)RequestBuilder.newBuilder().nodeInfo(instanceLiveInfo).failRetry(true).failover(true).retryTimes(3).retryInterval(1).routeKey(executorDTO.getRouteKey().intValue()).allocKey(String.valueOf(executorDTO.getRetryTaskId())).retryListener((SnailJobRetryListener)new RetryExecutorRetryListener(executorDTO)).client(RetryRpcClient.class).targetLabels(executorDTO.getLabels()).build();
    }

    private static void taskExecuteFailure(RequestRetryExecutorDTO executorDTO, String message) {
        ActorRef actorRef = ActorGenerator.retryTaskExecutorResultActor();
        RetryExecutorResultDTO executorResultDTO = RetryTaskConverter.INSTANCE.toRetryExecutorResultDTO(executorDTO);
        executorResultDTO.setExceptionMsg(message);
        executorResultDTO.setTaskStatus(RetryTaskStatusEnum.FAIL.getStatus());
        actorRef.tell((Object)executorResultDTO, actorRef);
    }

    @Generated
    public RequestRetryClientActor(RetryTaskMapper retryTaskMapper, InstanceManager instanceManager) {
        this.retryTaskMapper = retryTaskMapper;
        this.instanceManager = instanceManager;
    }

    public class RetryExecutorRetryListener
    implements SnailJobRetryListener {
        private final Map<String, Object> properties;
        private final RequestRetryExecutorDTO executorDTO;

        public RetryExecutorRetryListener(RequestRetryExecutorDTO realJobExecutorDTO) {
            this.executorDTO = realJobExecutorDTO;
            this.properties = Maps.newHashMap();
        }

        public <V> void onRetry(Attempt<V> attempt) {
            Map<String, Object> properties;
            InstanceLiveInfo instanceLiveInfo;
            if (attempt.hasException()) {
                RetryLogMetaDTO retryTaskLogDTO = RetryTaskLogConverter.INSTANCE.toRetryLogMetaDTO(this.executorDTO);
                retryTaskLogDTO.setTimestamp(Long.valueOf(DateUtils.toNowMilli()));
                SnailJobLog.REMOTE.error("Task scheduling failed attempt retry. Task instance ID:[{}] retryCount:[{}]. <|>{}<|>", new Object[]{this.executorDTO.getRetryTaskId(), attempt.getAttemptNumber(), retryTaskLogDTO, attempt.getExceptionCause()});
                return;
            }
            if (attempt.hasResult() && attempt.getAttemptNumber() > 1L && Objects.nonNull(instanceLiveInfo = (InstanceLiveInfo)(properties = this.properties()).get("newInstanceLiveInfo"))) {
                RegisterNodeInfo nodeInfo = instanceLiveInfo.getNodeInfo();
                RetryTask retryTask = new RetryTask();
                retryTask.setId(this.executorDTO.getRetryTaskId());
                RegisterNodeInfo realNodeInfo = new RegisterNodeInfo();
                realNodeInfo.setHostIp(nodeInfo.getHostIp());
                realNodeInfo.setHostPort(nodeInfo.getHostPort());
                realNodeInfo.setHostId(nodeInfo.getHostId());
                retryTask.setClientInfo(ClientInfoUtils.generate((RegisterNodeInfo)realNodeInfo));
                RequestRetryClientActor.this.retryTaskMapper.updateById((Object)retryTask);
            }
        }

        public Map<String, Object> properties() {
            return this.properties;
        }
    }
}

