/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.dispatch;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.log.dto.TaskLogFieldDTO;
import com.aizuda.snailjob.model.request.RetryLogTaskRequest;
import com.aizuda.snailjob.server.retry.task.dto.RetryTaskLogDTO;
import com.aizuda.snailjob.server.retry.task.support.RetryTaskConverter;
import com.aizuda.snailjob.template.datasource.access.AccessTemplate;
import com.aizuda.snailjob.template.datasource.persistence.dataobject.log.RetryTaskLogMessageDO;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.pekko.actor.AbstractActor;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="RetryLogActor")
@Scope(value="prototype")
public class RetryLogActor
extends AbstractActor {
    private final AccessTemplate accessTemplate;

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(List.class, list -> {
            if (CollUtil.isEmpty((Collection)list)) {
                return;
            }
            this.saveRetryTaskLogMessage((List<RetryLogTaskRequest>)list);
            this.getContext().stop(this.getSelf());
        }).match(RetryTaskLogDTO.class, retryTaskLogDTO -> {
            this.saveRetryTaskLogMessage((RetryTaskLogDTO)retryTaskLogDTO);
            this.getContext().stop(this.getSelf());
        }).build();
    }

    private void saveRetryTaskLogMessage(List<RetryLogTaskRequest> list) {
        List<RetryLogTaskRequest> jobLogTasks = list;
        Map logTaskDTOMap = jobLogTasks.stream().collect(Collectors.groupingBy(RetryLogTaskRequest::getRetryTaskId, Collectors.toList()));
        ArrayList<RetryTaskLogMessageDO> retryTaskLogMessages = new ArrayList<RetryTaskLogMessageDO>();
        for (List logTaskDTOList : logTaskDTOMap.values()) {
            RetryTaskLogMessageDO retryTaskLogMessage = RetryTaskConverter.INSTANCE.toRetryTaskLogMessage((RetryLogTaskRequest)logTaskDTOList.get(0));
            retryTaskLogMessage.setCreateDt(LocalDateTime.now());
            retryTaskLogMessage.setLogNum(Integer.valueOf(logTaskDTOList.size()));
            List messageMapList = logTaskDTOList.stream().map(taskDTO -> taskDTO.getFieldList().stream().filter(logTaskDTO_ -> !Objects.isNull(logTaskDTO_.getValue())).collect(Collectors.toMap(TaskLogFieldDTO::getName, TaskLogFieldDTO::getValue))).collect(Collectors.toList());
            retryTaskLogMessage.setMessage(JsonUtil.toJsonString(messageMapList));
            retryTaskLogMessages.add(retryTaskLogMessage);
        }
        this.accessTemplate.getRetryTaskLogMessageAccess().insertBatch(retryTaskLogMessages);
    }

    private void saveRetryTaskLogMessage(RetryTaskLogDTO retryTaskLogDTO) {
        RetryTaskLogMessageDO retryTaskLogMessage = new RetryTaskLogMessageDO();
        retryTaskLogMessage.setRetryId(retryTaskLogDTO.getRetryId());
        retryTaskLogMessage.setRetryTaskId(retryTaskLogDTO.getRetryTaskId());
        retryTaskLogMessage.setGroupName(retryTaskLogDTO.getGroupName());
        retryTaskLogMessage.setNamespaceId(retryTaskLogDTO.getNamespaceId());
        retryTaskLogMessage.setLogNum(Integer.valueOf(1));
        retryTaskLogMessage.setRealTime(retryTaskLogDTO.getRealTime());
        String errorMessage = retryTaskLogDTO.getMessage();
        retryTaskLogMessage.setMessage(StrUtil.isBlank((CharSequence)errorMessage) ? "" : errorMessage);
        retryTaskLogMessage.setCreateDt(Optional.ofNullable(retryTaskLogDTO.getTriggerTime()).orElse(LocalDateTime.now()));
        this.accessTemplate.getRetryTaskLogMessageAccess().insert((Object)retryTaskLogMessage);
    }

    @Generated
    public RetryLogActor(AccessTemplate accessTemplate) {
        this.accessTemplate = accessTemplate;
    }
}

