/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.dispatch;

import com.aizuda.snailjob.client.model.request.StopRetryRequest;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.model.Result;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.dto.InstanceKey;
import com.aizuda.snailjob.server.common.dto.InstanceLiveInfo;
import com.aizuda.snailjob.server.common.handler.InstanceManager;
import com.aizuda.snailjob.server.common.rpc.client.RequestBuilder;
import com.aizuda.snailjob.server.retry.task.client.RetryRpcClient;
import com.aizuda.snailjob.server.retry.task.dto.RequestStopRetryTaskExecutorDTO;
import com.aizuda.snailjob.server.retry.task.support.RetryTaskConverter;
import java.util.Objects;
import lombok.Generated;
import org.apache.pekko.actor.AbstractActor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="RetryRealStopTaskInstanceActor")
@Scope(value="prototype")
public class RequestStopClientActor
extends AbstractActor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RequestStopClientActor.class);
    private final InstanceManager instanceManager;

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(RequestStopRetryTaskExecutorDTO.class, taskExecutorDTO -> {
            try {
                this.doStop((RequestStopRetryTaskExecutorDTO)taskExecutorDTO);
            }
            catch (Exception e) {
                log.error("Client request exception occurred", (Throwable)e);
            }
        }).build();
    }

    private void doStop(RequestStopRetryTaskExecutorDTO executorDTO) {
        InstanceLiveInfo instanceLiveInfo = this.instanceManager.getInstanceALiveInfoSet(InstanceKey.builder().namespaceId(executorDTO.getNamespaceId()).groupName(executorDTO.getGroupName()).hostId(executorDTO.getClientId()).build());
        if (Objects.isNull(instanceLiveInfo)) {
            return;
        }
        StopRetryRequest stopRetryRequest = RetryTaskConverter.INSTANCE.toStopRetryRequest(executorDTO);
        try {
            RetryRpcClient rpcClient = this.buildRpcClient(instanceLiveInfo);
            Result<Boolean> dispatch = rpcClient.stop(stopRetryRequest);
            if (dispatch.getStatus() == StatusEnum.YES.getStatus().intValue()) {
                SnailJobLog.LOCAL.info("RetryTaskId:[{}] Task stopped successfully.", new Object[]{executorDTO.getRetryTaskId()});
            } else {
                SnailJobLog.LOCAL.warn("RetryTaskId:[{}] Task stop failed.", new Object[]{executorDTO.getRetryTaskId()});
            }
        }
        catch (Exception e) {
            SnailJobLog.LOCAL.error("RetryTaskId:[{}] Task stop failed.", new Object[]{executorDTO.getRetryTaskId(), e});
        }
    }

    private RetryRpcClient buildRpcClient(InstanceLiveInfo instanceLiveInfo) {
        return (RetryRpcClient)RequestBuilder.newBuilder().nodeInfo(instanceLiveInfo).failRetry(true).retryTimes(3).retryInterval(1).client(RetryRpcClient.class).build();
    }

    @Generated
    public RequestStopClientActor(InstanceManager instanceManager) {
        this.instanceManager = instanceManager;
    }
}

