/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.dispatch;

import com.aizuda.snailjob.client.model.request.RetryCallbackRequest;
import com.aizuda.snailjob.common.core.enums.RetryTaskStatusEnum;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.model.Result;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.dto.InstanceKey;
import com.aizuda.snailjob.server.common.dto.InstanceLiveInfo;
import com.aizuda.snailjob.server.common.dto.JobLogMetaDTO;
import com.aizuda.snailjob.server.common.dto.RegisterNodeInfo;
import com.aizuda.snailjob.server.common.dto.RetryLogMetaDTO;
import com.aizuda.snailjob.server.common.handler.InstanceManager;
import com.aizuda.snailjob.server.common.pekko.ActorGenerator;
import com.aizuda.snailjob.server.common.rpc.client.RequestBuilder;
import com.aizuda.snailjob.server.common.rpc.client.SnailJobRetryListener;
import com.aizuda.snailjob.server.common.util.ClientInfoUtils;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.server.retry.task.client.RetryRpcClient;
import com.aizuda.snailjob.server.retry.task.dto.RequestCallbackExecutorDTO;
import com.aizuda.snailjob.server.retry.task.dto.RetryExecutorResultDTO;
import com.aizuda.snailjob.server.retry.task.support.RetryTaskConverter;
import com.aizuda.snailjob.server.retry.task.support.RetryTaskLogConverter;
import com.aizuda.snailjob.template.datasource.persistence.mapper.RetryMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.RetryTaskMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.Retry;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTask;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.github.rholder.retry.Attempt;
import com.github.rholder.retry.RetryException;
import com.google.common.collect.Maps;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.pekko.actor.AbstractActor;
import org.apache.pekko.actor.ActorRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="RealCallbackExecutorActor")
@Scope(value="prototype")
public class RequestCallbackClientActor
extends AbstractActor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RequestCallbackClientActor.class);
    private final RetryTaskMapper retryTaskMapper;
    private final RetryMapper retryMapper;
    private final InstanceManager instanceManager;

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(RequestCallbackExecutorDTO.class, executorDTO -> {
            try {
                this.doCallback((RequestCallbackExecutorDTO)executorDTO);
            }
            catch (Exception e) {
                log.error("Client request exception occurred", (Throwable)e);
            }
        }).build();
    }

    private void doCallback(RequestCallbackExecutorDTO executorDTO) {
        long nowMilli = DateUtils.toNowMilli();
        InstanceLiveInfo instanceLiveInfo = this.instanceManager.getInstanceALiveInfoSet(InstanceKey.builder().namespaceId(executorDTO.getNamespaceId()).groupName(executorDTO.getGroupName()).hostId(executorDTO.getClientId()).build());
        if (Objects.isNull(instanceLiveInfo)) {
            RequestCallbackClientActor.taskExecuteFailure(executorDTO, "Client does not exist");
            JobLogMetaDTO jobLogMetaDTO = RetryTaskConverter.INSTANCE.toJobLogDTO(executorDTO);
            jobLogMetaDTO.setTimestamp(Long.valueOf(nowMilli));
            SnailJobLog.REMOTE.error("RetryTaskId:[{}] Task scheduling failed. Reason: No executable client <|>{}<|>", new Object[]{executorDTO.getRetryTaskId(), jobLogMetaDTO});
            return;
        }
        RetryCallbackRequest retryCallbackRequest = RetryTaskConverter.INSTANCE.toRetryCallbackDTO(executorDTO);
        Retry retry = (Retry)this.retryMapper.selectOne((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{Retry::getRetryStatus, Retry::getId}).eq(Retry::getId, (Object)executorDTO.getParentId()));
        if (Objects.isNull(retry)) {
            JobLogMetaDTO jobLogMetaDTO = RetryTaskConverter.INSTANCE.toJobLogDTO(executorDTO);
            jobLogMetaDTO.setTimestamp(Long.valueOf(nowMilli));
            SnailJobLog.REMOTE.error("RetryTaskId:[{}] Task scheduling failed. Reason: Retry task does not exist <|>{}<|>", new Object[]{executorDTO.getRetryTaskId(), jobLogMetaDTO});
            return;
        }
        retryCallbackRequest.setRetryStatus(retry.getRetryStatus());
        try {
            RetryRpcClient rpcClient = this.buildRpcClient(instanceLiveInfo, executorDTO);
            Result<Boolean> dispatch = rpcClient.callback(retryCallbackRequest);
            if (dispatch.getStatus() == StatusEnum.YES.getStatus().intValue()) {
                SnailJobLog.LOCAL.info("RetryTaskId:[{}] Task scheduled successfully.", new Object[]{executorDTO.getRetryTaskId()});
            } else {
                SnailJobLog.LOCAL.error("RetryTaskId:[{}] Task scheduling failed. Msg:[{}]", new Object[]{executorDTO.getRetryTaskId(), dispatch.getMessage()});
                RequestCallbackClientActor.taskExecuteFailure(executorDTO, dispatch.getMessage());
            }
        }
        catch (Exception e) {
            Throwable throwable;
            if (e.getClass().isAssignableFrom(RetryException.class)) {
                re = (RetryException)e;
                throwable = re.getLastFailedAttempt().getExceptionCause();
            } else if (e.getClass().isAssignableFrom(UndeclaredThrowableException.class)) {
                re = (UndeclaredThrowableException)e;
                throwable = ((UndeclaredThrowableException)re).getUndeclaredThrowable();
            } else {
                throwable = e;
            }
            RetryLogMetaDTO retryTaskLogDTO = RetryTaskLogConverter.INSTANCE.toRetryLogMetaDTO(executorDTO);
            retryTaskLogDTO.setTimestamp(Long.valueOf(nowMilli));
            SnailJobLog.REMOTE.error("RetryTaskId:[{}] Task scheduling failed. <|>{}<|>", new Object[]{retryTaskLogDTO.getRetryTaskId(), retryTaskLogDTO, throwable});
            RequestCallbackClientActor.taskExecuteFailure(executorDTO, throwable.getMessage());
        }
    }

    private RetryRpcClient buildRpcClient(InstanceLiveInfo instanceLiveInfo, RequestCallbackExecutorDTO executorDTO) {
        return (RetryRpcClient)RequestBuilder.newBuilder().nodeInfo(instanceLiveInfo).failRetry(true).failover(true).retryTimes(3).retryInterval(1).routeKey(executorDTO.getRouteKey().intValue()).allocKey(String.valueOf(executorDTO.getRetryTaskId())).retryListener((SnailJobRetryListener)new RetryExecutorRetryListener(executorDTO)).client(RetryRpcClient.class).targetLabels(executorDTO.getLabels()).build();
    }

    private static void taskExecuteFailure(RequestCallbackExecutorDTO executorDTO, String message) {
        ActorRef actorRef = ActorGenerator.retryTaskExecutorResultActor();
        RetryExecutorResultDTO executorResultDTO = RetryTaskConverter.INSTANCE.toRetryExecutorResultDTO(executorDTO);
        executorResultDTO.setExceptionMsg(message);
        executorResultDTO.setTaskStatus(RetryTaskStatusEnum.FAIL.getStatus());
        actorRef.tell((Object)executorResultDTO, actorRef);
    }

    @Generated
    public RequestCallbackClientActor(RetryTaskMapper retryTaskMapper, RetryMapper retryMapper, InstanceManager instanceManager) {
        this.retryTaskMapper = retryTaskMapper;
        this.retryMapper = retryMapper;
        this.instanceManager = instanceManager;
    }

    public class RetryExecutorRetryListener
    implements SnailJobRetryListener {
        private final Map<String, Object> properties;
        private final RequestCallbackExecutorDTO executorDTO;

        public RetryExecutorRetryListener(RequestCallbackExecutorDTO executorDTO) {
            this.executorDTO = executorDTO;
            this.properties = Maps.newHashMap();
        }

        public <V> void onRetry(Attempt<V> attempt) {
            Map<String, Object> properties;
            InstanceLiveInfo instanceLiveInfo;
            if (attempt.hasException()) {
                JobLogMetaDTO jobLogMetaDTO = RetryTaskConverter.INSTANCE.toJobLogDTO(this.executorDTO);
                jobLogMetaDTO.setTimestamp(Long.valueOf(DateUtils.toNowMilli()));
                SnailJobLog.REMOTE.error("Task scheduling failed attempt retry. Task instance ID:[{}] retryCount:[{}]. <|>{}<|>", new Object[]{this.executorDTO.getRetryTaskId(), attempt.getAttemptNumber(), jobLogMetaDTO, attempt.getExceptionCause()});
                return;
            }
            if (attempt.hasResult() && attempt.getAttemptNumber() > 1L && Objects.nonNull(instanceLiveInfo = (InstanceLiveInfo)(properties = this.properties()).get("newInstanceLiveInfo"))) {
                RegisterNodeInfo nodeInfo = instanceLiveInfo.getNodeInfo();
                RetryTask retryTask = new RetryTask();
                retryTask.setId(this.executorDTO.getRetryTaskId());
                RegisterNodeInfo realNodeInfo = new RegisterNodeInfo();
                realNodeInfo.setHostIp(nodeInfo.getHostIp());
                realNodeInfo.setHostPort(nodeInfo.getHostPort());
                realNodeInfo.setHostId(nodeInfo.getHostId());
                retryTask.setClientInfo(ClientInfoUtils.generate((RegisterNodeInfo)realNodeInfo));
                RequestCallbackClientActor.this.retryTaskMapper.updateById((Object)retryTask);
            }
        }

        public Map<String, Object> properties() {
            return this.properties;
        }
    }
}

