/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.generator.retry;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Pair;
import cn.hutool.core.util.HashUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.core.enums.RetryStatusEnum;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.WaitStrategy;
import com.aizuda.snailjob.server.common.config.SystemProperties;
import com.aizuda.snailjob.server.common.enums.DelayLevelEnum;
import com.aizuda.snailjob.server.common.enums.SyetemTaskTypeEnum;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.strategy.WaitStrategies;
import com.aizuda.snailjob.server.retry.task.support.RetryTaskConverter;
import com.aizuda.snailjob.server.retry.task.support.RetryTaskLogConverter;
import com.aizuda.snailjob.server.retry.task.support.generator.retry.TaskContext;
import com.aizuda.snailjob.server.retry.task.support.generator.retry.TaskGenerator;
import com.aizuda.snailjob.template.datasource.access.AccessTemplate;
import com.aizuda.snailjob.template.datasource.access.TaskAccess;
import com.aizuda.snailjob.template.datasource.persistence.po.Retry;
import com.aizuda.snailjob.template.datasource.persistence.po.RetrySceneConfig;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTask;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractGenerator
implements TaskGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractGenerator.class);
    @Autowired
    protected AccessTemplate accessTemplate;
    @Autowired
    private SystemProperties systemProperties;

    @Override
    public void taskGenerator(TaskContext taskContext) {
        SnailJobLog.LOCAL.debug("received report data. {}", new Object[]{JsonUtil.toJsonString((Object)taskContext)});
        RetrySceneConfig retrySceneConfig = this.checkAndInitScene(taskContext);
        List taskInfos = taskContext.getTaskInfos().stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<TaskContext.TaskInfo>(Comparator.comparing(TaskContext.TaskInfo::getIdempotentId))), ArrayList::new));
        Set idempotentIdSet = StreamUtils.toSet((Collection)taskInfos, TaskContext.TaskInfo::getIdempotentId);
        TaskAccess retryTaskAccess = this.accessTemplate.getRetryAccess();
        List retries = retryTaskAccess.list((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Retry::getNamespaceId, (Object)taskContext.getNamespaceId())).eq(Retry::getGroupName, (Object)taskContext.getGroupName())).eq(Retry::getSceneName, (Object)taskContext.getSceneName())).eq(Retry::getRetryStatus, (Object)RetryStatusEnum.RUNNING.getStatus())).eq(Retry::getTaskType, (Object)SyetemTaskTypeEnum.RETRY.getType())).in(Retry::getIdempotentId, (Collection)idempotentIdSet));
        Map retryTaskMap = StreamUtils.groupByKey((Collection)retries, Retry::getIdempotentId);
        ArrayList waitInsertTasks = new ArrayList();
        LocalDateTime now = LocalDateTime.now();
        for (TaskContext.TaskInfo taskInfo : taskInfos) {
            Pair<List<Retry>, List<RetryTask>> pair = this.doConvertTask(retryTaskMap, taskContext, now, taskInfo, retrySceneConfig);
            waitInsertTasks.addAll((Collection)pair.getKey());
        }
        if (CollUtil.isEmpty(waitInsertTasks)) {
            return;
        }
        Assert.isTrue((waitInsertTasks.size() == retryTaskAccess.insertBatch(waitInsertTasks) ? 1 : 0) != 0, () -> new SnailJobServerException("failed to report data"));
    }

    private Pair<List<Retry>, List<RetryTask>> doConvertTask(Map<String, List<Retry>> retryTaskMap, TaskContext taskContext, LocalDateTime now, TaskContext.TaskInfo taskInfo, RetrySceneConfig retrySceneConfig) {
        ArrayList<Retry> waitInsertRetryList = new ArrayList<Retry>();
        ArrayList<RetryTask> waitInsertTaskList = new ArrayList<RetryTask>();
        List list = ((List)retryTaskMap.getOrDefault(taskInfo.getIdempotentId(), new ArrayList())).stream().filter(retryTask -> taskContext.getGroupName().equals(retryTask.getGroupName()) && taskContext.getNamespaceId().equals(retryTask.getNamespaceId()) && taskContext.getSceneName().equals(retryTask.getSceneName())).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(list)) {
            SnailJobLog.LOCAL.warn("interrupted reporting in retrying task. [{}]", new Object[]{JsonUtil.toJsonString((Object)taskInfo)});
            return Pair.of(waitInsertRetryList, waitInsertTaskList);
        }
        Retry retry = RetryTaskConverter.INSTANCE.toRetryTask(taskInfo);
        retry.setNamespaceId(taskContext.getNamespaceId());
        retry.setTaskType(SyetemTaskTypeEnum.RETRY.getType());
        retry.setGroupName(taskContext.getGroupName());
        retry.setSceneName(taskContext.getSceneName());
        retry.setRetryStatus(this.initStatus(taskContext));
        retry.setSceneId(taskContext.getSceneId());
        retry.setGroupId(taskContext.getGroupId());
        retry.setParentId(Long.valueOf(0L));
        retry.setDeleted(Long.valueOf(0L));
        if (StrUtil.isBlank((CharSequence)retry.getBizNo())) {
            retry.setBizNo(IdUtil.fastSimpleUUID());
        } else {
            retry.setBizNo(retry.getBizNo());
        }
        retry.setBucketIndex(Integer.valueOf(HashUtil.bkdrHash((String)(taskContext.getGroupName() + taskContext.getSceneName() + taskInfo.getIdempotentId())) % this.systemProperties.getBucketTotal()));
        retry.setCreateDt(now);
        retry.setUpdateDt(now);
        if (StrUtil.isBlank((CharSequence)retry.getExtAttrs())) {
            retry.setExtAttrs("");
        }
        WaitStrategies.WaitStrategyContext waitStrategyContext = new WaitStrategies.WaitStrategyContext();
        waitStrategyContext.setNextTriggerAt(now);
        waitStrategyContext.setTriggerInterval(retrySceneConfig.getTriggerInterval());
        waitStrategyContext.setDelayLevel(Integer.valueOf(1));
        WaitStrategy waitStrategy = WaitStrategies.WaitStrategyEnum.getWaitStrategy((int)retrySceneConfig.getBackOff());
        retry.setNextTriggerAt(waitStrategy.computeTriggerTime(waitStrategyContext));
        waitInsertRetryList.add(retry);
        RetryTask retryTask2 = RetryTaskLogConverter.INSTANCE.toRetryTask(retry);
        retryTask2.setTaskType(SyetemTaskTypeEnum.RETRY.getType());
        retryTask2.setCreateDt(now);
        waitInsertTaskList.add(retryTask2);
        return Pair.of(waitInsertRetryList, waitInsertTaskList);
    }

    protected abstract Integer initStatus(TaskContext var1);

    private RetrySceneConfig checkAndInitScene(TaskContext taskContext) {
        RetrySceneConfig retrySceneConfig = this.accessTemplate.getSceneConfigAccess().getSceneConfigByGroupNameAndSceneName(taskContext.getGroupName(), taskContext.getSceneName(), taskContext.getNamespaceId());
        if (Objects.isNull(retrySceneConfig)) {
            if (taskContext.getInitScene().equals(StatusEnum.NO.getStatus())) {
                throw new SnailJobServerException("failed to report data, no scene configuration found. groupName:[{}] sceneName:[{}]", new Object[]{taskContext.getGroupName(), taskContext.getSceneName()});
            }
            retrySceneConfig = this.initScene(taskContext.getGroupName(), taskContext.getSceneName(), taskContext.getNamespaceId());
        }
        taskContext.setSceneId(retrySceneConfig.getId());
        return retrySceneConfig;
    }

    private RetrySceneConfig initScene(String groupName, String sceneName, String namespaceId) {
        RetrySceneConfig retrySceneConfig = new RetrySceneConfig();
        retrySceneConfig.setNamespaceId(namespaceId);
        retrySceneConfig.setGroupName(groupName);
        retrySceneConfig.setSceneName(sceneName);
        retrySceneConfig.setSceneStatus(StatusEnum.YES.getStatus());
        retrySceneConfig.setBackOff(Integer.valueOf(WaitStrategies.WaitStrategyEnum.DELAY_LEVEL.getType()));
        retrySceneConfig.setMaxRetryCount(Integer.valueOf(DelayLevelEnum._21.getLevel()));
        retrySceneConfig.setCbStatus(StatusEnum.NO.getStatus());
        retrySceneConfig.setCbMaxCount(DelayLevelEnum._16.getLevel());
        retrySceneConfig.setDescription("Automatically initialize scenario");
        Assert.isTrue((1 == this.accessTemplate.getSceneConfigAccess().insert((Object)retrySceneConfig) ? 1 : 0) != 0, () -> new SnailJobServerException("init scene error"));
        return retrySceneConfig;
    }
}

