/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.result;

import cn.hutool.core.lang.Assert;
import com.aizuda.snailjob.common.core.enums.RetryStatusEnum;
import com.aizuda.snailjob.common.core.enums.RetryTaskStatusEnum;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.retry.task.support.handler.CallbackRetryTaskHandler;
import com.aizuda.snailjob.server.retry.task.support.result.AbstractRetryResultHandler;
import com.aizuda.snailjob.server.retry.task.support.result.RetryResultContext;
import com.aizuda.snailjob.template.datasource.access.AccessTemplate;
import com.aizuda.snailjob.template.datasource.persistence.mapper.RetryMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.RetryTaskMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.Retry;
import com.aizuda.snailjob.template.datasource.persistence.po.RetrySceneConfig;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTask;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Objects;
import lombok.Generated;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class RetrySuccessHandler
extends AbstractRetryResultHandler {
    private final TransactionTemplate transactionTemplate;
    private final AccessTemplate accessTemplate;
    private final CallbackRetryTaskHandler callbackRetryTaskHandler;
    private final RetryTaskMapper retryTaskMapper;
    private final RetryMapper retryMapper;

    @Override
    public boolean supports(RetryResultContext context) {
        return Objects.equals(RetryTaskStatusEnum.SUCCESS.getStatus(), context.getTaskStatus());
    }

    @Override
    public void doHandler(RetryResultContext context) {
        RetrySceneConfig retrySceneConfig = this.accessTemplate.getSceneConfigAccess().getSceneConfigByGroupNameAndSceneName(context.getGroupName(), context.getSceneName(), context.getNamespaceId());
        Retry retry = (Retry)this.retryMapper.selectById((Serializable)context.getRetryId());
        this.transactionTemplate.execute(status -> {
            retry.setRetryStatus(RetryStatusEnum.FINISH.getStatus());
            retry.setUpdateDt(LocalDateTime.now());
            retry.setRetryCount(Integer.valueOf(retry.getRetryCount() + 1));
            retry.setDeleted(retry.getId());
            Assert.isTrue((1 == this.retryMapper.updateById((Object)retry) ? 1 : 0) != 0, () -> new SnailJobServerException("\u66f4\u65b0\u91cd\u8bd5\u4efb\u52a1\u5931\u8d25. groupName:[{}]", new Object[]{retry.getGroupName()}));
            RetryTask retryTask = new RetryTask();
            retryTask.setId(context.getRetryTaskId());
            retryTask.setTaskStatus(RetryTaskStatusEnum.SUCCESS.getStatus());
            Assert.isTrue((1 == this.retryTaskMapper.updateById((Object)retryTask) ? 1 : 0) != 0, () -> new SnailJobServerException("\u66f4\u65b0\u91cd\u8bd5\u4efb\u52a1\u5931\u8d25. groupName:[{}]", new Object[]{retry.getGroupName()}));
            this.callbackRetryTaskHandler.create(retry, retrySceneConfig);
            return null;
        });
    }

    @Generated
    public RetrySuccessHandler(TransactionTemplate transactionTemplate, AccessTemplate accessTemplate, CallbackRetryTaskHandler callbackRetryTaskHandler, RetryTaskMapper retryTaskMapper, RetryMapper retryMapper) {
        this.transactionTemplate = transactionTemplate;
        this.accessTemplate = accessTemplate;
        this.callbackRetryTaskHandler = callbackRetryTaskHandler;
        this.retryTaskMapper = retryTaskMapper;
        this.retryMapper = retryMapper;
    }
}

