/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.result;

import cn.hutool.core.lang.Assert;
import com.aizuda.snailjob.common.core.enums.RetryOperationReasonEnum;
import com.aizuda.snailjob.common.core.enums.RetryStatusEnum;
import com.aizuda.snailjob.common.core.enums.RetryTaskStatusEnum;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.retry.task.support.result.AbstractRetryResultHandler;
import com.aizuda.snailjob.server.retry.task.support.result.RetryResultContext;
import com.aizuda.snailjob.template.datasource.persistence.mapper.RetryMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.RetryTaskMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.Retry;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTask;
import java.time.LocalDateTime;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class RetryStopHandler
extends AbstractRetryResultHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RetryStopHandler.class);
    private final TransactionTemplate transactionTemplate;
    private final RetryTaskMapper retryTaskMapper;
    private final RetryMapper retryMapper;

    @Override
    public boolean supports(RetryResultContext context) {
        RetryOperationReasonEnum reasonEnum = RetryOperationReasonEnum.of((Integer)context.getOperationReason());
        return RetryTaskStatusEnum.STOP.getStatus().equals(context.getTaskStatus()) && RetryOperationReasonEnum.CLIENT_TRIGGER_RETRY_STOP.getReason() == reasonEnum.getReason();
    }

    @Override
    public void doHandler(RetryResultContext context) {
        this.transactionTemplate.execute(status -> {
            Retry retry = new Retry();
            retry.setId(context.getRetryId());
            retry.setRetryStatus(RetryStatusEnum.SUSPEND.getStatus());
            retry.setUpdateDt(LocalDateTime.now());
            retry.setRetryCount(Integer.valueOf(retry.getRetryCount() + 1));
            Assert.isTrue((1 == this.retryMapper.updateById((Object)retry) ? 1 : 0) != 0, () -> new SnailJobServerException("\u66f4\u65b0\u91cd\u8bd5\u4efb\u52a1\u5931\u8d25. groupName:[{}]", new Object[]{retry.getGroupName()}));
            RetryTask retryTask = new RetryTask();
            retryTask.setId(context.getRetryTaskId());
            retryTask.setOperationReason(context.getOperationReason());
            retryTask.setTaskStatus(RetryTaskStatusEnum.STOP.getStatus());
            Assert.isTrue((1 == this.retryTaskMapper.updateById((Object)retryTask) ? 1 : 0) != 0, () -> new SnailJobServerException("\u66f4\u65b0\u91cd\u8bd5\u4efb\u52a1\u5931\u8d25. groupName:[{}]", new Object[]{retry.getGroupName()}));
            return null;
        });
    }

    @Generated
    public RetryStopHandler(TransactionTemplate transactionTemplate, RetryTaskMapper retryTaskMapper, RetryMapper retryMapper) {
        this.transactionTemplate = transactionTemplate;
        this.retryTaskMapper = retryTaskMapper;
        this.retryMapper = retryMapper;
    }
}

