/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.result;

import cn.hutool.core.lang.Assert;
import com.aizuda.snailjob.common.core.context.SnailSpringContext;
import com.aizuda.snailjob.common.core.enums.RetryNotifySceneEnum;
import com.aizuda.snailjob.common.core.enums.RetryOperationReasonEnum;
import com.aizuda.snailjob.common.core.enums.RetryStatusEnum;
import com.aizuda.snailjob.common.core.enums.RetryTaskStatusEnum;
import com.aizuda.snailjob.server.common.enums.SyetemTaskTypeEnum;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.retry.task.dto.RetryTaskFailAlarmEventDTO;
import com.aizuda.snailjob.server.retry.task.support.RetryTaskConverter;
import com.aizuda.snailjob.server.retry.task.support.event.RetryTaskFailAlarmEvent;
import com.aizuda.snailjob.server.retry.task.support.handler.CallbackRetryTaskHandler;
import com.aizuda.snailjob.server.retry.task.support.result.AbstractRetryResultHandler;
import com.aizuda.snailjob.server.retry.task.support.result.RetryResultContext;
import com.aizuda.snailjob.template.datasource.access.AccessTemplate;
import com.aizuda.snailjob.template.datasource.persistence.mapper.RetryMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.RetryTaskMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.Retry;
import com.aizuda.snailjob.template.datasource.persistence.po.RetrySceneConfig;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTask;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class RetryFailureHandler
extends AbstractRetryResultHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RetryFailureHandler.class);
    private final AccessTemplate accessTemplate;
    private final CallbackRetryTaskHandler callbackRetryTaskHandler;
    private final TransactionTemplate transactionTemplate;
    private final RetryTaskMapper retryTaskMapper;
    private final RetryMapper retryMapper;

    @Override
    public boolean supports(RetryResultContext context) {
        RetryOperationReasonEnum reasonEnum = RetryOperationReasonEnum.of((Integer)context.getOperationReason());
        return RetryTaskStatusEnum.NOT_SUCCESS.contains(context.getTaskStatus()) && RetryOperationReasonEnum.CLIENT_TRIGGER_RETRY_STOP.getReason() != reasonEnum.getReason();
    }

    @Override
    public void doHandler(RetryResultContext context) {
        RetrySceneConfig retrySceneConfig = this.accessTemplate.getSceneConfigAccess().getSceneConfigByGroupNameAndSceneName(context.getGroupName(), context.getSceneName(), context.getNamespaceId());
        Retry retry = (Retry)this.retryMapper.selectById((Serializable)context.getRetryId());
        this.transactionTemplate.execute(status -> {
            Integer maxRetryCount = SyetemTaskTypeEnum.CALLBACK.getType().equals(retry.getTaskType()) ? Integer.valueOf(retrySceneConfig.getCbMaxCount()) : retrySceneConfig.getMaxRetryCount();
            if (maxRetryCount <= retry.getRetryCount() + 1) {
                retry.setRetryStatus(RetryStatusEnum.MAX_COUNT.getStatus());
                retry.setRetryCount(Integer.valueOf(retry.getRetryCount() + 1));
                retry.setUpdateDt(LocalDateTime.now());
                retry.setDeleted(retry.getId());
                Assert.isTrue((1 == this.retryMapper.updateById((Object)retry) ? 1 : 0) != 0, () -> new SnailJobServerException("\u66f4\u65b0\u91cd\u8bd5\u4efb\u52a1\u5931\u8d25. groupName:[{}]", new Object[]{retry.getGroupName()}));
                this.callbackRetryTaskHandler.create(retry, retrySceneConfig);
            } else if (context.isIncrementRetryCount()) {
                retry.setRetryCount(Integer.valueOf(retry.getRetryCount() + 1));
                retry.setUpdateDt(LocalDateTime.now());
                retry.setDeleted(retry.getId());
                Assert.isTrue((1 == this.retryMapper.updateById((Object)retry) ? 1 : 0) != 0, () -> new SnailJobServerException("\u66f4\u65b0\u91cd\u8bd5\u4efb\u52a1\u5931\u8d25. groupName:[{}]", new Object[]{retry.getGroupName()}));
            }
            RetryTask retryTask = new RetryTask();
            retryTask.setId(context.getRetryTaskId());
            retryTask.setTaskStatus(Optional.ofNullable(context.getTaskStatus()).orElse(RetryTaskStatusEnum.FAIL.getStatus()));
            retryTask.setOperationReason(Optional.ofNullable(context.getOperationReason()).orElse(RetryOperationReasonEnum.NONE.getReason()));
            Assert.isTrue((1 == this.retryTaskMapper.updateById((Object)retryTask) ? 1 : 0) != 0, () -> new SnailJobServerException("\u66f4\u65b0\u91cd\u8bd5\u4efb\u52a1\u5931\u8d25. groupName:[{}]", new Object[]{retry.getGroupName()}));
            RetryTaskFailAlarmEventDTO retryTaskFailAlarmEventDTO = RetryTaskConverter.INSTANCE.toRetryTaskFailAlarmEventDTO(retry, context.getExceptionMsg(), RetryNotifySceneEnum.RETRY_TASK_FAIL_ERROR.getNotifyScene());
            SnailSpringContext.getContext().publishEvent((ApplicationEvent)new RetryTaskFailAlarmEvent(retryTaskFailAlarmEventDTO));
            return null;
        });
    }

    @Generated
    public RetryFailureHandler(AccessTemplate accessTemplate, CallbackRetryTaskHandler callbackRetryTaskHandler, TransactionTemplate transactionTemplate, RetryTaskMapper retryTaskMapper, RetryMapper retryMapper) {
        this.accessTemplate = accessTemplate;
        this.callbackRetryTaskHandler = callbackRetryTaskHandler;
        this.transactionTemplate = transactionTemplate;
        this.retryTaskMapper = retryTaskMapper;
        this.retryMapper = retryMapper;
    }
}

