/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.prepare;

import com.aizuda.snailjob.common.core.enums.JobOperationReasonEnum;
import com.aizuda.snailjob.common.core.enums.RetryOperationReasonEnum;
import com.aizuda.snailjob.common.core.enums.RetryTaskStatusEnum;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.server.retry.task.dto.RetryTaskPrepareDTO;
import com.aizuda.snailjob.server.retry.task.dto.TaskStopJobDTO;
import com.aizuda.snailjob.server.retry.task.support.BlockStrategy;
import com.aizuda.snailjob.server.retry.task.support.RetryPrePareHandler;
import com.aizuda.snailjob.server.retry.task.support.RetryTaskConverter;
import com.aizuda.snailjob.server.retry.task.support.block.BlockStrategyContext;
import com.aizuda.snailjob.server.retry.task.support.block.RetryBlockStrategyFactory;
import com.aizuda.snailjob.server.retry.task.support.handler.RetryTaskStopHandler;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RunningRetryPrepareHandler
implements RetryPrePareHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RunningRetryPrepareHandler.class);
    private final RetryTaskStopHandler retryTaskStopHandler;

    @Override
    public boolean matches(Integer status) {
        return Objects.equals(RetryTaskStatusEnum.RUNNING.getStatus(), status);
    }

    @Override
    public void handle(RetryTaskPrepareDTO prepare) {
        int blockStrategy = prepare.getBlockStrategy();
        JobOperationReasonEnum jobOperationReasonEnum = JobOperationReasonEnum.NONE;
        long delay = DateUtils.toNowMilli() - prepare.getNextTriggerAt();
        if (delay > DateUtils.toEpochMilli((long)prepare.getExecutorTimeout().intValue())) {
            log.info("\u4efb\u52a1\u6267\u884c\u8d85\u65f6.retryTaskId:[{}] delay:[{}] executorTimeout:[{}]", new Object[]{prepare.getRetryTaskId(), delay, DateUtils.toEpochMilli((long)prepare.getExecutorTimeout().intValue())});
            TaskStopJobDTO stopJobDTO = RetryTaskConverter.INSTANCE.toTaskStopJobDTO(prepare);
            stopJobDTO.setOperationReason(RetryOperationReasonEnum.TASK_EXECUTION_TIMEOUT.getReason());
            stopJobDTO.setNeedUpdateTaskStatus(true);
            this.retryTaskStopHandler.stop(stopJobDTO);
        }
        if (prepare.isOnlyTimeoutCheck()) {
            return;
        }
        BlockStrategyContext blockStrategyContext = RetryTaskConverter.INSTANCE.toBlockStrategyContext(prepare);
        blockStrategyContext.setOperationReason(jobOperationReasonEnum.getReason());
        BlockStrategy blockStrategyInterface = RetryBlockStrategyFactory.getBlockStrategy(blockStrategy);
        blockStrategyInterface.block(blockStrategyContext);
    }

    @Generated
    public RunningRetryPrepareHandler(RetryTaskStopHandler retryTaskStopHandler) {
        this.retryTaskStopHandler = retryTaskStopHandler;
    }
}

