/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.listener;

import com.aizuda.snailjob.common.core.alarm.AlarmContext;
import com.aizuda.snailjob.common.core.enums.RetryNotifySceneEnum;
import com.aizuda.snailjob.common.core.util.EnvironmentUtils;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.Lifecycle;
import com.aizuda.snailjob.server.common.alarm.AbstractRetryAlarm;
import com.aizuda.snailjob.server.common.dto.NotifyConfigInfo;
import com.aizuda.snailjob.server.common.dto.RetryAlarmInfo;
import com.aizuda.snailjob.server.common.enums.SyetemTaskTypeEnum;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.server.retry.task.dto.RetryTaskFailAlarmEventDTO;
import com.aizuda.snailjob.server.retry.task.support.RetryTaskConverter;
import com.aizuda.snailjob.server.retry.task.support.event.RetryTaskFailAlarmEvent;
import com.google.common.collect.Lists;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionPhase;
import org.springframework.transaction.event.TransactionalEventListener;

@Component
public class RetryTaskFailAlarmListener
extends AbstractRetryAlarm<RetryTaskFailAlarmEvent>
implements Runnable,
Lifecycle {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RetryTaskFailAlarmListener.class);
    private final LinkedBlockingQueue<RetryTaskFailAlarmEventDTO> queue = new LinkedBlockingQueue(1000);
    private static final String retryTaskDeadTextMessagesFormatter = "<font face=\"\u5fae\u8f6f\u96c5\u9ed1\" color=#ff0000 size=4>{}\u73af\u5883 \u91cd\u8bd5\u4efb\u52a1\u6267\u884c\u5931\u8d25</font>  \n> \u4efb\u52a1\u91cd\u8bd5\u6b21\u6570:{}  \n> \u901a\u77e5\u573a\u666f:{}  \n> \u7a7a\u95f4ID:{}  \n> \u7ec4\u540d\u79f0:{}  \n> \u6267\u884c\u5668\u540d\u79f0:{}  \n> \u573a\u666f\u540d\u79f0:{}  \n> \u4e1a\u52a1\u6570\u636e:{}  \n> \u65f6\u95f4:{}  \n> \u5931\u8d25\u539f\u56e0:{}  \n";

    protected List<SyetemTaskTypeEnum> getSystemTaskType() {
        return Lists.newArrayList((Object[])new SyetemTaskTypeEnum[]{SyetemTaskTypeEnum.RETRY});
    }

    protected List<RetryAlarmInfo> poll() throws InterruptedException {
        RetryTaskFailAlarmEventDTO retryTaskFailAlarmEventDO = this.queue.poll(100L, TimeUnit.MILLISECONDS);
        if (Objects.isNull(retryTaskFailAlarmEventDO)) {
            return Lists.newArrayList();
        }
        ArrayList lists = Lists.newArrayList((Object[])new RetryTaskFailAlarmEventDTO[]{retryTaskFailAlarmEventDO});
        this.queue.drainTo(lists, 200);
        return RetryTaskConverter.INSTANCE.toRetryTaskFailAlarmEventDTO(lists);
    }

    @TransactionalEventListener(fallbackExecution=true, phase=TransactionPhase.AFTER_COMPLETION)
    public void doOnApplicationEvent(RetryTaskFailAlarmEvent retryTaskFailAlarmEvent) {
        if (!this.queue.offer(retryTaskFailAlarmEvent.getRetryTaskFailAlarmEventDTO())) {
            SnailJobLog.LOCAL.warn("\u4efb\u52a1\u91cd\u8bd5\u5931\u8d25\u544a\u8b66\u961f\u5217\u5df2\u6ee1", new Object[0]);
        }
    }

    protected AlarmContext buildAlarmContext(RetryAlarmInfo retryAlarmInfo, NotifyConfigInfo notifyConfig) {
        return AlarmContext.build().text(retryTaskDeadTextMessagesFormatter, new Object[]{EnvironmentUtils.getActiveProfile(), notifyConfig.getNotifyThreshold(), RetryNotifySceneEnum.getRetryNotifyScene((Integer)retryAlarmInfo.getNotifyScene()).getDesc(), retryAlarmInfo.getNamespaceId(), retryAlarmInfo.getGroupName(), retryAlarmInfo.getExecutorName(), retryAlarmInfo.getSceneName(), retryAlarmInfo.getArgsStr(), DateUtils.toNowFormat((DateTimeFormatter)DateUtils.NORM_DATETIME_PATTERN), retryAlarmInfo.getReason()}).title("\u7ec4:[{}] \u573a\u666f:[{}] \u73af\u5883\u91cd\u8bd5\u4efb\u52a1\u5931\u8d25", new Object[]{retryAlarmInfo.getGroupName(), retryAlarmInfo.getSceneName()});
    }

    protected void startLog() {
        SnailJobLog.LOCAL.info("RetryTaskFailAlarmListener started", new Object[0]);
    }

    protected int getNotifyScene() {
        return RetryNotifySceneEnum.RETRY_TASK_FAIL_ERROR.getNotifyScene();
    }
}

