/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.generator.task;

import cn.hutool.core.lang.Assert;
import com.aizuda.snailjob.common.core.enums.RetryTaskStatusEnum;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.server.retry.task.dto.RetryTaskGeneratorDTO;
import com.aizuda.snailjob.server.retry.task.support.RetryTaskConverter;
import com.aizuda.snailjob.server.retry.task.support.timer.RetryTimerContext;
import com.aizuda.snailjob.server.retry.task.support.timer.RetryTimerTask;
import com.aizuda.snailjob.server.retry.task.support.timer.RetryTimerWheel;
import com.aizuda.snailjob.template.datasource.persistence.mapper.RetryTaskMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTask;
import java.time.Duration;
import java.util.Objects;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class RetryTaskGeneratorHandler {
    private final RetryTaskMapper retryTaskMapper;

    public void generateRetryTask(RetryTaskGeneratorDTO generator) {
        RetryTask retryTask = RetryTaskConverter.INSTANCE.toRetryTask(generator);
        Integer taskStatus = generator.getTaskStatus();
        if (Objects.isNull(taskStatus)) {
            taskStatus = RetryTaskStatusEnum.WAITING.getStatus();
        }
        retryTask.setTaskStatus(taskStatus);
        retryTask.setOperationReason(generator.getOperationReason());
        retryTask.setExtAttrs("");
        Assert.isTrue((1 == this.retryTaskMapper.insert((Object)retryTask) ? 1 : 0) != 0, () -> new SnailJobServerException("\u63d2\u5165\u91cd\u8bd5\u4efb\u52a1\u5931\u8d25"));
        if (!RetryTaskStatusEnum.WAITING.getStatus().equals(taskStatus)) {
            return;
        }
        long delay = generator.getNextTriggerAt() - DateUtils.toNowMilli();
        RetryTimerContext timerContext = RetryTaskConverter.INSTANCE.toRetryTimerContext(generator);
        timerContext.setRetryTaskId(retryTask.getId());
        RetryTimerWheel.registerWithRetry(() -> new RetryTimerTask(timerContext), Duration.ofMillis(delay));
    }

    @Generated
    public RetryTaskGeneratorHandler(RetryTaskMapper retryTaskMapper) {
        this.retryTaskMapper = retryTaskMapper;
    }
}

