/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.dispatch.actor.result;

import akka.actor.AbstractActor;
import cn.hutool.core.lang.Assert;
import com.aizuda.snailjob.common.core.context.SnailSpringContext;
import com.aizuda.snailjob.common.core.enums.RetryStatusEnum;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.IdempotentStrategy;
import com.aizuda.snailjob.server.common.config.SystemProperties;
import com.aizuda.snailjob.server.common.enums.SyetemTaskTypeEnum;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.triple.ImmutableTriple;
import com.aizuda.snailjob.server.retry.task.dto.RetryTaskExecutorDTO;
import com.aizuda.snailjob.server.retry.task.dto.RetryTaskFailAlarmEventDTO;
import com.aizuda.snailjob.server.retry.task.support.RetryTaskConverter;
import com.aizuda.snailjob.server.retry.task.support.event.RetryTaskFailAlarmEvent;
import com.aizuda.snailjob.server.retry.task.support.handler.CallbackRetryTaskHandler;
import com.aizuda.snailjob.server.retry.task.support.idempotent.IdempotentHolder;
import com.aizuda.snailjob.template.datasource.access.AccessTemplate;
import com.aizuda.snailjob.template.datasource.persistence.mapper.RetryTaskLogMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.RetrySceneConfig;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTask;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTaskLog;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import java.time.LocalDateTime;
import lombok.Generated;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

@Component(value="FailureActor")
@Scope(value="prototype")
public class FailureActor
extends AbstractActor {
    private final IdempotentStrategy<String> idempotentStrategy = IdempotentHolder.getRetryIdempotent();
    private final AccessTemplate accessTemplate;
    private final CallbackRetryTaskHandler callbackRetryTaskHandler;
    private final TransactionTemplate transactionTemplate;
    private final SystemProperties systemProperties;
    private final RetryTaskLogMapper retryTaskLogMapper;

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(RetryTaskExecutorDTO.class, retryTaskExecutorDTO -> {
            SnailJobLog.LOCAL.debug("FailureActor params:[{}]", new Object[]{retryTaskExecutorDTO});
            final RetryTask retryTask = RetryTaskConverter.INSTANCE.toRetryTask((RetryTaskExecutorDTO)retryTaskExecutorDTO);
            try {
                final RetrySceneConfig retrySceneConfig = this.accessTemplate.getSceneConfigAccess().getSceneConfigByGroupNameAndSceneName(retryTask.getGroupName(), retryTask.getSceneName(), retryTask.getNamespaceId());
                this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult((RetryTaskExecutorDTO)retryTaskExecutorDTO){
                    final /* synthetic */ RetryTaskExecutorDTO val$retryTaskExecutorDTO;
                    {
                        this.val$retryTaskExecutorDTO = retryTaskExecutorDTO;
                    }

                    protected void doInTransactionWithoutResult(TransactionStatus status) {
                        Integer maxRetryCount = SyetemTaskTypeEnum.CALLBACK.getType().equals(retryTask.getTaskType()) ? Integer.valueOf(FailureActor.this.systemProperties.getCallback().getMaxCount()) : retrySceneConfig.getMaxRetryCount();
                        if (maxRetryCount <= retryTask.getRetryCount()) {
                            retryTask.setRetryStatus(RetryStatusEnum.MAX_COUNT.getStatus());
                            FailureActor.this.callbackRetryTaskHandler.create(retryTask);
                        }
                        retryTask.setUpdateDt(LocalDateTime.now());
                        Assert.isTrue((1 == FailureActor.this.accessTemplate.getRetryTaskAccess().updateById(retryTask.getGroupName(), retryTask.getNamespaceId(), (Object)retryTask) ? 1 : 0) != 0, () -> new SnailJobServerException("\u66f4\u65b0\u91cd\u8bd5\u4efb\u52a1\u5931\u8d25. groupName:[{}] uniqueId:[{}]", new Object[]{retryTask.getGroupName(), retryTask.getUniqueId()}));
                        RetryTaskLog retryTaskLog = new RetryTaskLog();
                        retryTaskLog.setRetryStatus(retryTask.getRetryStatus());
                        FailureActor.this.retryTaskLogMapper.update((Object)retryTaskLog, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(RetryTaskLog::getNamespaceId, (Object)retryTask.getNamespaceId())).eq(RetryTaskLog::getUniqueId, (Object)retryTask.getUniqueId())).eq(RetryTaskLog::getGroupName, (Object)retryTask.getGroupName()));
                        RetryTaskFailAlarmEventDTO retryTaskFailAlarmEventDTO = RetryTaskConverter.INSTANCE.toRetryTaskFailAlarmEventDTO(retryTask, this.val$retryTaskExecutorDTO.getReason(), this.val$retryTaskExecutorDTO.getNotifyScene());
                        SnailSpringContext.getContext().publishEvent((ApplicationEvent)new RetryTaskFailAlarmEvent(retryTaskFailAlarmEventDTO));
                    }
                });
            }
            catch (Exception e) {
                SnailJobLog.LOCAL.error("\u66f4\u65b0\u91cd\u8bd5\u4efb\u52a1\u5931\u8d25", new Object[]{e});
            }
            finally {
                this.idempotentStrategy.clear((Object)ImmutableTriple.of((Object)retryTask.getGroupName(), (Object)retryTask.getNamespaceId(), (Object)retryTask.getId()).toString());
                this.getContext().stop(this.getSelf());
            }
        }).build();
    }

    @Generated
    public FailureActor(AccessTemplate accessTemplate, CallbackRetryTaskHandler callbackRetryTaskHandler, TransactionTemplate transactionTemplate, SystemProperties systemProperties, RetryTaskLogMapper retryTaskLogMapper) {
        this.accessTemplate = accessTemplate;
        this.callbackRetryTaskHandler = callbackRetryTaskHandler;
        this.transactionTemplate = transactionTemplate;
        this.systemProperties = systemProperties;
        this.retryTaskLogMapper = retryTaskLogMapper;
    }
}

