/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.dispatch.actor.scan;

import com.aizuda.snailjob.server.common.TimerTask;
import com.aizuda.snailjob.server.common.WaitStrategy;
import com.aizuda.snailjob.server.common.strategy.WaitStrategies;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.server.retry.task.dto.RetryPartitionTask;
import com.aizuda.snailjob.server.retry.task.support.RetryTaskConverter;
import com.aizuda.snailjob.server.retry.task.support.dispatch.actor.scan.AbstractScanGroup;
import com.aizuda.snailjob.server.retry.task.support.dispatch.task.TaskExecutorSceneEnum;
import com.aizuda.snailjob.server.retry.task.support.timer.CallbackTimerTask;
import com.aizuda.snailjob.server.retry.task.support.timer.RetryTimerContext;
import com.aizuda.snailjob.template.datasource.persistence.po.RetrySceneConfig;
import java.time.LocalDateTime;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="ScanCallbackGroupActor")
@Scope(value="prototype")
public class ScanCallbackTaskActor
extends AbstractScanGroup {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScanCallbackTaskActor.class);
    private static final AtomicLong preCostTime = new AtomicLong(0L);
    private static final AtomicLong pullCount = new AtomicLong(1L);
    private static final ConcurrentMap<String, Long> LAST_AT_MAP = new ConcurrentHashMap<String, Long>();

    @Override
    protected TaskExecutorSceneEnum taskActuatorScene() {
        return TaskExecutorSceneEnum.AUTO_CALLBACK;
    }

    @Override
    protected Long getLastId(String groupName) {
        return (Long)LAST_AT_MAP.get(groupName);
    }

    @Override
    protected void putLastId(String groupName, Long lastId) {
        LAST_AT_MAP.put(groupName, lastId);
    }

    @Override
    protected LocalDateTime calculateNextTriggerTime(RetryPartitionTask partitionTask, RetrySceneConfig retrySceneConfig) {
        long triggerInterval = this.systemProperties.getCallback().getTriggerInterval();
        WaitStrategy waitStrategy = WaitStrategies.WaitStrategyEnum.getWaitStrategy((int)WaitStrategies.WaitStrategyEnum.FIXED.getType());
        WaitStrategies.WaitStrategyContext waitStrategyContext = new WaitStrategies.WaitStrategyContext();
        waitStrategyContext.setNextTriggerAt(partitionTask.getNextTriggerAt());
        waitStrategyContext.setTriggerInterval(String.valueOf(triggerInterval));
        return DateUtils.toLocalDateTime((long)waitStrategy.computeTriggerTime(waitStrategyContext));
    }

    @Override
    protected TimerTask<String> timerTask(RetryPartitionTask partitionTask) {
        RetryTimerContext retryTimerContext = RetryTaskConverter.INSTANCE.toRetryTimerContext(partitionTask);
        retryTimerContext.setScene(this.taskActuatorScene());
        return new CallbackTimerTask(retryTimerContext);
    }

    @Override
    protected AtomicLong preCostTime() {
        return preCostTime;
    }

    @Override
    protected AtomicLong prePullCount() {
        return pullCount;
    }
}

