/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.schedule;

import cn.hutool.core.collection.CollUtil;
import com.aizuda.snailjob.common.core.enums.RetryNotifySceneEnum;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.server.common.Lifecycle;
import com.aizuda.snailjob.server.common.dto.PartitionTask;
import com.aizuda.snailjob.server.common.schedule.AbstractSchedule;
import com.aizuda.snailjob.server.common.util.PartitionTaskUtils;
import com.aizuda.snailjob.server.retry.task.dto.NotifyConfigDTO;
import com.aizuda.snailjob.server.retry.task.dto.RetrySceneConfigPartitionTask;
import com.aizuda.snailjob.server.retry.task.support.RetryTaskConverter;
import com.aizuda.snailjob.template.datasource.access.AccessTemplate;
import com.aizuda.snailjob.template.datasource.persistence.mapper.NotifyRecipientMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.NotifyConfig;
import com.aizuda.snailjob.template.datasource.persistence.po.NotifyRecipient;
import com.aizuda.snailjob.template.datasource.persistence.po.RetrySceneConfig;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractRetryTaskAlarmSchedule
extends AbstractSchedule
implements Lifecycle {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractRetryTaskAlarmSchedule.class);
    @Autowired
    protected AccessTemplate accessTemplate;
    @Autowired
    private NotifyRecipientMapper recipientMapper;

    protected void doExecute() {
        PartitionTaskUtils.process(this::queryPartitionList, this::doHandler, (long)0L);
    }

    private void doHandler(List<? extends PartitionTask> partitionTasks) {
        Map<Long, NotifyConfigDTO> notifyConfigInfo = this.getNotifyConfigInfo(partitionTasks);
        if (notifyConfigInfo.isEmpty()) {
            return;
        }
        for (PartitionTask partitionTask : partitionTasks) {
            this.doSendAlarm((RetrySceneConfigPartitionTask)partitionTask, notifyConfigInfo);
        }
    }

    protected abstract void doSendAlarm(RetrySceneConfigPartitionTask var1, Map<Long, NotifyConfigDTO> var2);

    protected abstract RetryNotifySceneEnum getNotifyScene();

    protected List<RetrySceneConfigPartitionTask> queryPartitionList(Long startId) {
        List retrySceneConfigList = this.accessTemplate.getSceneConfigAccess().listPage(new PageDTO(0L, 500L), (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().gt(RetrySceneConfig::getId, (Object)startId)).eq(RetrySceneConfig::getSceneStatus, (Object)StatusEnum.YES.getStatus())).orderByDesc(RetrySceneConfig::getId)).getRecords();
        return RetryTaskConverter.INSTANCE.toRetrySceneConfigPartitionTask(retrySceneConfigList);
    }

    protected Map<Long, NotifyConfigDTO> getNotifyConfigInfo(List<RetrySceneConfigPartitionTask> partitionTasks) {
        Set retryNotifyIds = partitionTasks.stream().map(RetrySceneConfigPartitionTask::getNotifyIds).filter(CollUtil::isNotEmpty).reduce((a, b) -> {
            HashSet set = Sets.newHashSet();
            set.addAll(a);
            set.addAll(b);
            return set;
        }).orElse(new HashSet());
        if (CollUtil.isEmpty((Collection)retryNotifyIds)) {
            return Maps.newHashMap();
        }
        List<NotifyConfigDTO> notifyConfigs = RetryTaskConverter.INSTANCE.toNotifyConfigDTO(this.accessTemplate.getNotifyConfigAccess().list((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(NotifyConfig::getId, (Collection)retryNotifyIds)).eq(NotifyConfig::getNotifyStatus, (Object)StatusEnum.YES.getStatus())).eq(NotifyConfig::getNotifyScene, (Object)this.getNotifyScene().getNotifyScene())).orderByAsc(NotifyConfig::getId)));
        if (CollUtil.isEmpty(notifyConfigs)) {
            return Maps.newHashMap();
        }
        Set recipientIds = notifyConfigs.stream().map(NotifyConfigDTO::getRecipientIds).filter(CollUtil::isNotEmpty).reduce((a, b) -> {
            HashSet set = Sets.newHashSet();
            set.addAll(a);
            set.addAll(b);
            return set;
        }).orElse(new HashSet());
        if (CollUtil.isEmpty((Collection)recipientIds)) {
            return Maps.newHashMap();
        }
        List notifyRecipients = this.recipientMapper.selectByIds((Collection)recipientIds);
        Map recipientMap = StreamUtils.toIdentityMap((Collection)notifyRecipients, NotifyRecipient::getId);
        HashMap notifyConfigMap = Maps.newHashMap();
        for (NotifyConfigDTO notifyConfigDTO : notifyConfigs) {
            List recipientList = StreamUtils.toList(notifyConfigDTO.getRecipientIds(), recipientId -> {
                NotifyRecipient notifyRecipient = (NotifyRecipient)recipientMap.get(recipientId);
                if (Objects.isNull(notifyRecipient)) {
                    return null;
                }
                NotifyConfigDTO.RecipientInfo recipientInfo = new NotifyConfigDTO.RecipientInfo();
                recipientInfo.setNotifyType(notifyRecipient.getNotifyType());
                recipientInfo.setNotifyAttribute(notifyRecipient.getNotifyAttribute());
                return recipientInfo;
            });
            notifyConfigDTO.setRecipientInfos(recipientList);
            notifyConfigMap.put(notifyConfigDTO.getId(), notifyConfigDTO);
        }
        return notifyConfigMap;
    }
}

