/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.dispatch.actor.result;

import akka.actor.AbstractActor;
import cn.hutool.core.lang.Assert;
import com.aizuda.snailjob.common.core.enums.RetryStatusEnum;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.IdempotentStrategy;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.triple.ImmutableTriple;
import com.aizuda.snailjob.server.retry.task.dto.RetryTaskExecutorDTO;
import com.aizuda.snailjob.server.retry.task.support.RetryTaskConverter;
import com.aizuda.snailjob.server.retry.task.support.handler.CallbackRetryTaskHandler;
import com.aizuda.snailjob.server.retry.task.support.idempotent.IdempotentHolder;
import com.aizuda.snailjob.template.datasource.access.AccessTemplate;
import com.aizuda.snailjob.template.datasource.persistence.mapper.RetryTaskLogMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTask;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTaskLog;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import java.time.LocalDateTime;
import lombok.Generated;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

@Component(value="FinishActor")
@Scope(value="prototype")
public class FinishActor
extends AbstractActor {
    private final IdempotentStrategy<String> idempotentStrategy = IdempotentHolder.getRetryIdempotent();
    private final AccessTemplate accessTemplate;
    private final CallbackRetryTaskHandler callbackRetryTaskHandler;
    private final TransactionTemplate transactionTemplate;
    private final RetryTaskLogMapper retryTaskLogMapper;

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(RetryTaskExecutorDTO.class, retryTaskExecutorDTO -> {
            SnailJobLog.LOCAL.debug("FinishActor params:[{}]", new Object[]{retryTaskExecutorDTO});
            final RetryTask retryTask = RetryTaskConverter.INSTANCE.toRetryTask((RetryTaskExecutorDTO)((Object)retryTaskExecutorDTO));
            retryTask.setRetryStatus(RetryStatusEnum.FINISH.getStatus());
            try {
                this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                    protected void doInTransactionWithoutResult(TransactionStatus status) {
                        retryTask.setUpdateDt(LocalDateTime.now());
                        Assert.isTrue((1 == FinishActor.this.accessTemplate.getRetryTaskAccess().updateById(retryTask.getGroupName(), retryTask.getNamespaceId(), (Object)retryTask) ? 1 : 0) != 0, () -> new SnailJobServerException("\u66f4\u65b0\u91cd\u8bd5\u4efb\u52a1\u5931\u8d25. groupName:[{}] uniqueId:[{}]", new Object[]{retryTask.getGroupName(), retryTask.getUniqueId()}));
                        FinishActor.this.callbackRetryTaskHandler.create(retryTask);
                        RetryTaskLog retryTaskLog = new RetryTaskLog();
                        retryTaskLog.setRetryStatus(retryTask.getRetryStatus());
                        FinishActor.this.retryTaskLogMapper.update((Object)retryTaskLog, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(RetryTaskLog::getNamespaceId, (Object)retryTask.getNamespaceId())).eq(RetryTaskLog::getUniqueId, (Object)retryTask.getUniqueId())).eq(RetryTaskLog::getGroupName, (Object)retryTask.getGroupName()));
                    }
                });
            }
            catch (Exception e) {
                SnailJobLog.LOCAL.error("\u66f4\u65b0\u91cd\u8bd5\u4efb\u52a1\u5931\u8d25", new Object[]{e});
            }
            finally {
                this.idempotentStrategy.clear((Object)ImmutableTriple.of((Object)retryTask.getGroupName(), (Object)retryTask.getNamespaceId(), (Object)retryTask.getId()).toString());
                this.getContext().stop(this.getSelf());
            }
        }).build();
    }

    @Generated
    public FinishActor(AccessTemplate accessTemplate, CallbackRetryTaskHandler callbackRetryTaskHandler, TransactionTemplate transactionTemplate, RetryTaskLogMapper retryTaskLogMapper) {
        this.accessTemplate = accessTemplate;
        this.callbackRetryTaskHandler = callbackRetryTaskHandler;
        this.transactionTemplate = transactionTemplate;
        this.retryTaskLogMapper = retryTaskLogMapper;
    }
}

