/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import com.aizuda.snailjob.common.core.enums.RetryStatusEnum;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.server.common.enums.SyetemTaskTypeEnum;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.retry.task.service.RetryDeadLetterConverter;
import com.aizuda.snailjob.server.retry.task.service.RetryService;
import com.aizuda.snailjob.server.retry.task.support.event.RetryTaskFailDeadLetterAlarmEvent;
import com.aizuda.snailjob.template.datasource.access.AccessTemplate;
import com.aizuda.snailjob.template.datasource.access.TaskAccess;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryDeadLetter;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTask;
import com.aizuda.snailjob.template.datasource.utils.RequestDataHelper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RetryServiceImpl
implements RetryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RetryServiceImpl.class);
    @Autowired
    private AccessTemplate accessTemplate;
    @Autowired
    private ApplicationContext context;

    @Override
    @Transactional
    public Boolean moveDeadLetterAndDelFinish(String groupName, String namespaceId) {
        Set finishCallbackRetryIdList;
        TaskAccess retryTaskAccess = this.accessTemplate.getRetryTaskAccess();
        RequestDataHelper.setPartition((String)groupName, (String)namespaceId);
        List callbackRetryTasks = retryTaskAccess.listPage(groupName, namespaceId, new PageDTO(0L, 100L), (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetryTask::getNamespaceId, (Object)namespaceId)).in(RetryTask::getRetryStatus, new Object[]{RetryStatusEnum.MAX_COUNT.getStatus(), RetryStatusEnum.FINISH.getStatus()})).eq(RetryTask::getTaskType, (Object)SyetemTaskTypeEnum.CALLBACK.getType())).eq(RetryTask::getGroupName, (Object)groupName)).orderByDesc(RetryTask::getId)).getRecords();
        if (CollUtil.isEmpty((Collection)callbackRetryTasks)) {
            return Boolean.TRUE;
        }
        Set uniqueIdSet = StreamUtils.toSet((Collection)callbackRetryTasks, callbackTask -> {
            String callbackTaskUniqueId = callbackTask.getUniqueId();
            return callbackTaskUniqueId.substring(callbackTaskUniqueId.lastIndexOf("_") + 1);
        });
        List retryTasks = this.accessTemplate.getRetryTaskAccess().list(groupName, namespaceId, (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetryTask::getNamespaceId, (Object)namespaceId)).eq(RetryTask::getTaskType, (Object)SyetemTaskTypeEnum.RETRY.getType())).in(RetryTask::getUniqueId, (Collection)uniqueIdSet));
        ArrayList<RetryTask> waitMoveDeadLetters = new ArrayList<RetryTask>();
        List maxCountRetryTaskList = retryTasks.stream().filter(retryTask -> retryTask.getRetryStatus().equals(RetryStatusEnum.MAX_COUNT.getStatus())).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(maxCountRetryTaskList)) {
            waitMoveDeadLetters.addAll(maxCountRetryTaskList);
        }
        List maxCountCallbackRetryTaskList = callbackRetryTasks.stream().filter(retryTask -> retryTask.getRetryStatus().equals(RetryStatusEnum.MAX_COUNT.getStatus())).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(maxCountRetryTaskList)) {
            waitMoveDeadLetters.addAll(maxCountCallbackRetryTaskList);
        }
        this.moveDeadLetters(groupName, namespaceId, waitMoveDeadLetters);
        HashSet waitDelRetryFinishSet = new HashSet();
        Set finishRetryIdList = retryTasks.stream().filter(retryTask -> retryTask.getRetryStatus().equals(RetryStatusEnum.FINISH.getStatus())).map(RetryTask::getId).collect(Collectors.toSet());
        if (CollUtil.isNotEmpty(finishRetryIdList)) {
            waitDelRetryFinishSet.addAll(finishRetryIdList);
        }
        if (CollUtil.isNotEmpty(finishCallbackRetryIdList = callbackRetryTasks.stream().filter(retryTask -> retryTask.getRetryStatus().equals(RetryStatusEnum.FINISH.getStatus())).map(RetryTask::getId).collect(Collectors.toSet()))) {
            waitDelRetryFinishSet.addAll(finishCallbackRetryIdList);
        }
        if (CollUtil.isEmpty(waitDelRetryFinishSet)) {
            return Boolean.TRUE;
        }
        Assert.isTrue((waitDelRetryFinishSet.size() == this.accessTemplate.getRetryTaskAccess().delete(groupName, namespaceId, (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetryTask::getNamespaceId, (Object)namespaceId)).eq(RetryTask::getGroupName, (Object)groupName)).in(RetryTask::getId, waitDelRetryFinishSet)) ? 1 : 0) != 0, () -> new SnailJobServerException("\u5220\u9664\u91cd\u8bd5\u6570\u636e\u5931\u8d25 [{}]", new Object[]{JsonUtil.toJsonString((Object)retryTasks)}));
        return Boolean.TRUE;
    }

    private void moveDeadLetters(String groupName, String namespaceId, List<RetryTask> retryTasks) {
        if (CollUtil.isEmpty(retryTasks)) {
            return;
        }
        List<RetryDeadLetter> retryDeadLetters = RetryDeadLetterConverter.INSTANCE.toRetryDeadLetter(retryTasks);
        LocalDateTime now = LocalDateTime.now();
        for (RetryDeadLetter retryDeadLetter : retryDeadLetters) {
            retryDeadLetter.setCreateDt(now);
        }
        Assert.isTrue((retryDeadLetters.size() == this.accessTemplate.getRetryDeadLetterAccess().insertBatch(groupName, namespaceId, retryDeadLetters) ? 1 : 0) != 0, () -> new SnailJobServerException("\u63d2\u5165\u6b7b\u4fe1\u961f\u5217\u5931\u8d25 [{}]", new Object[]{JsonUtil.toJsonString((Object)retryDeadLetters)}));
        TaskAccess retryTaskAccess = this.accessTemplate.getRetryTaskAccess();
        Assert.isTrue((retryTasks.size() == retryTaskAccess.delete(groupName, namespaceId, (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetryTask::getNamespaceId, (Object)namespaceId)).eq(RetryTask::getGroupName, (Object)groupName)).in(RetryTask::getId, (Collection)StreamUtils.toList(retryTasks, RetryTask::getId))) ? 1 : 0) != 0, () -> new SnailJobServerException("\u5220\u9664\u91cd\u8bd5\u6570\u636e\u5931\u8d25 [{}]", new Object[]{JsonUtil.toJsonString((Object)retryTasks)}));
        this.context.publishEvent((ApplicationEvent)new RetryTaskFailDeadLetterAlarmEvent(retryDeadLetters));
    }
}

